/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.rest;

import freemarker.ext.beans.BeanModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.util.List;
import org.alfresco.cmis.CMISDictionaryService;
import org.alfresco.cmis.CMISScope;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.repo.template.TemplateAssociation;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.service.namespace.QName;

public class CMISTypeDefinitionMethod
implements TemplateMethodModelEx {
    private static CMISScope[] EMPTY_SCOPES = new CMISScope[0];
    private CMISDictionaryService dictionaryService;

    public CMISTypeDefinitionMethod(CMISDictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public Object exec(List args) throws TemplateModelException {
        Object arg0;
        CMISTypeDefinition result = null;
        if (args.size() == 1 && (arg0 = args.get(0)) instanceof BeanModel) {
            CMISScope[] matchingScopes = EMPTY_SCOPES;
            QName nodeType = null;
            Object wrapped = ((BeanModel)arg0).getWrappedObject();
            if (wrapped != null) {
                if (wrapped instanceof TemplateNode) {
                    nodeType = ((TemplateNode)wrapped).getType();
                } else if (wrapped instanceof TemplateAssociation) {
                    nodeType = ((TemplateAssociation)wrapped).getTypeQName();
                    matchingScopes = new CMISScope[]{CMISScope.RELATIONSHIP};
                } else if (wrapped instanceof QName) {
                    nodeType = (QName)wrapped;
                } else if (wrapped instanceof CMISTypeDefinition) {
                    result = ((CMISTypeDefinition)wrapped).getBaseType();
                }
            }
            if (nodeType != null) {
                result = this.dictionaryService.findTypeForClass(nodeType, matchingScopes);
            }
        }
        return result;
    }
}

