/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.ws;

import java.util.List;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.handler.WSHandlerResult;

public class AuthenticationInterceptor
extends AbstractSoapInterceptor {
    private AuthenticationService authenticationService;
    private TransactionService transactionService;

    public AuthenticationInterceptor() {
        super("pre-invoke");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        WSHandlerResult handlerResult = (WSHandlerResult)((List)message.getContextualProperty("RECV_RESULTS")).get(0);
        WSSecurityEngineResult secRes = (WSSecurityEngineResult)handlerResult.getResults().get(0);
        final WSUsernameTokenPrincipal principal = (WSUsernameTokenPrincipal)secRes.get((Object)"principal");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                try {
                    AuthenticationInterceptor.this.authenticationService.authenticate(principal.getName(), principal.getPassword().toCharArray());
                }
                catch (Throwable e) {
                    throw new SecurityException("Invalid user name or password specified");
                }
                return null;
            }
        });
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }
}

