/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.ws;

import java.util.Collections;
import java.util.List;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.alfresco.cmis.CMISServiceException;
import org.alfresco.repo.cmis.ws.CmisException;
import org.alfresco.repo.cmis.ws.CmisExtensionType;
import org.alfresco.repo.cmis.ws.CmisObjectType;
import org.alfresco.repo.cmis.ws.DMAbstractServicePort;
import org.alfresco.repo.cmis.ws.PolicyServicePort;
import org.alfresco.repo.cmis.ws.utils.ExceptionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(name="PolicyServicePort", serviceName="PolicyService", portName="PolicyServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", endpointInterface="org.alfresco.repo.cmis.ws.PolicyServicePort")
public class DMPolicyServicePort
extends DMAbstractServicePort
implements PolicyServicePort {
    @Override
    public void applyPolicy(String repositoryId, String policyId, String objectId, Holder<CmisExtensionType> extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        try {
            this.cmisService.applyPolicy(policyId, objectId);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    @Override
    public List<CmisObjectType> getAppliedPolicies(String repositoryId, String objectId, String filter, CmisExtensionType extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        try {
            this.cmisService.getAppliedPolicies(objectId, filter);
            return Collections.emptyList();
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    @Override
    public void removePolicy(String repositoryId, String policyId, String objectId, Holder<CmisExtensionType> extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        try {
            this.cmisService.removePolicy(policyId, objectId);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }
}

