/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.ws;

import java.util.LinkedList;
import java.util.List;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.alfresco.cmis.CMISContentStreamAllowedEnum;
import org.alfresco.cmis.CMISServiceException;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.PropertyFilter;
import org.alfresco.repo.cmis.ws.CmisAccessControlListType;
import org.alfresco.repo.cmis.ws.CmisContentStreamType;
import org.alfresco.repo.cmis.ws.CmisException;
import org.alfresco.repo.cmis.ws.CmisExtensionType;
import org.alfresco.repo.cmis.ws.CmisObjectType;
import org.alfresco.repo.cmis.ws.CmisPropertiesType;
import org.alfresco.repo.cmis.ws.DMAbstractServicePort;
import org.alfresco.repo.cmis.ws.EnumACLPropagation;
import org.alfresco.repo.cmis.ws.EnumIncludeRelationships;
import org.alfresco.repo.cmis.ws.EnumServiceException;
import org.alfresco.repo.cmis.ws.VersioningServicePort;
import org.alfresco.repo.cmis.ws.utils.ExceptionUtil;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(name="VersioningServicePort", serviceName="VersioningService", portName="VersioningServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", endpointInterface="org.alfresco.repo.cmis.ws.VersioningServicePort")
public class DMVersioningServicePort
extends DMAbstractServicePort
implements VersioningServicePort {
    @Override
    public void cancelCheckOut(String repositoryId, String objectId, Holder<CmisExtensionType> extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        try {
            this.cmisService.cancelCheckOut(objectId);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    @Override
    public void checkIn(String repositoryId, Holder<String> objectId, Boolean major, CmisPropertiesType properties, CmisContentStreamType contentStream, String checkinComment, List<String> policies, CmisAccessControlListType addACEs, CmisAccessControlListType removeACEs, Holder<CmisExtensionType> extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        try {
            NodeRef workingCopyNodeRef = (NodeRef)this.cmisService.getObject((String)objectId.value, NodeRef.class, true, true, true);
            CMISTypeDefinition seriesObjectTypeDefinition = this.cmisService.getTypeDefinition(workingCopyNodeRef);
            if (null != contentStream && CMISContentStreamAllowedEnum.NOT_ALLOWED == seriesObjectTypeDefinition.getContentStreamAllowed()) {
                throw ExceptionUtil.createCmisException("Content stream is not allowed", EnumServiceException.STREAM_NOT_SUPPORTED);
            }
            if (contentStream != null) {
                try {
                    ContentWriter writer = this.fileFolderService.getWriter(workingCopyNodeRef);
                    writer.setMimetype(contentStream.getMimeType());
                    writer.putContent(contentStream.getStream().getInputStream());
                }
                catch (Exception e) {
                    throw ExceptionUtil.createCmisException("Exception while updating content stream", EnumServiceException.RUNTIME, e);
                }
            }
            this.propertiesUtil.setProperties(workingCopyNodeRef, properties, null);
            NodeRef nodeRef = this.cmisService.checkIn((String)objectId.value, checkinComment, major == null || major != false);
            this.applyAclCarefully(nodeRef, addACEs, removeACEs, EnumACLPropagation.PROPAGATE, policies);
            objectId.value = this.propertiesUtil.getProperty(nodeRef, "cmis:objectId", objectId.value);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    @Override
    public void checkOut(String repositoryId, Holder<String> objectId, Holder<CmisExtensionType> extension, Holder<Boolean> contentCopied) throws CmisException {
        this.checkRepositoryId(repositoryId);
        try {
            NodeRef pwcNodeRef = this.cmisService.checkOut((String)objectId.value);
            objectId.value = this.propertiesUtil.getProperty(pwcNodeRef, "cmis:objectId", objectId.value);
            contentCopied.value = null != this.fileFolderService.getReader(pwcNodeRef);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    @Override
    public List<CmisObjectType> getAllVersions(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, CmisExtensionType extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        PropertyFilter propertyFilter = this.createPropertyFilter(filter);
        LinkedList<CmisObjectType> objects = new LinkedList<CmisObjectType>();
        try {
            for (NodeRef nodeRef : this.cmisService.getAllVersions(objectId)) {
                objects.add(this.createCmisObject((Object)nodeRef, propertyFilter, (EnumIncludeRelationships)null, includeAllowableActions, (String)null));
            }
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
        return objects;
    }

    @Override
    public CmisPropertiesType getPropertiesOfLatestVersion(String repositoryId, String objectId, Boolean major, String filter, CmisExtensionType extension) throws CmisException {
        NodeRef latestVersionNodeRef;
        this.checkRepositoryId(repositoryId);
        try {
            latestVersionNodeRef = this.cmisService.getLatestVersion(objectId, major != null && major != false);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
        PropertyFilter propertyFilter = this.createPropertyFilter(filter);
        return this.propertiesUtil.getProperties(latestVersionNodeRef, propertyFilter);
    }

    @Override
    public CmisObjectType getObjectOfLatestVersion(String repositoryId, String objectId, Boolean major, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, CmisExtensionType extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        try {
            NodeRef latestVersionNodeRef = this.cmisService.getLatestVersion(objectId, major != null && major != false);
            PropertyFilter propertyFilter = this.createPropertyFilter(filter);
            CmisObjectType result = this.createCmisObject((Object)latestVersionNodeRef, propertyFilter, includeRelationships, includeAllowableActions, renditionFilter);
            if (includeACL.booleanValue()) {
                this.appendWithAce((NodeRef)this.cmisService.getVersionSeries(objectId, NodeRef.class, false), result);
            }
            return result;
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }
}

