/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.ws.test;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.Holder;
import org.alfresco.repo.cmis.ws.Aspects;
import org.alfresco.repo.cmis.ws.CmisExtensionType;
import org.alfresco.repo.cmis.ws.CmisPropertiesType;
import org.alfresco.repo.cmis.ws.CmisProperty;
import org.alfresco.repo.cmis.ws.CmisPropertyString;
import org.alfresco.repo.cmis.ws.SetAspects;
import org.alfresco.repo.cmis.ws.test.BaseCMISTest;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectTest
extends BaseCMISTest {
    public void testAspectSet() throws Exception {
        Holder objectId = new Holder();
        this.objectServicePort.createDocument(this.repositoryId, this.createObjectProperties(this.getName(), "cmis:document"), this.testFolderId, null, null, null, null, null, (Holder<CmisExtensionType>)new Holder(), (Holder<String>)objectId);
        Assert.assertNotNull((Object)objectId.value);
        this.versioningServicePort.checkOut(this.repositoryId, (Holder<String>)objectId, (Holder<CmisExtensionType>)new Holder(), (Holder<Boolean>)new Holder());
        Assert.assertNotNull((Object)objectId.value);
        CmisPropertiesType properties = new CmisPropertiesType();
        SetAspects extension = new SetAspects();
        properties.getAny().add(extension);
        extension.getAspectsToAdd().addAll(Arrays.asList("P:cm:syndication", "P:cm:summarizable"));
        CmisPropertiesType extensionProperties = new CmisPropertiesType();
        extension.setProperties(extensionProperties);
        this.setStringProperty(extensionProperties, "cm:summary", "Aspect Test (summary)");
        this.setStringProperty(extensionProperties, "cm:author", "David Ward");
        this.objectServicePort.updateProperties(this.repositoryId, (Holder<String>)objectId, null, properties, null);
        CmisPropertiesType updated = this.objectServicePort.getProperties(this.repositoryId, (String)objectId.value, null, null);
        HashSet<String> appliedAspects = new HashSet<String>(5);
        HashMap<String, String> aspectProperties = new HashMap<String, String>(11);
        this.extractAspectsAndProperties(updated, appliedAspects, aspectProperties);
        this.assertContains(appliedAspects, "P:cm:syndication", "P:cm:summarizable", "P:cm:author");
        AspectTest.assertEquals((String)"Aspect Test (summary)", (String)((String)aspectProperties.get("cm:summary")));
        AspectTest.assertEquals((String)"David Ward", (String)((String)aspectProperties.get("cm:author")));
        properties = new CmisPropertiesType();
        extension = new SetAspects();
        properties.getAny().add(extension);
        extension.getAspectsToAdd().add("P:cm:countable");
        extension.getAspectsToRemove().add("P:cm:author");
        extensionProperties = new CmisPropertiesType();
        extension.setProperties(extensionProperties);
        this.setStringProperty(extensionProperties, "cm:summary", "Aspect Test (new summary)");
        this.versioningServicePort.checkIn(this.repositoryId, (Holder<String>)objectId, null, properties, null, null, null, null, null, (Holder<CmisExtensionType>)new Holder());
        CmisPropertiesType checkedIn = this.objectServicePort.getProperties(this.repositoryId, (String)objectId.value, null, null);
        appliedAspects = new HashSet(5);
        aspectProperties = new HashMap(11);
        this.extractAspectsAndProperties(checkedIn, appliedAspects, aspectProperties);
        this.assertContains(appliedAspects, "P:cm:syndication", "P:cm:summarizable", "P:cm:countable");
        this.assertDoesNotContain(appliedAspects, "P:cm:author");
        AspectTest.assertEquals((String)"Aspect Test (new summary)", (String)((String)aspectProperties.get("cm:summary")));
        AspectTest.assertNull(aspectProperties.get("cm:author"));
    }

    private void extractAspectsAndProperties(CmisPropertiesType properties, Set<String> appliedAspects, Map<String, String> aspectProperties) {
        Aspects extension = null;
        for (Object object : properties.getAny()) {
            if (!(object instanceof Aspects)) continue;
            extension = (Aspects)object;
            break;
        }
        if (extension == null) {
            AspectTest.fail((String)"alf:aspects element not included");
        }
        appliedAspects.addAll(extension.getAppliedAspects());
        CmisPropertiesType extensionProperties = extension.getProperties();
        if (extensionProperties == null) {
            return;
        }
        for (CmisProperty property : extensionProperties.getProperty()) {
            if (!(property instanceof CmisPropertyString)) continue;
            aspectProperties.put(property.getPropertyDefinitionId(), ((CmisPropertyString)property).getValue().get(0));
        }
    }
}

