/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantDeployer;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.springframework.extensions.webscripts.AbstractStore;
import org.springframework.extensions.webscripts.ScriptContent;
import org.springframework.extensions.webscripts.ScriptLoader;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptException;

public class RepoStore
extends AbstractStore
implements TenantDeployer {
    protected boolean mustExist = false;
    protected StoreRef repoStore;
    protected String repoPath;
    protected Map<String, NodeRef> baseNodeRefs;
    protected RetryingTransactionHelper retryingTransactionHelper;
    protected SearchService searchService;
    protected NodeService nodeService;
    protected ContentService contentService;
    protected FileFolderService fileService;
    protected NamespaceService namespaceService;
    protected PermissionService permissionService;
    protected TenantAdminService tenantAdminService;

    public void setTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setFileFolderService(FileFolderService fileService) {
        this.fileService = fileService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setMustExist(boolean mustExist) {
        this.mustExist = mustExist;
    }

    public void setStore(String repoStore) {
        this.repoStore = new StoreRef(repoStore);
    }

    public void setPath(String repoPath) {
        this.repoPath = repoPath;
    }

    public void init() {
        if (this.baseNodeRefs == null) {
            this.baseNodeRefs = new HashMap<String, NodeRef>(1);
        }
    }

    public void destroy() {
        this.baseNodeRefs.remove(this.tenantAdminService.getCurrentUserDomain());
    }

    private NodeRef getBaseNodeRef() {
        String tenantDomain = this.tenantAdminService.getCurrentUserDomain();
        NodeRef baseNodeRef = this.baseNodeRefs.get(tenantDomain);
        if (baseNodeRef == null) {
            baseNodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    return (NodeRef)RepoStore.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                        public NodeRef execute() throws Exception {
                            NodeRef repoStoreRootNodeRef = RepoStore.this.nodeService.getRootNode(RepoStore.this.repoStore);
                            List nodeRefs = RepoStore.this.searchService.selectNodes(repoStoreRootNodeRef, RepoStore.this.repoPath, new QueryParameterDefinition[0], (NamespacePrefixResolver)RepoStore.this.namespaceService, false, "xpath");
                            if (nodeRefs.size() == 1) {
                                return (NodeRef)nodeRefs.get(0);
                            }
                            if (nodeRefs.size() > 1) {
                                throw new WebScriptException("Web Script Store " + RepoStore.this.repoStore.toString() + RepoStore.this.repoPath + " must exist; multiple entries found.");
                            }
                            throw new WebScriptException("Web Script Store " + RepoStore.this.repoStore.toString() + RepoStore.this.repoPath + " must exist; it was not found");
                        }
                    }, true, false);
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            this.baseNodeRefs.put(tenantDomain, baseNodeRef);
        }
        return baseNodeRef;
    }

    private String getBaseDir() {
        return this.getPath(this.getBaseNodeRef());
    }

    public boolean isSecure() {
        return false;
    }

    public boolean exists() {
        return this.getBaseNodeRef() != null;
    }

    public String getBasePath() {
        return this.repoStore.toString() + this.repoPath;
    }

    protected String getPath(NodeRef nodeRef) {
        return this.nodeService.getPath(nodeRef).toDisplayPath(this.nodeService, this.permissionService) + "/" + this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME);
    }

    protected NodeRef findNodeRef(String documentPath) {
        NodeRef node = null;
        try {
            String[] pathElements = documentPath.split("/");
            List<String> pathElementsList = Arrays.asList(pathElements);
            FileInfo file = this.fileService.resolveNamePath(this.getBaseNodeRef(), pathElementsList);
            node = file.getNodeRef();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return node;
    }

    public String[] getScriptDocumentPaths(final WebScript script) {
        return (String[])AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String[]>(){

            public String[] doWork() throws Exception {
                return (String[])RepoStore.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String[]>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public String[] execute() throws Exception {
                        NodeRef scriptNodeRef;
                        int baseDirLength = RepoStore.this.getBaseDir().length() + 1;
                        ArrayList<String> documentPaths = null;
                        String scriptPath = script.getDescription().getScriptPath();
                        NodeRef nodeRef = scriptNodeRef = scriptPath.length() == 0 ? RepoStore.this.getBaseNodeRef() : RepoStore.this.findNodeRef(scriptPath);
                        if (scriptNodeRef != null) {
                            Path repoScriptPath = RepoStore.this.nodeService.getPath(scriptNodeRef);
                            String id = script.getDescription().getId().substring(scriptPath.length() + (scriptPath.length() > 0 ? 1 : 0));
                            String query = "+PATH:\"" + repoScriptPath.toPrefixString((NamespacePrefixResolver)RepoStore.this.namespaceService) + "//*\" +QNAME:" + id + "*";
                            ResultSet resultSet = RepoStore.this.searchService.query(RepoStore.this.repoStore, "lucene", query);
                            try {
                                documentPaths = new ArrayList<String>(resultSet.length());
                                List nodes = resultSet.getNodeRefs();
                                for (NodeRef nodeRef2 : nodes) {
                                    String name = (String)((Object)RepoStore.this.nodeService.getProperty(nodeRef2, ContentModel.PROP_NAME));
                                    if (!name.startsWith(id)) continue;
                                    String nodeDir = RepoStore.this.getPath(nodeRef2);
                                    String documentPath = nodeDir.substring(baseDirLength);
                                    documentPaths.add(documentPath);
                                }
                            }
                            finally {
                                resultSet.close();
                            }
                        }
                        return documentPaths != null ? documentPaths.toArray(new String[documentPaths.size()]) : new String[]{};
                    }
                }, true, false);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public String[] getDocumentPaths(String path, boolean includeSubPaths, String documentPattern) {
        if (documentPattern == null || documentPattern.length() == 0) {
            documentPattern = "*";
        }
        String matcher = documentPattern.replace(".", "\\.").replace("*", ".*");
        final Pattern pattern = Pattern.compile(matcher);
        String encPath = RepoStore.encodePathISO9075(path);
        final StringBuilder query = new StringBuilder(128);
        query.append("+PATH:\"").append(this.repoPath).append(encPath.length() != 0 ? '/' + encPath : "").append(includeSubPaths ? Character.valueOf('/') : "").append("/*\" +QNAME:").append(documentPattern);
        return (String[])AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String[]>(){

            public String[] doWork() throws Exception {
                return (String[])RepoStore.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String[]>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public String[] execute() throws Exception {
                        ArrayList<String> documentPaths;
                        int baseDirLength = RepoStore.this.getBaseDir().length() + 1;
                        ResultSet resultSet = RepoStore.this.searchService.query(RepoStore.this.repoStore, "lucene", query.toString());
                        try {
                            documentPaths = new ArrayList<String>(resultSet.length());
                            List nodes = resultSet.getNodeRefs();
                            for (NodeRef nodeRef : nodes) {
                                String name = (String)((Object)RepoStore.this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                                if (!pattern.matcher(name).matches()) continue;
                                String nodeDir = RepoStore.this.getPath(nodeRef);
                                String documentPath = nodeDir.substring(baseDirLength);
                                documentPaths.add(documentPath);
                            }
                        }
                        finally {
                            resultSet.close();
                        }
                        return documentPaths.toArray(new String[documentPaths.size()]);
                    }
                }, true, false);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public static String encodePathISO9075(String path) {
        if (path == null || path.length() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(path.length() + 16);
        StringTokenizer t = new StringTokenizer(path, "/");
        while (t.hasMoreTokens()) {
            result.append(ISO9075.encode((String)t.nextToken()));
            if (!t.hasMoreTokens()) continue;
            result.append('/');
        }
        return result.toString();
    }

    public String[] getDescriptionDocumentPaths() {
        return this.getDocumentPaths("/", true, "*.desc.xml");
    }

    public String[] getAllDocumentPaths() {
        return (String[])AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String[]>(){

            public String[] doWork() throws Exception {
                return (String[])RepoStore.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String[]>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public String[] execute() throws Exception {
                        ArrayList<String> documentPaths;
                        int baseDirLength = RepoStore.this.getBaseDir().length() + 1;
                        String query = "+PATH:\"" + RepoStore.this.repoPath + "//*\" +TYPE:\"{http://www.alfresco.org/model/content/1.0}content\"";
                        ResultSet resultSet = RepoStore.this.searchService.query(RepoStore.this.repoStore, "lucene", query);
                        try {
                            documentPaths = new ArrayList<String>(resultSet.length());
                            List nodes = resultSet.getNodeRefs();
                            for (NodeRef nodeRef : nodes) {
                                String nodeDir = RepoStore.this.getPath(nodeRef);
                                documentPaths.add(nodeDir.substring(baseDirLength));
                            }
                        }
                        finally {
                            resultSet.close();
                        }
                        return documentPaths.toArray(new String[documentPaths.size()]);
                    }
                }, true, false);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public long lastModified(final String documentPath) throws IOException {
        return (Long)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Long>(){

            public Long doWork() throws Exception {
                return (Long)RepoStore.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                    public Long execute() throws Exception {
                        ContentReader reader = RepoStore.this.contentService.getReader(RepoStore.this.findNodeRef(documentPath), ContentModel.PROP_CONTENT);
                        return reader.getLastModified();
                    }
                }, true, false);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public boolean hasDocument(final String documentPath) {
        return (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                return (Boolean)RepoStore.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

                    public Boolean execute() throws Exception {
                        NodeRef nodeRef = RepoStore.this.findNodeRef(documentPath);
                        return nodeRef != null;
                    }
                }, true, false);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public InputStream getDocument(final String documentPath) throws IOException {
        return (InputStream)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<InputStream>(){

            public InputStream doWork() throws Exception {
                return (InputStream)RepoStore.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<InputStream>(){

                    public InputStream execute() throws Exception {
                        NodeRef nodeRef = RepoStore.this.findNodeRef(documentPath);
                        if (nodeRef == null) {
                            throw new IOException("Document " + documentPath + " does not exist.");
                        }
                        ContentReader reader = RepoStore.this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
                        if (reader == null || !reader.exists()) {
                            throw new IOException("Failed to read content at " + documentPath + " (content reader does not exist)");
                        }
                        return reader.getContentInputStream();
                    }
                }, true, false);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public void createDocument(String documentPath, String content) throws IOException {
        String[] pathElements = documentPath.split("/");
        String[] folderElements = new String[pathElements.length - 1];
        System.arraycopy(pathElements, 0, folderElements, 0, pathElements.length - 1);
        List<String> folderElementsList = Arrays.asList(folderElements);
        FileInfo pathInfo = folderElementsList.size() == 0 ? this.fileService.getFileInfo(this.getBaseNodeRef()) : FileFolderServiceImpl.makeFolders((FileFolderService)this.fileService, (NodeRef)this.getBaseNodeRef(), folderElementsList, (QName)ContentModel.TYPE_FOLDER);
        String fileName = pathElements[pathElements.length - 1];
        if (this.fileService.searchSimple(pathInfo.getNodeRef(), fileName) != null) {
            throw new IOException("Document " + documentPath + " already exists");
        }
        FileInfo fileInfo = this.fileService.create(pathInfo.getNodeRef(), fileName, ContentModel.TYPE_CONTENT);
        ContentWriter writer = this.fileService.getWriter(fileInfo.getNodeRef());
        writer.putContent(content);
    }

    public void updateDocument(String documentPath, String content) throws IOException {
        String fileName;
        String[] pathElements = documentPath.split("/");
        NodeRef parentRef = pathElements.length == 1 ? this.getBaseNodeRef() : this.findNodeRef(documentPath.substring(0, documentPath.lastIndexOf(47)));
        if (this.fileService.searchSimple(parentRef, fileName = pathElements[pathElements.length - 1]) == null) {
            throw new IOException("Document " + documentPath + " does not exists");
        }
        FileInfo fileInfo = this.fileService.create(parentRef, fileName, ContentModel.TYPE_CONTENT);
        ContentWriter writer = this.fileService.getWriter(fileInfo.getNodeRef());
        writer.putContent(content);
    }

    public boolean removeDocument(String documentPath) throws IOException {
        return false;
    }

    public TemplateLoader getTemplateLoader() {
        return new RepoTemplateLoader();
    }

    public ScriptLoader getScriptLoader() {
        return new RepoScriptLoader();
    }

    public void onEnableTenant() {
        this.init();
    }

    public void onDisableTenant() {
        this.destroy();
    }

    public String toString() {
        return this.repoPath;
    }

    private class RepoScriptContent
    implements ScriptContent {
        protected String path;
        protected NodeRef nodeRef;

        public RepoScriptContent(String path, NodeRef nodeRef) {
            this.path = path;
            this.nodeRef = nodeRef;
        }

        public InputStream getInputStream() {
            return (InputStream)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<InputStream>(){

                public InputStream doWork() throws Exception {
                    return (InputStream)RepoStore.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<InputStream>(){

                        public InputStream execute() throws Exception {
                            ContentReader reader = RepoStore.this.contentService.getReader(RepoScriptContent.this.nodeRef, ContentModel.PROP_CONTENT);
                            return reader.getContentInputStream();
                        }
                    });
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }

        public Reader getReader() {
            ContentReader reader = RepoStore.this.contentService.getReader(this.nodeRef, ContentModel.PROP_CONTENT);
            try {
                return new InputStreamReader(this.getInputStream(), reader.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new AlfrescoRuntimeException("Unsupported Encoding", (Throwable)e);
            }
        }

        public String getPath() {
            return RepoStore.this.repoStore + RepoStore.this.getBaseDir() + "/" + this.path;
        }

        public String getPathDescription() {
            return "/" + this.path + " (in repository store " + RepoStore.this.repoStore.toString() + RepoStore.this.getBaseDir() + ")";
        }

        public boolean isCachable() {
            return false;
        }

        public boolean isSecure() {
            return false;
        }
    }

    private class RepoScriptLoader
    implements ScriptLoader {
        private RepoScriptLoader() {
        }

        public ScriptContent getScript(final String path) {
            return (ScriptContent)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<ScriptContent>(){

                public ScriptContent doWork() throws Exception {
                    return (ScriptContent)RepoStore.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<ScriptContent>(){

                        public ScriptContent execute() throws Exception {
                            RepoScriptContent location = null;
                            NodeRef nodeRef = RepoStore.this.findNodeRef(path);
                            if (nodeRef != null) {
                                location = new RepoScriptContent(path, nodeRef);
                            }
                            return location;
                        }
                    }, true, false);
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    private class RepoTemplateSource {
        protected final NodeRef nodeRef;

        private RepoTemplateSource(NodeRef ref) {
            this.nodeRef = ref;
        }

        public boolean equals(Object o) {
            if (o instanceof RepoTemplateSource) {
                return this.nodeRef.equals((Object)((RepoTemplateSource)o).nodeRef);
            }
            return false;
        }

        public int hashCode() {
            return this.nodeRef.hashCode();
        }

        public String toString() {
            return this.nodeRef.toString();
        }

        public long lastModified() {
            return (Long)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Long>(){

                public Long doWork() throws Exception {
                    return (Long)RepoStore.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                        public Long execute() throws Exception {
                            ContentReader reader = RepoStore.this.contentService.getReader(RepoTemplateSource.this.nodeRef, ContentModel.PROP_CONTENT);
                            return reader.getLastModified();
                        }
                    });
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }

        public Reader getReader() throws IOException {
            return (Reader)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Reader>(){

                public Reader doWork() throws Exception {
                    return (Reader)RepoStore.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Reader>(){

                        public Reader execute() throws Exception {
                            ContentReader reader = RepoStore.this.contentService.getReader(RepoTemplateSource.this.nodeRef, ContentModel.PROP_CONTENT);
                            return new InputStreamReader(reader.getContentInputStream(), reader.getEncoding());
                        }
                    });
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    private class RepoTemplateLoader
    implements TemplateLoader {
        private RepoTemplateLoader() {
        }

        public Object findTemplateSource(final String name) throws IOException {
            return AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    return RepoStore.this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                        public Object execute() throws Exception {
                            RepoTemplateSource source = null;
                            NodeRef nodeRef = RepoStore.this.findNodeRef(name);
                            if (nodeRef != null) {
                                source = new RepoTemplateSource(nodeRef);
                            }
                            return source;
                        }
                    }, true);
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }

        public long getLastModified(Object templateSource) {
            return ((RepoTemplateSource)templateSource).lastModified();
        }

        public Reader getReader(Object templateSource, String encoding) throws IOException {
            return ((RepoTemplateSource)templateSource).getReader();
        }

        public void closeTemplateSource(Object arg0) throws IOException {
        }
    }
}

