/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.scripts.ScriptException;
import org.alfresco.service.cmr.repository.ScriptLocation;
import org.alfresco.service.cmr.repository.ScriptService;
import org.springframework.extensions.webscripts.MultiScriptLoader;
import org.springframework.extensions.webscripts.ScriptContent;
import org.springframework.extensions.webscripts.ScriptLoader;
import org.springframework.extensions.webscripts.ScriptProcessor;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.Store;
import org.springframework.extensions.webscripts.WebScriptException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryScriptProcessor
implements ScriptProcessor {
    protected ScriptService scriptService;
    protected ScriptLoader scriptLoader;
    protected SearchPath searchPath;
    private final ValueConverter valueConverter = new ValueConverter();

    public void setScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    public void setSearchPath(SearchPath searchPath) {
        this.searchPath = searchPath;
    }

    public ScriptContent findScript(String path) {
        return this.scriptLoader.getScript(path);
    }

    public Object executeScript(String path, Map<String, Object> model) throws ScriptException {
        ScriptContent scriptContent = this.findScript(path);
        if (scriptContent == null) {
            throw new WebScriptException("Unable to locate script " + path);
        }
        return this.executeScript(scriptContent, model);
    }

    public Object executeScript(ScriptContent content, Map<String, Object> model) {
        return this.scriptService.executeScript("javascript", (ScriptLocation)new RepositoryScriptLocation(content), model);
    }

    public Object unwrapValue(Object value) {
        return this.valueConverter.convertValueForJava(value);
    }

    public void reset() {
        this.init();
        this.scriptService.resetScriptProcessors();
    }

    private void init() {
        ArrayList<ScriptLoader> loaders = new ArrayList<ScriptLoader>();
        for (Store apiStore : this.searchPath.getStores()) {
            ScriptLoader loader = apiStore.getScriptLoader();
            if (loader == null) {
                throw new WebScriptException("Unable to retrieve script loader for Web Script store " + apiStore.getBasePath());
            }
            loaders.add(loader);
        }
        this.scriptLoader = new MultiScriptLoader(loaders.toArray(new ScriptLoader[loaders.size()]));
    }

    private static class RepositoryScriptLocation
    implements ScriptLocation {
        private ScriptContent content;

        private RepositoryScriptLocation(ScriptContent content) {
            this.content = content;
        }

        public InputStream getInputStream() {
            return this.content.getInputStream();
        }

        public Reader getReader() {
            return this.content.getReader();
        }

        public boolean isCachable() {
            return this.content.isCachable();
        }

        public boolean isSecure() {
            return this.content.isSecure();
        }

        public String getPath() {
            return this.content.getPath();
        }

        public String toString() {
            return this.content.getPathDescription();
        }
    }
}

