/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.action;

import java.util.Map;
import java.util.NoSuchElementException;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.ActionTrackingServiceImpl;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.web.scripts.action.RunningActionModelBuilder;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ActionStatus;
import org.alfresco.service.cmr.action.ActionTrackingService;
import org.alfresco.service.cmr.action.ExecutionSummary;
import org.alfresco.service.cmr.repository.NodeService;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractActionWebscript
extends DeclarativeWebScript {
    protected NodeService nodeService;
    protected ActionService actionService;
    protected RuntimeActionService runtimeActionService;
    protected ActionTrackingService actionTrackingService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setRuntimeActionService(RuntimeActionService runtimeActionService) {
        this.runtimeActionService = runtimeActionService;
    }

    public void setActionTrackingService(ActionTrackingService actionTrackingService) {
        this.actionTrackingService = actionTrackingService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        RunningActionModelBuilder modelBuilder = new RunningActionModelBuilder(this.nodeService, this.actionService, this.actionTrackingService);
        return this.buildModel(modelBuilder, req, status, cache);
    }

    protected abstract Map<String, Object> buildModel(RunningActionModelBuilder var1, WebScriptRequest var2, Status var3, Cache var4);

    public static ExecutionSummary getSummaryFromKey(String key) {
        return WrappedActionTrackingService.getSummaryFromKey(key);
    }

    public static ExecutionSummary getSummaryFromAction(Action action) {
        if (action.getExecutionStatus() == ActionStatus.Running) {
            return WrappedActionTrackingService.buildExecutionSummary(action);
        }
        if (((ActionImpl)action).getExecutionInstance() != -1) {
            return WrappedActionTrackingService.buildExecutionSummary(action);
        }
        return null;
    }

    public static String getRunningId(ExecutionSummary summary) {
        return WrappedActionTrackingService.getRunningId(summary);
    }

    private static class WrappedActionTrackingService
    extends ActionTrackingServiceImpl {
        private WrappedActionTrackingService() {
        }

        private static String getRunningId(ExecutionSummary summary) {
            return ActionTrackingServiceImpl.generateCacheKey((ExecutionSummary)summary);
        }

        protected static ExecutionSummary buildExecutionSummary(Action action) {
            return ActionTrackingServiceImpl.buildExecutionSummary((Action)action);
        }

        private static ExecutionSummary getSummaryFromKey(String key) {
            try {
                return ActionTrackingServiceImpl.buildExecutionSummary((String)key);
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
    }
}

