/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.bean;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRemoteStore
extends AbstractWebScript {
    public static final String TOKEN_STORE = "s";
    public static final String TOKEN_WEBAPP = "w";
    public static final String REQUEST_PARAM_STORE = "s";
    public static final String REQUEST_PARAM_WEBAPP = "w";
    private static final Log logger = LogFactory.getLog(BaseRemoteStore.class);
    protected String defaultStore;
    protected ContentService contentService;
    protected MimetypeService mimetypeService;

    public void setStore(String defaultStore) {
        this.defaultStore = defaultStore;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        if (!(req instanceof WebScriptServletRequest)) {
            throw new WebScriptException("Remote Store access must be executed in HTTP Servlet environment");
        }
        HttpServletRequest httpReq = ((WebScriptServletRequest)req).getHttpServletRequest();
        String extPath = req.getExtensionPath();
        String methodName = null;
        String store = null;
        String webapp = null;
        StringBuilder pathBuilder = new StringBuilder(128);
        StringTokenizer tokenizer = new StringTokenizer(extPath, "/");
        if (tokenizer.hasMoreTokens()) {
            methodName = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                String el = tokenizer.nextToken();
                if ("s".equals(el)) {
                    store = tokenizer.nextToken();
                    String string = el = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                }
                if ("w".equals(el)) {
                    webapp = tokenizer.nextToken();
                    String string = el = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                }
                while (el != null) {
                    pathBuilder.append('/');
                    pathBuilder.append(el);
                    el = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                }
            }
        } else {
            throw new WebScriptException("Unable to tokenize web path: " + extPath);
        }
        if (store == null) {
            store = req.getParameter("s");
            if (store == null) {
                store = this.defaultStore;
            }
            if (store == null) {
                throw new WebScriptException("Unable to determine which store to operate against. A store was not specified and a default was not provided.");
            }
        }
        if (webapp == null) {
            webapp = req.getParameter("w");
        }
        if (webapp != null) {
            pathBuilder.insert(0, "/www/avm_webapps/" + webapp);
        }
        String path = pathBuilder.toString();
        long start = 0L;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Remote method: " + methodName.toUpperCase() + "   Store Id: " + store + "   Path: " + path));
            start = System.nanoTime();
        }
        try {
            APIMethod method = APIMethod.valueOf(methodName.toUpperCase());
            switch (method) {
                case LASTMODIFIED: {
                    BaseRemoteStore.validatePath(path);
                    this.lastModified(res, store, path);
                    break;
                }
                case HAS: {
                    BaseRemoteStore.validatePath(path);
                    this.hasDocument(res, store, path);
                    break;
                }
                case GET: {
                    BaseRemoteStore.validatePath(path);
                    this.getDocument(res, store, path);
                    break;
                }
                case LIST: {
                    this.listDocuments(res, store, path, false);
                    break;
                }
                case LISTALL: {
                    this.listDocuments(res, store, path, true);
                    break;
                }
                case LISTPATTERN: {
                    this.listDocuments(res, store, path, req.getParameter("m"));
                    break;
                }
                case CREATE: {
                    BaseRemoteStore.validatePath(path);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("CREATE: content length=" + httpReq.getContentLength()));
                    }
                    this.createDocument(res, store, path, (InputStream)httpReq.getInputStream());
                    break;
                }
                case UPDATE: {
                    BaseRemoteStore.validatePath(path);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("CREATE: content length=" + httpReq.getContentLength()));
                    }
                    this.updateDocument(res, store, path, (InputStream)httpReq.getInputStream());
                    break;
                }
                case DELETE: {
                    BaseRemoteStore.validatePath(path);
                    this.deleteDocument(res, store, path);
                }
            }
        }
        catch (IllegalArgumentException enumErr) {
            throw new WebScriptException("Unknown method specified to remote store API: " + methodName);
        }
        catch (IOException ioErr) {
            throw new WebScriptException("Error during remote store API: " + ioErr.getMessage());
        }
        if (logger.isDebugEnabled()) {
            long end = System.nanoTime();
            logger.debug((Object)("Time to execute method: " + (float)(end - start) / 1000000.0f + "ms"));
        }
    }

    private static void validatePath(String path) {
        if (path == null) {
            throw new WebScriptException("Remote Store expecting document path elements.");
        }
    }

    protected List<String> getPathParts(String[] extPaths) {
        ArrayList<String> pathParts = new ArrayList<String>(extPaths.length - 1);
        for (int i = 1; i < extPaths.length; ++i) {
            pathParts.add(extPaths[i]);
        }
        return pathParts;
    }

    protected abstract void lastModified(WebScriptResponse var1, String var2, String var3) throws IOException;

    protected abstract void hasDocument(WebScriptResponse var1, String var2, String var3) throws IOException;

    protected abstract void getDocument(WebScriptResponse var1, String var2, String var3) throws IOException;

    protected abstract void listDocuments(WebScriptResponse var1, String var2, String var3, boolean var4) throws IOException;

    protected abstract void listDocuments(WebScriptResponse var1, String var2, String var3, String var4) throws IOException;

    protected abstract void createDocument(WebScriptResponse var1, String var2, String var3, InputStream var4);

    protected abstract void updateDocument(WebScriptResponse var1, String var2, String var3, InputStream var4);

    protected abstract void deleteDocument(WebScriptResponse var1, String var2, String var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum APIMethod {
        LASTMODIFIED,
        HAS,
        GET,
        LIST,
        LISTALL,
        LISTPATTERN,
        CREATE,
        UPDATE,
        DELETE;

    }
}

