/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.comment;

import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

public class ScriptCommentService
extends BaseScopableProcessorExtension {
    private static final String COMMENTS_TOPIC_NAME = "Comments";
    private ServiceRegistry serviceRegistry;
    private NodeService nodeService;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.nodeService = serviceRegistry.getNodeService();
    }

    public ScriptNode createCommentsFolder(ScriptNode node) {
        final NodeRef nodeRef = node.getNodeRef();
        NodeRef commentsFolder = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                NodeRef commentsFolder = null;
                ScriptCommentService.this.nodeService.addAspect(nodeRef, QName.createQName((String)"http://www.alfresco.org/model/forum/1.0", (String)"discussable"), null);
                List assocs = ScriptCommentService.this.nodeService.getChildAssocs(nodeRef, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/forum/1.0", (String)"discussion"), RegexQNamePattern.MATCH_ALL);
                if (assocs.size() != 0) {
                    NodeRef forumFolder = ((ChildAssociationRef)assocs.get(0)).getChildRef();
                    HashMap<QName, String> props = new HashMap<QName, String>(1);
                    props.put(ContentModel.PROP_NAME, ScriptCommentService.COMMENTS_TOPIC_NAME);
                    commentsFolder = ScriptCommentService.this.nodeService.createNode(forumFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)ScriptCommentService.COMMENTS_TOPIC_NAME), QName.createQName((String)"http://www.alfresco.org/model/forum/1.0", (String)"topic"), props).getChildRef();
                }
                return commentsFolder;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
        return new ScriptNode(commentsFolder, this.serviceRegistry, this.getScope());
    }
}

