/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.content;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.cmis.CMISObjectReference;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cmis.reference.ReferenceFactory;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class ContentDelete
extends AbstractWebScript {
    private ReferenceFactory referenceFactory;
    private NamespaceService namespaceService;
    private NodeService nodeService;

    public void setReferenceFactory(ReferenceFactory referenceFactory) {
        this.referenceFactory = referenceFactory;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        ContentData contentData;
        String[] names = req.getParameterNames();
        HashMap<String, String> args = new HashMap<String, String>(names.length, 1.0f);
        for (String name : names) {
            args.put(name, req.getParameter(name));
        }
        Map templateVars = req.getServiceMatch().getTemplateVars();
        CMISObjectReference reference = this.referenceFactory.createObjectReferenceFromUrl(args, templateVars);
        NodeRef nodeRef = reference.getNodeRef();
        if (nodeRef == null) {
            throw new WebScriptException(404, "Unable to find " + reference.toString());
        }
        QName propertyQName = ContentModel.PROP_CONTENT;
        String contentPart = (String)templateVars.get("property");
        if (contentPart.length() > 0 && contentPart.charAt(0) == ';') {
            if (contentPart.length() < 2) {
                throw new WebScriptException(400, "Content property malformed");
            }
            String propertyName = contentPart.substring(1);
            if (propertyName.length() > 0) {
                propertyQName = QName.createQName((String)propertyName, (NamespacePrefixResolver)this.namespaceService);
            }
        }
        if ((contentData = (ContentData)this.nodeService.getProperty(nodeRef, propertyQName)) != null) {
            contentData = new ContentData(null, null, 0L, null);
            this.nodeService.setProperty(nodeRef, propertyQName, (Serializable)contentData);
        }
        res.setStatus(204);
    }
}

