/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.content;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracterRegistry;
import org.alfresco.repo.content.transform.ComplexContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.repo.content.transform.ContentTransformerWorker;
import org.alfresco.repo.content.transform.ProxyContentTransformer;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimetypesGet
extends DeclarativeWebScript
implements ApplicationContextAware {
    public static final String MODEL_MIMETYPES = "mimetypes";
    public static final String MODEL_EXTENSIONS = "extensions";
    public static final String MODEL_MIMETYPE_DETAILS = "details";
    private MimetypeService mimetypeService;
    private ContentTransformerRegistry contentTransformerRegistry;
    private MetadataExtracterRegistry metadataExtracterRegistry;
    ContentTransformerWorker ooDirectWorker;
    protected static final String OODIRECT_WORKER_BEAN = "transformer.worker.OpenOffice";
    ContentTransformerWorker jodWorker;
    protected static final String JOD_WORKER_BEAN = "transformer.worker.JodConverter";

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Object bean;
        if (applicationContext.containsBean(OODIRECT_WORKER_BEAN) && (bean = applicationContext.getBean(OODIRECT_WORKER_BEAN)) instanceof ContentTransformerWorker) {
            this.ooDirectWorker = (ContentTransformerWorker)bean;
        }
        if (applicationContext.containsBean(JOD_WORKER_BEAN) && (bean = applicationContext.getBean(JOD_WORKER_BEAN)) instanceof ContentTransformerWorker) {
            this.jodWorker = (ContentTransformerWorker)bean;
        }
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setContentTransformerRegistry(ContentTransformerRegistry contentTransformerRegistry) {
        this.contentTransformerRegistry = contentTransformerRegistry;
    }

    public void setMetadataExtracterRegistry(MetadataExtracterRegistry metadataExtracterRegistry) {
        this.metadataExtracterRegistry = metadataExtracterRegistry;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        Object[] mimetypesA = this.mimetypeService.getMimetypes().toArray(new String[0]);
        Arrays.sort(mimetypesA);
        ArrayList<Object> mimetypes = new ArrayList<Object>(Arrays.asList(mimetypesA));
        HashMap<String, String> extensions = new HashMap<String, String>();
        for (String string : mimetypes) {
            String ext = this.mimetypeService.getExtension(string);
            extensions.put(string, ext);
        }
        HashMap details = new HashMap();
        String string = req.getParameter("mimetype");
        for (String string2 : mimetypes) {
            if (!string2.equals(string) && !"*".equals(string)) continue;
            HashMap<String, List<String>> mtd = new HashMap<String, List<String>>();
            mtd.put("extractors", this.getExtractors(string2));
            mtd.put("transformFrom", this.getTransformersFrom(string2, mimetypes));
            mtd.put("transformTo", this.getTransformersTo(string2, mimetypes));
            details.put(string2, mtd);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(MODEL_MIMETYPES, mimetypes);
        model.put(MODEL_EXTENSIONS, extensions);
        model.put(MODEL_MIMETYPE_DETAILS, details);
        return model;
    }

    protected List<String> getExtractors(String mimetype) {
        ArrayList<String> exts = new ArrayList<String>();
        MetadataExtracter extractor = this.metadataExtracterRegistry.getExtracter(mimetype);
        if (extractor != null) {
            exts.add(extractor.getClass().getName());
        }
        return exts;
    }

    protected List<String> getTransformersFrom(String mimetype, List<String> allMimetypes) {
        ArrayList<String> transforms = new ArrayList<String>();
        for (String toMT : allMimetypes) {
            String details;
            if (toMT.equals(mimetype) || (details = this.getTransformer(mimetype, toMT)) == null) continue;
            transforms.add(toMT + " = " + details);
        }
        return transforms;
    }

    protected List<String> getTransformersTo(String mimetype, List<String> allMimetypes) {
        ArrayList<String> transforms = new ArrayList<String>();
        for (String fromMT : allMimetypes) {
            String details;
            if (fromMT.equals(mimetype) || (details = this.getTransformer(fromMT, mimetype)) == null) continue;
            transforms.add(fromMT + " = " + details);
        }
        return transforms;
    }

    protected String getTransformer(String from, String to) {
        ContentTransformer ct = this.contentTransformerRegistry.getTransformer(from, to, new TransformationOptions());
        if (ct == null) {
            return null;
        }
        if (ct instanceof ComplexContentTransformer) {
            ComplexContentTransformer cct = (ComplexContentTransformer)ct;
            String text = "Complex via: ";
            for (String imt : cct.getIntermediateMimetypes()) {
                text = text + imt + " ";
            }
            return text;
        }
        if (ct instanceof ProxyContentTransformer) {
            ProxyContentTransformer pct = (ProxyContentTransformer)ct;
            ContentTransformerWorker ctw = pct.getWorker();
            if (ctw.equals(this.jodWorker)) {
                return "Using JOD Converter / Open Office";
            }
            if (ctw.equals(this.ooDirectWorker)) {
                return "Using a Direct Open Office Connection";
            }
            String text = "Proxy via: " + ctw.getClass().getName() + "(" + ctw.getVersionString() + ")";
            return text;
        }
        return ct.getClass().getName();
    }
}

