/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.dictionary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.web.scripts.dictionary.DictionaryComparators;
import org.alfresco.repo.web.scripts.dictionary.DictionaryWebServiceBase;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassesGet
extends DictionaryWebServiceBase {
    private static final String MODEL_PROP_KEY_CLASS_DEFS = "classdefs";
    private static final String MODEL_PROP_KEY_PROPERTY_DETAILS = "propertydefs";
    private static final String MODEL_PROP_KEY_ASSOCIATION_DETAILS = "assocdefs";
    private static final String CLASS_FILTER_OPTION_TYPE1 = "all";
    private static final String CLASS_FILTER_OPTION_TYPE2 = "aspect";
    private static final String CLASS_FILTER_OPTION_TYPE3 = "type";
    private static final String REQ_URL_TEMPL_VAR_CLASS_FILTER = "cf";
    private static final String REQ_URL_TEMPL_VAR_NAMESPACE_PREFIX = "nsp";
    private static final String REQ_URL_TEMPL_VAR_NAME = "n";

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String classFilter = this.getValidInput(req.getParameter(REQ_URL_TEMPL_VAR_CLASS_FILTER));
        String namespacePrefix = this.getValidInput(req.getParameter(REQ_URL_TEMPL_VAR_NAMESPACE_PREFIX));
        String name = this.getValidInput(req.getParameter(REQ_URL_TEMPL_VAR_NAME));
        String className = null;
        HashMap<QName, ClassDefinition> classdef = new HashMap<QName, ClassDefinition>();
        HashMap propdef = new HashMap();
        HashMap assocdef = new HashMap();
        HashMap<String, Object> model = new HashMap<String, Object>();
        ArrayList qnames = new ArrayList();
        QName classQname = null;
        QName myModel = null;
        if (classFilter == null) {
            classFilter = CLASS_FILTER_OPTION_TYPE1;
        }
        if (!this.isValidClassFilter(classFilter)) {
            throw new WebScriptException(404, "Check the classfilter - " + classFilter + " provided in the URL");
        }
        if (namespacePrefix == null && name != null) {
            throw new WebScriptException(404, "Missing namespaceprefix parameter in the URL - both combination of name and namespaceprefix is needed");
        }
        if (namespacePrefix != null) {
            if (name != null) {
                className = namespacePrefix + "_" + name;
                if (!this.isValidClassname(className)) {
                    throw new WebScriptException(404, "Check the name - " + name + "parameter in the URL");
                }
                classQname = QName.createQName((String)this.getFullNamespaceURI(className));
                classdef.put(classQname, this.dictionaryservice.getClass(classQname));
                propdef.put(classQname, this.dictionaryservice.getClass(classQname).getProperties().values());
                assocdef.put(classQname, this.dictionaryservice.getClass(classQname).getAssociations().values());
            } else {
                String namespaceUri = this.namespaceService.getNamespaceURI(namespacePrefix);
                for (QName qnameObj : this.dictionaryservice.getAllModels()) {
                    if (!qnameObj.getNamespaceURI().equals(namespaceUri)) continue;
                    name = qnameObj.getLocalName();
                    myModel = QName.createQName((String)this.getFullNamespaceURI(namespacePrefix + "_" + name));
                    if (classFilter.equalsIgnoreCase(CLASS_FILTER_OPTION_TYPE1)) {
                        qnames.addAll(this.dictionaryservice.getAspects(myModel));
                        qnames.addAll(this.dictionaryservice.getTypes(myModel));
                        continue;
                    }
                    if (classFilter.equalsIgnoreCase(CLASS_FILTER_OPTION_TYPE3)) {
                        qnames.addAll(this.dictionaryservice.getTypes(myModel));
                        continue;
                    }
                    if (!classFilter.equalsIgnoreCase(CLASS_FILTER_OPTION_TYPE2)) continue;
                    qnames.addAll(this.dictionaryservice.getAspects(myModel));
                }
            }
        }
        if (myModel == null) {
            if (classFilter.equalsIgnoreCase(CLASS_FILTER_OPTION_TYPE1)) {
                qnames.addAll(this.dictionaryservice.getAllAspects());
                qnames.addAll(this.dictionaryservice.getAllTypes());
            } else if (classFilter.equalsIgnoreCase(CLASS_FILTER_OPTION_TYPE3)) {
                qnames.addAll(this.dictionaryservice.getAllTypes());
            } else if (classFilter.equalsIgnoreCase(CLASS_FILTER_OPTION_TYPE2)) {
                qnames.addAll(this.dictionaryservice.getAllAspects());
            }
        }
        if (classdef.isEmpty()) {
            for (QName qnameObj : qnames) {
                classdef.put(qnameObj, this.dictionaryservice.getClass(qnameObj));
                propdef.put(qnameObj, this.dictionaryservice.getClass(qnameObj).getProperties().values());
                assocdef.put(qnameObj, this.dictionaryservice.getClass(qnameObj).getAssociations().values());
            }
        }
        ArrayList classDefinitions = new ArrayList(classdef.values());
        Collections.sort(classDefinitions, new DictionaryComparators.ClassDefinitionComparator());
        model.put(MODEL_PROP_KEY_CLASS_DEFS, classDefinitions);
        model.put(MODEL_PROP_KEY_PROPERTY_DETAILS, propdef.values());
        model.put(MODEL_PROP_KEY_ASSOCIATION_DETAILS, assocdef.values());
        return model;
    }
}

