/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.invite;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.invitation.WorkflowModelNominatedInvitation;
import org.alfresco.repo.invitation.site.InviteHelper;
import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.InvitationExceptionForbidden;
import org.alfresco.service.cmr.invitation.InvitationExceptionUserError;
import org.alfresco.service.cmr.invitation.InvitationService;
import org.alfresco.service.cmr.invitation.NominatedInvitation;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invite
extends DeclarativeWebScript {
    private static final String ACTION_START = "start";
    private static final String ACTION_CANCEL = "cancel";
    private static final String MODEL_PROP_KEY_ACTION = "action";
    private static final String MODEL_PROP_KEY_INVITE_ID = "inviteId";
    private static final String MODEL_PROP_KEY_INVITE_TICKET = "inviteTicket";
    private static final String MODEL_PROP_KEY_INVITEE_USER_NAME = "inviteeUserName";
    private static final String MODEL_PROP_KEY_INVITEE_FIRSTNAME = "inviteeFirstName";
    private static final String MODEL_PROP_KEY_INVITEE_LASTNAME = "inviteeLastName";
    private static final String MODEL_PROP_KEY_INVITEE_EMAIL = "inviteeEmail";
    private static final String MODEL_PROP_KEY_SITE_SHORT_NAME = "siteShortName";
    private static final String MODEL_PROP_KEY_INVITEE_USERNAME = "inviteeUserName";
    private static final String PARAM_INVITEE_FIRSTNAME = "inviteeFirstName";
    private static final String PARAM_INVITEE_LASTNAME = "inviteeLastName";
    private static final String PARAM_INVITEE_EMAIL = "inviteeEmail";
    private static final String PARAM_SITE_SHORT_NAME = "siteShortName";
    private static final String PARAM_INVITE_ID = "inviteId";
    private static final String PARAM_INVITEE_SITE_ROLE = "inviteeSiteRole";
    private static final String PARAM_SERVER_PATH = "serverPath";
    private static final String PARAM_ACCEPT_URL = "acceptUrl";
    private static final String PARAM_REJECT_URL = "rejectUrl";
    private WorkflowService workflowService;
    private InvitationService invitationService;

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setInvitationService(InvitationService invitationService) {
        this.invitationService = invitationService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        String servicePath = req.getServicePath();
        String action = null;
        int actionStartIndex = servicePath.lastIndexOf("/") + 1;
        if (actionStartIndex <= servicePath.length() - 1) {
            action = servicePath.substring(actionStartIndex, servicePath.length());
        }
        if (action == null || action.length() == 0) {
            throw new WebScriptException(400, "Action has not been provided in URL");
        }
        if (req.getParameterNames() == null || req.getParameterNames().length == 0) {
            throw new WebScriptException(400, "No parameters have been provided on URL");
        }
        if (action.equals(ACTION_START)) {
            String inviteeFirstName = req.getParameter("inviteeFirstName");
            if (inviteeFirstName == null || inviteeFirstName.trim().length() == 0) {
                throw new WebScriptException(400, "'inviteeFirstName' parameter has not been provided in URL for action 'start'");
            }
            String inviteeLastName = req.getParameter("inviteeLastName");
            if (inviteeLastName == null || inviteeLastName.trim().length() == 0) {
                throw new WebScriptException(400, "'inviteeLastName' parameter has not been provided in URL for action 'start'");
            }
            String inviteeEmail = req.getParameter("inviteeEmail");
            if (inviteeEmail == null || inviteeEmail.trim().length() == 0) {
                throw new WebScriptException(400, "'inviteeEmail' parameter has not been provided in URL for action 'start'");
            }
            String siteShortName = req.getParameter("siteShortName");
            if (siteShortName == null || siteShortName.trim().length() == 0) {
                throw new WebScriptException(400, "'siteShortName' parameter has not been provided in URL for action 'start'");
            }
            String inviteeSiteRole = req.getParameter(PARAM_INVITEE_SITE_ROLE);
            if (inviteeSiteRole == null || inviteeSiteRole.trim().length() == 0) {
                throw new WebScriptException(400, "'inviteeSiteRole' parameter has not been provided in URL for action 'start'");
            }
            String serverPath = req.getParameter(PARAM_SERVER_PATH);
            if (serverPath == null || serverPath.trim().length() == 0) {
                throw new WebScriptException(400, "'serverPath' parameter has not been provided in URL for action 'start'");
            }
            String acceptUrl = req.getParameter(PARAM_ACCEPT_URL);
            if (acceptUrl == null || acceptUrl.trim().length() == 0) {
                throw new WebScriptException(400, "'acceptUrl' parameter has not been provided in URL for action 'start'");
            }
            String rejectUrl = req.getParameter(PARAM_REJECT_URL);
            if (rejectUrl == null || rejectUrl.trim().length() == 0) {
                throw new WebScriptException(400, "'rejectUrl' parameter has not been provided in URL for action 'start'");
            }
            String inviteeUserName = req.getParameter("inviteeUserName");
            NominatedInvitation newInvite = null;
            try {
                newInvite = inviteeUserName != null ? this.invitationService.inviteNominated(inviteeUserName, Invitation.ResourceType.WEB_SITE, siteShortName, inviteeSiteRole, serverPath, acceptUrl, rejectUrl) : this.invitationService.inviteNominated(inviteeFirstName, inviteeLastName, inviteeEmail, Invitation.ResourceType.WEB_SITE, siteShortName, inviteeSiteRole, serverPath, acceptUrl, rejectUrl);
                model.put(MODEL_PROP_KEY_ACTION, ACTION_START);
                model.put("inviteId", newInvite.getInviteId());
                model.put(MODEL_PROP_KEY_INVITE_TICKET, newInvite.getTicket());
                model.put("inviteeUserName", newInvite.getInviteeUserName());
                model.put("inviteeFirstName", inviteeFirstName);
                model.put("inviteeLastName", inviteeLastName);
                model.put("inviteeEmail", inviteeEmail);
                model.put("siteShortName", siteShortName);
            }
            catch (InvitationExceptionUserError ie) {
                throw new WebScriptException(409, "Cannot proceed with invitation. A person with user name: '" + inviteeUserName + "' and invitee email address: '" + inviteeEmail + "' is already a member of the site: '" + siteShortName + "'.");
            }
            catch (InvitationExceptionForbidden fe) {
                throw new WebScriptException(403, fe.toString());
            }
        } else if (action.equals(ACTION_CANCEL)) {
            String inviteId = req.getParameter("inviteId");
            if (inviteId == null || inviteId.length() == 0) {
                throw new WebScriptException(400, "'inviteId' parameter has not been provided in URL for action 'cancel'");
            }
            try {
                this.invitationService.cancel(inviteId);
                model.put(MODEL_PROP_KEY_ACTION, ACTION_CANCEL);
                model.put("inviteId", inviteId);
                this.cancelInvite(model, inviteId);
            }
            catch (InvitationExceptionForbidden fe) {
                throw new WebScriptException(403, "Unable to cancel workflow", (Throwable)fe);
            }
        } else {
            throw new WebScriptException(400, "Action, '" + action + "', " + "provided in URL has not been recognised.");
        }
        return model;
    }

    private void cancelInvite(Map<String, Object> model, String inviteId) {
        if (inviteId == null || inviteId.length() == 0) {
            throw new WebScriptException(400, "Given invite ID " + inviteId + " null or empty");
        }
        try {
            InviteHelper.completeInviteTask((String)inviteId, (QName)WorkflowModelNominatedInvitation.WF_INVITE_TASK_INVITE_PENDING, (String)ACTION_CANCEL, (WorkflowService)this.workflowService);
        }
        catch (InvitationExceptionForbidden fe) {
            throw new WebScriptException(403, "Unable to cancel workflow", (Throwable)fe);
        }
        catch (WorkflowException wfe) {
            Throwable indirectCause = wfe.getCause().getCause();
            if (indirectCause instanceof InvitationExceptionForbidden) {
                throw new WebScriptException(403, "Unable to cancel workflow", indirectCause);
            }
            if (indirectCause instanceof WebScriptException) {
                WebScriptException wse = (WebScriptException)indirectCause;
                throw wse;
            }
            throw wfe;
        }
        model.put(MODEL_PROP_KEY_ACTION, ACTION_CANCEL);
        model.put("inviteId", inviteId);
    }
}

