/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.rating;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.web.scripts.rating.AbstractRatingWebScript;
import org.alfresco.service.cmr.rating.RatingScheme;
import org.alfresco.service.cmr.repository.NodeRef;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RatingPost
extends AbstractRatingWebScript {
    private static final String NODE_RATINGS_URL_FORMAT = "/api/node/{0}/ratings";

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        NodeRef nodeRefToBeRated = this.parseRequestForNodeRef(req);
        JSONObject json = null;
        try {
            json = new JSONObject(new JSONTokener(req.getContent().getContent()));
            if (!json.has("rating")) {
                throw new WebScriptException(400, "rating parameter missing when applying rating");
            }
            if (!json.has("ratingScheme")) {
                throw new WebScriptException(400, "schemeName parameter missing when applying rating");
            }
            String schemeName = json.getString("ratingScheme");
            RatingScheme scheme = this.ratingService.getRatingScheme(schemeName);
            if (scheme == null) {
                throw new WebScriptException(400, "Unknown scheme name: " + schemeName);
            }
            float rating = (float)json.getDouble("rating");
            this.ratingService.applyRating(nodeRefToBeRated, rating, schemeName);
            String ratedNodeUrlFragment = nodeRefToBeRated.toString().replace("://", "/");
            String ratedNodeUrl = MessageFormat.format(NODE_RATINGS_URL_FORMAT, ratedNodeUrlFragment);
            model.put("ratedNode", ratedNodeUrl);
            model.put("rating", Float.valueOf(rating));
            model.put("ratingScheme", schemeName);
        }
        catch (IOException iox) {
            throw new WebScriptException(400, "Could not read content from req.", (Throwable)iox);
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not parse JSON from req.", (Throwable)je);
        }
        return model;
    }
}

