/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.replication;

import java.io.IOException;
import java.util.Map;
import org.alfresco.repo.web.scripts.replication.AbstractReplicationWebscript;
import org.alfresco.repo.web.scripts.replication.ReplicationModelBuilder;
import org.alfresco.service.cmr.replication.ReplicationDefinition;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationDefinitionsPost
extends AbstractReplicationWebscript {
    @Override
    protected Map<String, Object> buildModel(ReplicationModelBuilder modelBuilder, WebScriptRequest req, Status status, Cache cache) {
        ReplicationDefinition replicationDefinition = null;
        try {
            JSONObject json = new JSONObject(new JSONTokener(req.getContent().getContent()));
            if (!json.has("name")) {
                throw new WebScriptException(400, "name is required but wasn't supplied");
            }
            if (!json.has("description")) {
                throw new WebScriptException(400, "description is required but wasn't supplied");
            }
            String name = json.getString("name");
            if (this.replicationService.loadReplicationDefinition(name) != null) {
                throw new WebScriptException(400, "A replication definition already exists with that name");
            }
            replicationDefinition = this.replicationService.createReplicationDefinition(name, json.getString("description"));
            this.updateDefinitionProperties(replicationDefinition, json);
            this.replicationService.saveReplicationDefinition(replicationDefinition);
        }
        catch (IOException iox) {
            throw new WebScriptException(400, "Could not read content from request.", (Throwable)iox);
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not parse JSON from request.", (Throwable)je);
        }
        return modelBuilder.buildDetails(replicationDefinition);
    }
}

