/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.transfer;

import java.io.StringWriter;
import java.io.Writer;
import org.alfresco.repo.web.scripts.transfer.CommandProcessor;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.json.JSONWriter;

public class BeginTransferCommandProcessor
implements CommandProcessor {
    private static final String MSG_CAUGHT_UNEXPECTED_EXCEPTION = "transfer_service.receiver.caught_unexpected_exception";
    private TransferReceiver receiver;
    private static final Log logger = LogFactory.getLog(BeginTransferCommandProcessor.class);

    public int process(WebScriptRequest req, WebScriptResponse resp) {
        String transferId = null;
        try {
            transferId = this.receiver.start();
            this.receiver.getStagingFolder(transferId);
            StringWriter stringWriter = new StringWriter(300);
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.startObject();
            jsonWriter.writeValue("transferId", transferId);
            jsonWriter.endObject();
            String response = stringWriter.toString();
            resp.setContentType("application/json");
            resp.setContentEncoding("UTF-8");
            int length = response.getBytes("UTF-8").length;
            resp.addHeader("Content-Length", "" + length);
            resp.setStatus(200);
            resp.getWriter().write(response);
            logger.debug((Object)("transfer started" + transferId));
            return 200;
        }
        catch (Exception ex) {
            logger.debug((Object)"exception caught", (Throwable)ex);
            if (transferId != null) {
                logger.debug((Object)"ending transfer", (Throwable)ex);
                this.receiver.end(transferId);
            }
            if (ex instanceof TransferException) {
                throw (TransferException)ex;
            }
            throw new TransferException(MSG_CAUGHT_UNEXPECTED_EXCEPTION, (Throwable)ex);
        }
    }

    public void setReceiver(TransferReceiver receiver) {
        this.receiver = receiver;
    }
}

