/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.workflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.web.scripts.workflow.AbstractWorkflowWebscript;
import org.alfresco.repo.web.scripts.workflow.WorkflowModelBuilder;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowInstancesGet
extends AbstractWorkflowWebscript {
    public static final String PARAM_STATE = "state";
    public static final String PARAM_INITIATOR = "initiator";
    public static final String PARAM_PRIORITY = "priority";
    public static final String PARAM_DUE_BEFORE = "dueBefore";
    public static final String PARAM_DUE_AFTER = "dueAfter";
    public static final String PARAM_STARTED_BEFORE = "startedBefore";
    public static final String PARAM_STARTED_AFTER = "startedAfter";
    public static final String PARAM_COMPLETED_BEFORE = "completedBefore";
    public static final String PARAM_COMPLETED_AFTER = "completedAfter";
    public static final String PARAM_DEFINITION_NAME = "definitionName";
    public static final String PARAM_DEFINITION_ID = "definitionId";
    public static final String VAR_DEFINITION_ID = "workflow_definition_id";
    private WorkflowInstanceDueAscComparator workflowComparator = new WorkflowInstanceDueAscComparator();

    @Override
    protected Map<String, Object> buildModel(WorkflowModelBuilder modelBuilder, WebScriptRequest req, Status status, Cache cache) {
        Map params = req.getServiceMatch().getTemplateVars();
        WorkflowState state = this.getState(req);
        HashMap<String, Object> filters = new HashMap<String, Object>(9);
        filters.put(PARAM_INITIATOR, req.getParameter(PARAM_INITIATOR));
        filters.put(PARAM_PRIORITY, req.getParameter(PARAM_PRIORITY));
        filters.put(PARAM_DEFINITION_NAME, req.getParameter(PARAM_DEFINITION_NAME));
        String excludeParam = req.getParameter("exclude");
        if (excludeParam != null && excludeParam.length() > 0) {
            filters.put("exclude", new AbstractWorkflowWebscript.ExcludeFilter(excludeParam));
        }
        this.processDateFilter(req, PARAM_DUE_BEFORE, filters);
        this.processDateFilter(req, PARAM_DUE_AFTER, filters);
        this.processDateFilter(req, PARAM_STARTED_BEFORE, filters);
        this.processDateFilter(req, PARAM_STARTED_AFTER, filters);
        this.processDateFilter(req, PARAM_COMPLETED_BEFORE, filters);
        this.processDateFilter(req, PARAM_COMPLETED_AFTER, filters);
        String workflowDefinitionId = (String)params.get(VAR_DEFINITION_ID);
        if (workflowDefinitionId == null) {
            workflowDefinitionId = req.getParameter(PARAM_DEFINITION_ID);
        }
        if (state == null) {
            state = WorkflowState.ACTIVE;
        }
        ArrayList workflows = new ArrayList();
        if (workflowDefinitionId != null) {
            if (state == WorkflowState.ACTIVE) {
                workflows.addAll(this.workflowService.getActiveWorkflows(workflowDefinitionId));
            } else {
                workflows.addAll(this.workflowService.getCompletedWorkflows(workflowDefinitionId));
            }
        } else {
            List workflowDefinitions = this.workflowService.getAllDefinitions();
            for (WorkflowDefinition workflowDefinition : workflowDefinitions) {
                if (state == WorkflowState.ACTIVE) {
                    workflows.addAll(this.workflowService.getActiveWorkflows(workflowDefinition.getId()));
                    continue;
                }
                workflows.addAll(this.workflowService.getCompletedWorkflows(workflowDefinition.getId()));
            }
        }
        Collections.sort(workflows, this.workflowComparator);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>(workflows.size());
        for (WorkflowInstance workflow : workflows) {
            if (!this.matches(workflow, filters, modelBuilder)) continue;
            results.add(modelBuilder.buildSimple(workflow));
        }
        return this.createResultModel(modelBuilder, req, "workflowInstances", results);
    }

    private boolean matches(WorkflowInstance workflowInstance, Map<String, Object> filters, WorkflowModelBuilder modelBuilder) {
        boolean result = true;
        for (String key : filters.keySet()) {
            Date endDate;
            Date startDate;
            Date dueDate;
            Object filterValue = filters.get(key);
            if (filterValue == null) continue;
            if (key.equals("exclude")) {
                AbstractWorkflowWebscript.ExcludeFilter excludeFilter = (AbstractWorkflowWebscript.ExcludeFilter)filterValue;
                String type = workflowInstance.getDefinition().getName();
                if (!excludeFilter.isMatch(type)) continue;
                result = false;
                break;
            }
            if (key.equals(PARAM_INITIATOR)) {
                NodeRef initiator = workflowInstance.getInitiator();
                if (initiator == null) {
                    result = false;
                    break;
                }
                if (this.nodeService.exists(initiator) && filterValue.equals(this.nodeService.getProperty(workflowInstance.getInitiator(), ContentModel.PROP_USERNAME))) continue;
                result = false;
                break;
            }
            if (key.equals(PARAM_PRIORITY)) {
                String priority = "0";
                if (workflowInstance.getPriority() != null) {
                    priority = workflowInstance.getPriority().toString();
                }
                if (filterValue.equals(priority)) continue;
                result = false;
                break;
            }
            if (key.equals(PARAM_DEFINITION_NAME)) {
                String definitionName = workflowInstance.getDefinition().getName();
                if (filterValue.equals(definitionName)) continue;
                result = false;
                break;
            }
            if (key.equals(PARAM_DUE_BEFORE)) {
                dueDate = workflowInstance.getDueDate();
                if (this.isDateMatchForFilter(dueDate, filterValue, true)) continue;
                result = false;
                break;
            }
            if (key.equals(PARAM_DUE_AFTER)) {
                dueDate = workflowInstance.getDueDate();
                if (this.isDateMatchForFilter(dueDate, filterValue, false)) continue;
                result = false;
                break;
            }
            if (key.equals(PARAM_STARTED_BEFORE)) {
                startDate = workflowInstance.getStartDate();
                if (this.isDateMatchForFilter(startDate, filterValue, true)) continue;
                result = false;
                break;
            }
            if (key.equals(PARAM_STARTED_AFTER)) {
                startDate = workflowInstance.getStartDate();
                if (this.isDateMatchForFilter(startDate, filterValue, false)) continue;
                result = false;
                break;
            }
            if (key.equals(PARAM_COMPLETED_BEFORE)) {
                endDate = workflowInstance.getEndDate();
                if (this.isDateMatchForFilter(endDate, filterValue, true)) continue;
                result = false;
                break;
            }
            if (!key.equals(PARAM_COMPLETED_AFTER) || this.isDateMatchForFilter(endDate = workflowInstance.getEndDate(), filterValue, false)) continue;
            result = false;
            break;
        }
        return result;
    }

    private WorkflowState getState(WebScriptRequest req) {
        String stateName = req.getParameter(PARAM_STATE);
        if (stateName != null) {
            try {
                return WorkflowState.valueOf(stateName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                String msg = "Unrecognised State parameter: " + stateName;
                throw new WebScriptException(400, msg);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WorkflowInstanceDueAscComparator
    implements Comparator<WorkflowInstance> {
        WorkflowInstanceDueAscComparator() {
        }

        @Override
        public int compare(WorkflowInstance o1, WorkflowInstance o2) {
            Date date2;
            long time2;
            Date date1 = o1.dueDate;
            long time1 = date1 == null ? Long.MAX_VALUE : date1.getTime();
            long result = time1 - (time2 = (date2 = o2.dueDate) == null ? Long.MAX_VALUE : date2.getTime());
            return result > 0L ? 1 : (result < 0L ? -1 : 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WorkflowState {
        ACTIVE,
        COMPLETED;

    }
}

