/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.util.paging;

import java.io.Serializable;
import org.alfresco.repo.web.util.paging.Cursor;
import org.alfresco.repo.web.util.paging.Paging;

public class PagedCursor
implements Cursor,
Serializable {
    private static final long serialVersionUID = -1041155610387669590L;
    private boolean zeroBasedPage;
    private boolean zeroBasedRow;
    private int totalRows;
    private int pageSize;
    private int rowsPerPage;
    private int page;

    PagedCursor(boolean zeroBasedRow, int totalRows, boolean zeroBasedPage, int page, int pageSize) {
        this.zeroBasedRow = zeroBasedRow;
        this.totalRows = totalRows;
        this.zeroBasedPage = zeroBasedPage;
        this.page = zeroBasedPage ? page : page - 1;
        this.pageSize = pageSize;
        this.rowsPerPage = pageSize <= 0 ? totalRows : pageSize;
    }

    public String getPageType() {
        return Paging.PageType.PAGE.toString();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalPages() {
        if (this.totalRows <= 0) {
            return 0;
        }
        int totalPages = this.totalRows / this.rowsPerPage;
        return totalPages += this.totalRows % this.rowsPerPage != 0 ? 1 : 0;
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public int getCurrentPage() {
        return this.page + (this.zeroBasedPage ? 0 : 1);
    }

    public int getFirstPage() {
        if (this.totalRows <= 0) {
            return -1;
        }
        return this.zeroBasedPage ? 0 : 1;
    }

    public int getLastPage() {
        if (this.totalRows <= 0) {
            return -1;
        }
        return this.getTotalPages() - (this.zeroBasedPage ? 1 : 0);
    }

    public int getNextPage() {
        return this.getCurrentPage() < this.getLastPage() ? this.getCurrentPage() + 1 : -1;
    }

    public int getPrevPage() {
        return this.page > 0 ? this.getCurrentPage() - 1 : -1;
    }

    public boolean isInRange() {
        return this.page >= 0 && this.getCurrentPage() <= this.getLastPage();
    }

    public boolean getHasFirstPage() {
        return this.getFirstPage() != -1;
    }

    public boolean getHasLastPage() {
        return this.getLastPage() != -1;
    }

    public boolean getHasNextPage() {
        return this.getNextPage() != -1;
    }

    public boolean getHasPrevPage() {
        return this.getPrevPage() != -1;
    }

    public int getStartRow() {
        if (this.totalRows <= 0) {
            return 0;
        }
        return this.page * this.rowsPerPage + (this.zeroBasedRow ? 0 : 1);
    }

    public int getEndRow() {
        if (this.totalRows <= 0) {
            return -1;
        }
        return this.getStartRow() + Math.min(this.rowsPerPage, this.totalRows - this.page * this.rowsPerPage) - 1;
    }

    public int getRowCount() {
        if (this.totalRows <= 0) {
            return 0;
        }
        return this.getEndRow() - this.getStartRow() + 1;
    }
}

