/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import org.alfresco.repo.webdav.HierarchicalMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;

public abstract class AbstractMoveOrCopyMethod
extends HierarchicalMethod {
    protected abstract void moveOrCopy(FileFolderService var1, NodeRef var2, NodeRef var3, String var4) throws Exception;

    protected final void executeImpl() throws WebDAVServerException, Exception {
        FileFolderService fileFolderService = this.getFileFolderService();
        NodeRef rootNodeRef = this.getRootNodeRef();
        String servletPath = this.getServletPath();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Copy from " + this.getPath() + " to " + this.getDestinationPath()));
        }
        String sourcePath = this.getPath();
        FileInfo sourceInfo = null;
        try {
            sourceInfo = this.getDAVHelper().getNodeForPath(rootNodeRef, sourcePath, servletPath);
        }
        catch (FileNotFoundException e) {
            throw new WebDAVServerException(404);
        }
        String destPath = this.getDestinationPath();
        FileInfo destParentInfo = null;
        try {
            if (destPath.endsWith("/")) {
                destPath = destPath.substring(0, destPath.length() - 1);
            }
            destParentInfo = this.getDAVHelper().getParentNodeForPath(rootNodeRef, destPath, servletPath);
        }
        catch (FileNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Destination parent folder doesn't exist: " + destPath));
            }
            throw new WebDAVServerException(409);
        }
        FileInfo destInfo = null;
        try {
            destInfo = this.getDAVHelper().getNodeForPath(rootNodeRef, destPath, servletPath);
            if (!this.hasOverWrite()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Destination exists but overwrite is not allowed");
                }
                throw new WebDAVServerException(412);
            }
            if (!destInfo.getNodeRef().equals((Object)sourceInfo.getNodeRef())) {
                this.checkNode(destInfo);
                fileFolderService.delete(destInfo.getNodeRef());
            }
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        NodeRef sourceNodeRef = sourceInfo.getNodeRef();
        NodeRef destParentNodeRef = destParentInfo.getNodeRef();
        String name = this.getDAVHelper().splitPath(destPath)[1];
        this.moveOrCopy(fileFolderService, sourceNodeRef, destParentNodeRef, name);
        if (destInfo == null) {
            this.m_response.setStatus(201);
        } else {
            this.m_response.setStatus(204);
        }
    }
}

