/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.webdav.LockInfo;
import org.alfresco.repo.webdav.WebDAV;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVProperty;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConverter;
import org.dom4j.DocumentHelper;
import org.dom4j.io.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PropFindMethod
extends WebDAVMethod {
    protected static final int GET_ALL_PROPS = 0;
    protected static final int GET_NAMED_PROPS = 1;
    protected static final int FIND_PROPS = 2;
    protected int m_mode = 0;
    protected ArrayList<WebDAVProperty> m_properties = null;
    protected HashMap<String, String> m_namespaces = new HashMap();

    public final int getMode() {
        return this.m_mode;
    }

    protected void parseRequestHeaders() throws WebDAVServerException {
        this.parseDepthHeader();
    }

    protected void parseRequestBody() throws WebDAVServerException {
        Document body = this.getRequestBodyAsDocument();
        if (body != null) {
            Node currentNode;
            int i;
            Element rootElement = body.getDocumentElement();
            NodeList childList = rootElement.getChildNodes();
            Node node = null;
            block8: for (i = 0; i < childList.getLength(); ++i) {
                currentNode = childList.item(i);
                switch (currentNode.getNodeType()) {
                    case 3: {
                        continue block8;
                    }
                    case 1: {
                        if (currentNode.getNodeName().endsWith("allprop")) {
                            this.m_mode = 0;
                            continue block8;
                        }
                        if (currentNode.getNodeName().endsWith("prop")) {
                            this.m_mode = 1;
                            node = currentNode;
                            continue block8;
                        }
                        if (!currentNode.getNodeName().endsWith("propname")) continue block8;
                        this.m_mode = 2;
                    }
                }
            }
            if (this.m_mode == 1) {
                this.m_properties = new ArrayList();
                childList = node.getChildNodes();
                block9: for (i = 0; i < childList.getLength(); ++i) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block9;
                        }
                        case 1: {
                            this.m_properties.add(this.createProperty(currentNode));
                        }
                    }
                }
            }
        }
    }

    protected void executeImpl() throws WebDAVServerException, Exception {
        this.m_response.setStatus(207);
        FileFolderService fileFolderService = this.getFileFolderService();
        FileInfo pathNodeInfo = null;
        try {
            pathNodeInfo = this.getDAVHelper().getNodeForPath(this.getRootNodeRef(), this.m_strPath, this.m_request.getServletPath());
        }
        catch (FileNotFoundException e) {
            throw new WebDAVServerException(404);
        }
        this.m_response.setContentType("text/xml; charset=UTF-8");
        XMLWriter xml = this.createXMLWriter();
        xml.startDocument();
        String nsdec = this.generateNamespaceDeclarations(this.m_namespaces);
        xml.startElement("D", "multistatus" + nsdec, "D:multistatus" + nsdec, (Attributes)this.getDAVHelper().getNullAttributes());
        StringBuilder baseBuild = new StringBuilder(256);
        baseBuild.append(this.getPath());
        if (baseBuild.length() == 0 || baseBuild.charAt(baseBuild.length() - 1) != '/') {
            baseBuild.append('/');
        }
        String basePath = baseBuild.toString();
        this.generateResponseForNode(xml, pathNodeInfo, basePath);
        if (this.getDepth() != 0 && pathNodeInfo.isFolder()) {
            ArrayList<FileInfo> nodeInfos = new ArrayList<FileInfo>(10);
            nodeInfos.add(pathNodeInfo);
            int curDepth = 1;
            int baseLen = baseBuild.length();
            ArrayList<FileInfo> nextNodeInfos = null;
            if (this.getDepth() > 1) {
                nextNodeInfos = new ArrayList<FileInfo>(10);
            }
            while (curDepth <= this.getDepth() && nodeInfos != null) {
                if (nextNodeInfos != null) {
                    nextNodeInfos.clear();
                }
                for (FileInfo curNodeInfo : nodeInfos) {
                    List childNodeInfos = fileFolderService.list(curNodeInfo.getNodeRef());
                    if (childNodeInfos.size() == 0) continue;
                    baseBuild.setLength(baseLen);
                    try {
                        String pathSnippet = this.getDAVHelper().getPathFromNode(pathNodeInfo.getNodeRef(), curNodeInfo.getNodeRef());
                        baseBuild.append(pathSnippet);
                    }
                    catch (FileNotFoundException e) {
                        continue;
                    }
                    int curBaseLen = baseBuild.length();
                    for (FileInfo curChildInfo : childNodeInfos) {
                        if (curChildInfo.isLink()) continue;
                        baseBuild.setLength(curBaseLen);
                        baseBuild.append(curChildInfo.getName());
                        this.generateResponseForNode(xml, curChildInfo, baseBuild.toString());
                        if (nextNodeInfos == null || !curChildInfo.isFolder()) continue;
                        nextNodeInfos.add(curChildInfo);
                    }
                }
                ++curDepth;
                nodeInfos = nextNodeInfos;
            }
        }
        xml.endElement("D", "multistatus", "D:multistatus");
        xml.flush();
    }

    protected WebDAVProperty createProperty(Node node) {
        WebDAVProperty property = null;
        String strName = node.getLocalName();
        String strNamespaceUri = node.getNamespaceURI();
        property = "DAV:".equals(strNamespaceUri) ? new WebDAVProperty(strName) : new WebDAVProperty(strName, strNamespaceUri, this.getNamespaceName(strNamespaceUri));
        return property;
    }

    private String getNamespaceName(String strNamespaceUri) {
        if (strNamespaceUri == null) {
            return null;
        }
        String strNamespaceName = this.m_namespaces.get(strNamespaceUri);
        if (strNamespaceName == null) {
            strNamespaceName = "ns" + this.m_namespaces.size();
            this.m_namespaces.put(strNamespaceUri, strNamespaceName);
        }
        return strNamespaceName;
    }

    protected void generateResponseForNode(XMLWriter xml, FileInfo nodeInfo, String path) throws Exception {
        NodeRef nodeRef = nodeInfo.getNodeRef();
        boolean isFolder = nodeInfo.isFolder();
        xml.startElement("D", "response", "D:response", (Attributes)this.getDAVHelper().getNullAttributes());
        String strHRef = WebDAV.getURLForPath(this.m_request, path, isFolder);
        xml.startElement("D", "href", "D:href", (Attributes)this.getDAVHelper().getNullAttributes());
        xml.write(strHRef);
        xml.endElement("D", "href", "D:href");
        switch (this.m_mode) {
            case 1: {
                this.generateNamedPropertiesResponse(xml, nodeInfo);
                break;
            }
            case 0: {
                this.generateAllPropertiesResponse(xml, nodeRef, isFolder);
                break;
            }
            case 2: {
                this.generateFindPropertiesResponse(xml, nodeRef, isFolder);
            }
        }
        xml.endElement("D", "response", "D:response");
    }

    private void generateNamedPropertiesResponse(XMLWriter xml, FileInfo nodeInfo) throws Exception {
        String propName;
        NodeRef nodeRef = nodeInfo.getNodeRef();
        boolean isFolder = nodeInfo.isFolder();
        Map props = this.getNodeService().getProperties(nodeRef);
        AttributesImpl nullAttr = this.getDAVHelper().getNullAttributes();
        xml.startElement("D", "propstat", "D:propstat", (Attributes)nullAttr);
        xml.startElement("D", "prop", "D:prop", (Attributes)nullAttr);
        ArrayList<WebDAVProperty> propertiesNotFound = new ArrayList<WebDAVProperty>();
        TypeConverter typeConv = DefaultTypeConverter.INSTANCE;
        for (WebDAVProperty property : this.m_properties) {
            propName = property.getName();
            String propNamespaceUri = property.getNamespaceUri();
            Object davValue = null;
            if ("DAV:".equals(propNamespaceUri)) {
                if (propName.equals("lockdiscovery")) {
                    this.generateLockDiscoveryResponse(xml, nodeRef, isFolder);
                    continue;
                }
                if (propName.equals("supportedlock")) {
                    this.writeLockTypes(xml);
                    continue;
                }
                if (propName.equals("resourcetype")) {
                    xml.startElement("D", "resourcetype", "D:resourcetype", (Attributes)nullAttr);
                    if (isFolder) {
                        xml.write(DocumentHelper.createElement((String)"D:collection"));
                    }
                    xml.endElement("D", "resourcetype", "D:resourcetype");
                    continue;
                }
                if (propName.equals("displayname")) {
                    if (this.getRootNodeRef().equals((Object)nodeRef)) {
                        xml.write(DocumentHelper.createElement((String)"D:source"));
                        continue;
                    }
                    davValue = WebDAV.getDAVPropertyValue(props, "displayname");
                    xml.startElement("D", "displayname", "D:displayname", (Attributes)nullAttr);
                    if (davValue != null) {
                        String name = (String)typeConv.convert(String.class, davValue);
                        if (name == null || name.length() == 0) {
                            logger.error((Object)("WebDAV name is null, value=" + davValue.getClass().getName() + ", node=" + nodeRef));
                        }
                        xml.write(name);
                    }
                    xml.endElement("D", "displayname", "D:displayname");
                    continue;
                }
                if (propName.equals("source")) {
                    xml.write(DocumentHelper.createElement((String)"D:source"));
                    continue;
                }
                if (propName.equals("getlastmodified")) {
                    davValue = WebDAV.getDAVPropertyValue(props, "getlastmodified");
                    xml.startElement("D", "getlastmodified", "D:getlastmodified", (Attributes)nullAttr);
                    if (davValue != null) {
                        xml.write(WebDAV.formatModifiedDate((Date)typeConv.convert(Date.class, davValue)));
                    }
                    xml.endElement("D", "getlastmodified", "D:getlastmodified");
                    continue;
                }
                if (propName.equals("getcontentlanguage") && !isFolder) {
                    xml.startElement("D", "getcontentlanguage", "D:getcontentlanguage", (Attributes)nullAttr);
                    xml.endElement("D", "getcontentlanguage", "D:getcontentlanguage");
                    continue;
                }
                if (propName.equals("getcontenttype") && !isFolder) {
                    davValue = WebDAV.getDAVPropertyValue(props, "getcontenttype");
                    xml.startElement("D", "getcontenttype", "D:getcontenttype", (Attributes)nullAttr);
                    if (davValue != null) {
                        xml.write((String)typeConv.convert(String.class, davValue));
                    }
                    xml.endElement("D", "getcontenttype", "D:getcontenttype");
                    continue;
                }
                if (propName.equals("getetag") && !isFolder) {
                    xml.startElement("D", "getetag", "D:getetag", (Attributes)nullAttr);
                    xml.write(this.getDAVHelper().makeETag(nodeRef));
                    xml.endElement("D", "getetag", "D:getetag");
                    continue;
                }
                if (propName.equals("getcontentlength")) {
                    ContentData contentData;
                    long len = 0L;
                    if (!isFolder && (contentData = (ContentData)props.get(ContentModel.PROP_CONTENT)) != null) {
                        len = contentData.getSize();
                    }
                    xml.startElement("D", "getcontentlength", "D:getcontentlength", (Attributes)nullAttr);
                    xml.write("" + len);
                    xml.endElement("D", "getcontentlength", "D:getcontentlength");
                    continue;
                }
                if (propName.equals("creationdate")) {
                    davValue = WebDAV.getDAVPropertyValue(props, "creationdate");
                    xml.startElement("D", "creationdate", "D:creationdate", (Attributes)nullAttr);
                    if (davValue != null) {
                        xml.write(WebDAV.formatCreationDate((Date)typeConv.convert(Date.class, davValue)));
                    }
                    xml.endElement("D", "creationdate", "D:creationdate");
                    continue;
                }
                if (propName.equals("authticket")) {
                    SessionUser davUser = (SessionUser)this.m_request.getSession().getAttribute("_alfDAVAuthTicket");
                    xml.startElement("D", "authticket", "D:authticket", (Attributes)nullAttr);
                    if (davUser != null) {
                        xml.write(davUser.getTicket());
                    }
                    xml.endElement("D", "authticket", "D:authticket");
                    continue;
                }
                if (property.getName().equals("href")) continue;
                propertiesNotFound.add(property);
                continue;
            }
            String value = (String)((Object)this.getNodeService().getProperty(nodeRef, property.createQName()));
            if (value == null) {
                propertiesNotFound.add(property);
                continue;
            }
            if (property.hasNamespaceName()) {
                xml.startElement(property.getNamespaceName(), property.getName(), property.getNamespaceName() + ":" + property.getName(), (Attributes)nullAttr);
                xml.write(value);
                xml.endElement(property.getNamespaceName(), property.getName(), property.getNamespaceName() + ":" + property.getName());
                continue;
            }
            xml.startElement("", property.getName(), property.getName(), (Attributes)nullAttr);
            xml.write(value);
            xml.endElement("", property.getName(), property.getName());
        }
        xml.endElement("D", "prop", "D:prop");
        xml.startElement("D", "status", "D:status", (Attributes)nullAttr);
        xml.write("HTTP/1.1 200 OK");
        xml.endElement("D", "status", "D:status");
        xml.endElement("D", "propstat", "D:propstat");
        if (propertiesNotFound.size() > 0) {
            xml.startElement("D", "propstat", "D:propstat", (Attributes)nullAttr);
            xml.startElement("D", "prop", "D:prop", (Attributes)nullAttr);
            for (WebDAVProperty property : propertiesNotFound) {
                propName = property.getName();
                String propNamespaceName = property.getNamespaceName();
                String propQName = propName;
                if (propNamespaceName != null && propNamespaceName.length() > 0) {
                    propQName = propNamespaceName + ":" + propName;
                }
                xml.write(DocumentHelper.createElement((String)propQName));
            }
            xml.endElement("D", "prop", "D:prop");
            xml.startElement("D", "status", "D:status", (Attributes)nullAttr);
            xml.write("HTTP/1.1 404 Not Found");
            xml.endElement("D", "status", "D:status");
            xml.endElement("D", "propstat", "D:propstat");
        }
    }

    protected void generateAllPropertiesResponse(XMLWriter xml, NodeRef node, boolean isDir) throws Exception {
        ContentData contentData;
        Map props = this.getNodeService().getProperties(node);
        AttributesImpl nullAttr = this.getDAVHelper().getNullAttributes();
        xml.startElement("D", "propstat", "D:propstat", (Attributes)nullAttr);
        xml.startElement("D", "prop", "D:prop", (Attributes)nullAttr);
        this.generateLockDiscoveryResponse(xml, node, isDir);
        this.writeLockTypes(xml);
        xml.startElement("D", "resourcetype", "D:resourcetype", (Attributes)nullAttr);
        if (isDir) {
            xml.write(DocumentHelper.createElement((String)"D:collection"));
        }
        xml.endElement("D", "resourcetype", "D:resourcetype");
        Object davValue = WebDAV.getDAVPropertyValue(props, "displayname");
        TypeConverter typeConv = DefaultTypeConverter.INSTANCE;
        xml.startElement("D", "displayname", "D:displayname", (Attributes)nullAttr);
        if (davValue != null) {
            String name = (String)typeConv.convert(String.class, davValue);
            if (name == null || name.length() == 0) {
                logger.error((Object)("WebDAV name is null, value=" + davValue.getClass().getName() + ", node=" + node));
            }
            xml.write(name);
        }
        xml.endElement("D", "displayname", "D:displayname");
        xml.write(DocumentHelper.createElement((String)"D:source"));
        davValue = WebDAV.getDAVPropertyValue(props, "creationdate");
        xml.startElement("D", "creationdate", "D:creationdate", (Attributes)nullAttr);
        if (davValue != null) {
            xml.write(WebDAV.formatCreationDate((Date)typeConv.convert(Date.class, davValue)));
        }
        xml.endElement("D", "creationdate", "D:creationdate");
        davValue = WebDAV.getDAVPropertyValue(props, "getlastmodified");
        xml.startElement("D", "getlastmodified", "D:getlastmodified", (Attributes)nullAttr);
        if (davValue != null) {
            xml.write(WebDAV.formatModifiedDate((Date)typeConv.convert(Date.class, davValue)));
        }
        xml.endElement("D", "getlastmodified", "D:getlastmodified");
        if (!isDir) {
            xml.startElement("D", "getcontentlanguage", "D:getcontentlanguage", (Attributes)nullAttr);
            xml.endElement("D", "getcontentlanguage", "D:getcontentlanguage");
            davValue = WebDAV.getDAVPropertyValue(props, "getcontenttype");
            xml.startElement("D", "getcontenttype", "D:getcontenttype", (Attributes)nullAttr);
            if (davValue != null) {
                xml.write((String)typeConv.convert(String.class, davValue));
            }
            xml.endElement("D", "getcontenttype", "D:getcontenttype");
            xml.startElement("D", "getetag", "D:getetag", (Attributes)nullAttr);
            xml.write(this.getDAVHelper().makeETag(node));
            xml.endElement("D", "getetag", "D:getetag");
        }
        long len = 0L;
        if (!isDir && (contentData = (ContentData)props.get(ContentModel.PROP_CONTENT)) != null) {
            len = contentData.getSize();
        }
        xml.startElement("D", "getcontentlength", "D:getcontentlength", (Attributes)nullAttr);
        xml.write("" + len);
        xml.endElement("D", "getcontentlength", "D:getcontentlength");
        SessionUser davUser = (SessionUser)this.m_request.getSession().getAttribute("_alfDAVAuthTicket");
        xml.startElement("D", "authticket", "D:authticket", (Attributes)nullAttr);
        if (davUser != null) {
            xml.write(davUser.getTicket());
        }
        xml.endElement("D", "authticket", "D:authticket");
        xml.endElement("D", "prop", "D:prop");
        xml.startElement("D", "status", "D:status", (Attributes)nullAttr);
        xml.write("HTTP/1.1 200 OK");
        xml.endElement("D", "status", "D:status");
        xml.endElement("D", "propstat", "D:propstat");
    }

    protected void generateFindPropertiesResponse(XMLWriter xml, NodeRef node, boolean isDir) {
        try {
            AttributesImpl nullAttr = this.getDAVHelper().getNullAttributes();
            xml.startElement("D", "propstat", "D:propstat", (Attributes)nullAttr);
            xml.startElement("D", "prop", "D:prop", (Attributes)nullAttr);
            xml.write(DocumentHelper.createElement((String)"D:lockdiscovery"));
            xml.write(DocumentHelper.createElement((String)"D:supportedlock"));
            xml.write(DocumentHelper.createElement((String)"D:resourcetype"));
            xml.write(DocumentHelper.createElement((String)"D:displayname"));
            xml.write(DocumentHelper.createElement((String)"D:getlastmodified"));
            xml.write(DocumentHelper.createElement((String)"D:getcontentlength"));
            xml.write(DocumentHelper.createElement((String)"D:creationdate"));
            xml.write(DocumentHelper.createElement((String)"D:getetag"));
            if (isDir) {
                xml.write(DocumentHelper.createElement((String)"D:getcontentlanguage"));
                xml.write(DocumentHelper.createElement((String)"D:getcontenttype"));
            }
            xml.write(DocumentHelper.createElement((String)"D:authticket"));
            xml.endElement("D", "prop", "D:prop");
            xml.startElement("D", "status", "D:status", (Attributes)nullAttr);
            xml.write("HTTP/1.1 200 OK");
            xml.endElement("D", "status", "D:status");
            xml.endElement("D", "propstat", "D:propstat");
        }
        catch (Exception ex) {
            throw new AlfrescoRuntimeException("XML processing error", (Throwable)ex);
        }
    }

    protected void generateLockDiscoveryResponse(XMLWriter xml, NodeRef node, boolean isDir) throws Exception {
        LockInfo lockInfo = this.getNodeLockInfo(node);
        if (lockInfo.isLocked()) {
            this.generateLockDiscoveryXML(xml, node, lockInfo);
        }
    }

    protected void writeLockTypes(XMLWriter xml) {
        try {
            AttributesImpl nullAttr = this.getDAVHelper().getNullAttributes();
            xml.startElement("D", "supportedlock", "D:supportedlock", (Attributes)nullAttr);
            this.writeLock(xml, "D:exclusive");
            this.writeLock(xml, "D:shared");
            xml.endElement("D", "supportedlock", "D:supportedlock");
        }
        catch (Exception ex) {
            throw new AlfrescoRuntimeException("XML write error", (Throwable)ex);
        }
    }

    private void writeLock(XMLWriter xml, String lockType) throws SAXException, IOException {
        AttributesImpl nullAttr = this.getDAVHelper().getNullAttributes();
        xml.startElement("D", "lockentry", "D:lockentry", (Attributes)nullAttr);
        xml.startElement("D", "lockscope", "D:lockscope", (Attributes)nullAttr);
        xml.write(DocumentHelper.createElement((String)lockType));
        xml.endElement("D", "lockscope", "D:lockscope");
        xml.startElement("D", "locktype", "D:locktype", (Attributes)nullAttr);
        xml.write(DocumentHelper.createElement((String)"D:write"));
        xml.endElement("D", "locktype", "D:locktype");
        xml.endElement("D", "lockentry", "D:lockentry");
    }
}

