/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.io.Serializable;
import java.util.LinkedList;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WebDAVModel;
import org.alfresco.repo.webdav.LockInfo;
import org.alfresco.repo.webdav.WebDAV;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeService;

public class UnlockMethod
extends WebDAVMethod {
    private String m_strLockToken = null;

    protected final String getLockToken() {
        return this.m_strLockToken;
    }

    protected void parseRequestHeaders() throws WebDAVServerException {
        String strLockTokenHeader = this.m_request.getHeader("Lock-Token");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Parsing Lock-Token header: " + strLockTokenHeader));
        }
        if (strLockTokenHeader != null && strLockTokenHeader.startsWith("<") && strLockTokenHeader.endsWith(">")) {
            try {
                this.m_strLockToken = strLockTokenHeader.substring("opaquelocktoken:".length() + 1, strLockTokenHeader.length() - 1);
            }
            catch (IndexOutOfBoundsException e) {
                logger.warn((Object)("Failed to parse If header: " + strLockTokenHeader));
            }
        }
        if (this.m_strLockToken == null) {
            throw new WebDAVServerException(400);
        }
    }

    protected void parseRequestBody() throws WebDAVServerException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeImpl() throws WebDAVServerException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Lock node; path=" + this.getPath() + ", token=" + this.getLockToken()));
        }
        FileInfo lockNodeInfo = null;
        try {
            lockNodeInfo = this.getNodeForPath(this.getRootNodeRef(), this.getPath(), this.getServletPath());
        }
        catch (FileNotFoundException e) {
            throw new WebDAVServerException(404);
        }
        String[] lockInfo = WebDAV.parseLockToken(this.getLockToken());
        if (lockInfo == null) {
            throw new WebDAVServerException(412);
        }
        LockService lockService = this.getDAVHelper().getLockService();
        NodeService nodeService = this.getNodeService();
        LockStatus lockSts = lockService.getLockStatus(lockNodeInfo.getNodeRef());
        if (lockSts == LockStatus.LOCK_OWNER) {
            if (!nodeService.hasAspect(lockNodeInfo.getNodeRef(), ContentModel.ASPECT_WORKING_COPY)) {
                lockService.unlock(lockNodeInfo.getNodeRef());
            }
            nodeService.removeProperty(lockNodeInfo.getNodeRef(), WebDAVModel.PROP_OPAQUE_LOCK_TOKEN);
            nodeService.removeProperty(lockNodeInfo.getNodeRef(), WebDAVModel.PROP_LOCK_DEPTH);
            nodeService.removeProperty(lockNodeInfo.getNodeRef(), WebDAVModel.PROP_LOCK_SCOPE);
            this.m_response.setStatus(204);
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)("Unlock token=" + this.getLockToken() + " Successful"));
            return;
        }
        if (lockSts == LockStatus.NO_LOCK) {
            String sharedLocks = (String)((Object)nodeService.getProperty(lockNodeInfo.getNodeRef(), WebDAVModel.PROP_SHARED_LOCK_TOKENS));
            if (sharedLocks != null) {
                LinkedList<String> locks = LockInfo.parseSharedLockTokens(sharedLocks);
                if (locks == null) return;
                if (!locks.contains(this.m_strLockToken)) return;
                locks.remove(this.m_strLockToken);
                nodeService.setProperty(lockNodeInfo.getNodeRef(), WebDAVModel.PROP_SHARED_LOCK_TOKENS, (Serializable)((Object)LockInfo.makeSharedLockTokensString(locks)));
                this.m_response.setStatus(204);
                if (!logger.isDebugEnabled()) return;
                logger.debug((Object)("Unlock token=" + this.getLockToken() + " Successful"));
                return;
            }
            if (!logger.isDebugEnabled()) throw new WebDAVServerException(412);
            logger.debug((Object)("Unlock token=" + this.getLockToken() + " Not locked"));
            throw new WebDAVServerException(412);
        }
        if (lockSts == LockStatus.LOCKED) {
            if (!logger.isDebugEnabled()) throw new WebDAVServerException(412);
            logger.debug((Object)("Unlock token=" + this.getLockToken() + " Not lock owner"));
            throw new WebDAVServerException(412);
        }
        if (lockSts != LockStatus.LOCK_EXPIRED) return;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unlock token=" + this.getLockToken() + " Lock expired"));
        }
        this.m_response.setStatus(204);
    }
}

