/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav.auth;

import org.alfresco.repo.SessionUser;
import org.alfresco.service.cmr.repository.NodeRef;

public class WebDAVUser
implements SessionUser {
    private static final long serialVersionUID = -6948146071131901345L;
    private String m_userName;
    private String m_ticket;
    private NodeRef m_homeNode;

    public WebDAVUser(String user, String ticket, NodeRef homeNode) {
        this.m_userName = user;
        this.m_ticket = ticket;
        this.m_homeNode = homeNode;
    }

    public final String getUserName() {
        return this.m_userName;
    }

    public final String getTicket() {
        return this.m_ticket;
    }

    public final boolean hasHomeNode() {
        return this.m_homeNode != null;
    }

    public final NodeRef getHomeNode() {
        return this.m_homeNode;
    }

    protected final void setHomeNode(NodeRef homeNode) {
        this.m_homeNode = homeNode;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getUserName());
        str.append(":");
        str.append(this.getTicket());
        if (this.hasHomeNode()) {
            str.append(",Home=");
            str.append(this.getHomeNode());
        }
        str.append("]");
        return str.toString();
    }
}

