/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice.axis;

import org.alfresco.repo.webservice.Utils;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.providers.java.RPCProvider;
import org.springframework.web.context.WebApplicationContext;

public class SpringBeanRPCProvider
extends RPCProvider {
    private static final long serialVersionUID = 2173234269124176995L;
    private static final String OPTION_NAME = "springBean";
    private static WebApplicationContext webAppCtx;

    protected Class getServiceClass(String beanName, SOAPService service, MessageContext msgCtx) throws AxisFault {
        Class<?> clazz = null;
        Object bean = this.getBean(msgCtx, beanName);
        if (bean != null) {
            clazz = bean.getClass();
        }
        return clazz;
    }

    protected String getServiceClassNameOptionName() {
        return OPTION_NAME;
    }

    protected Object makeNewServiceObject(MessageContext msgCtx, String beanName) throws Exception {
        return this.getBean(msgCtx, beanName);
    }

    private Object getBean(MessageContext msgCtx, String beanName) throws AxisFault {
        return this.getWebAppContext(msgCtx).getBean(beanName);
    }

    private WebApplicationContext getWebAppContext(MessageContext msgCtx) throws AxisFault {
        if (webAppCtx == null && msgCtx != null) {
            webAppCtx = Utils.getSpringContext(msgCtx);
        }
        if (webAppCtx == null) {
            throw new AxisFault("Failed to retrieve the Spring web application context");
        }
        return webAppCtx;
    }

    public void initServiceDesc(SOAPService service, MessageContext msgContext) throws AxisFault {
        if (msgContext != null) {
            this.getWebAppContext(msgContext);
        }
        super.initServiceDesc(service, msgContext);
    }
}

