/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.blocks.Connection;
import org.jgroups.blocks.ConnectionMap;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnectionMap<V extends Connection>
implements ConnectionMap<V> {
    protected final Vector<ConnectionMapListener<V>> conn_listeners = new Vector();
    protected final Map<Address, V> conns = new HashMap<Address, V>();
    protected final Lock lock = new ReentrantLock();
    protected final ThreadFactory factory;
    protected final long reaperInterval;
    protected final Reaper reaper;
    protected final Log log = LogFactory.getLog(this.getClass());

    public AbstractConnectionMap(ThreadFactory factory) {
        this(factory, 0L);
    }

    public AbstractConnectionMap(ThreadFactory factory, long reaperInterval) {
        this.factory = factory;
        this.reaperInterval = reaperInterval;
        this.reaper = reaperInterval > 0L ? new Reaper() : null;
    }

    public Lock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOpenConnection(Address address) {
        this.lock.lock();
        try {
            Connection v = (Connection)this.conns.get(address);
            boolean bl = v != null && v.isOpen();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasConnection(Address address) {
        this.lock.lock();
        try {
            boolean bl = this.conns.containsKey(address);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Address address, V conn) {
        this.lock.lock();
        try {
            this.conns.put(address, conn);
        }
        finally {
            this.lock.unlock();
        }
        this.notifyConnectionOpened(address, conn);
    }

    public void addConnectionMapListener(ConnectionMapListener<V> cml) {
        if (cml != null && !this.conn_listeners.contains(cml)) {
            this.conn_listeners.addElement(cml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumConnections() {
        this.lock.lock();
        try {
            int n = this.conns.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ThreadFactory getThreadFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(Address address) {
        Connection conn = null;
        this.lock.lock();
        try {
            conn = (Connection)this.conns.remove(address);
        }
        finally {
            this.lock.unlock();
        }
        Util.close(conn);
    }

    public void removeConnectionMapListener(ConnectionMapListener<V> cml) {
        if (cml != null) {
            this.conn_listeners.removeElement(cml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retainAll(Collection<Address> current_mbrs) {
        if (current_mbrs == null) {
            return;
        }
        HashMap<Address, V> copy = null;
        this.lock.lock();
        try {
            copy = new HashMap<Address, V>(this.conns);
            this.conns.keySet().retainAll(current_mbrs);
        }
        finally {
            this.lock.unlock();
        }
        copy.keySet().removeAll(current_mbrs);
        for (Map.Entry e : copy.entrySet()) {
            Util.close((Connection)e.getValue());
        }
        copy.clear();
    }

    public void start() throws Exception {
        if (this.reaper != null) {
            this.reaper.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.reaper != null) {
            this.reaper.stop();
        }
        this.lock.lock();
        try {
            for (Map.Entry<Address, V> e : this.conns.entrySet()) {
                Util.close((Connection)e.getValue());
            }
        }
        finally {
            this.lock.unlock();
        }
        this.clear();
        this.conn_listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        this.lock.lock();
        try {
            this.conns.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void notifyConnectionClosed(Address address) {
        for (ConnectionMapListener<V> l : this.conn_listeners) {
            l.connectionClosed(address);
        }
    }

    protected void notifyConnectionOpened(Address address, V conn) {
        for (ConnectionMapListener<V> l : this.conn_listeners) {
            l.connectionOpened(address, conn);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ConnectionMapListener<V> {
        public void connectionClosed(Address var1);

        public void connectionOpened(Address var1, V var2);
    }

    class Reaper
    implements Runnable {
        private Thread thread;

        Reaper() {
        }

        public synchronized void start() {
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = AbstractConnectionMap.this.factory.newThread(new Reaper(), "Reaper");
                this.thread.start();
            }
        }

        public synchronized void stop() {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
                try {
                    this.thread.join(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.thread = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                AbstractConnectionMap.this.lock.lock();
                try {
                    Iterator it = AbstractConnectionMap.this.conns.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        Connection c = (Connection)entry.getValue();
                        if (!c.isExpired(System.currentTimeMillis())) continue;
                        AbstractConnectionMap.this.log.info("Connection " + c.toString() + " reaped");
                        Util.close(c);
                        it.remove();
                    }
                }
                finally {
                    AbstractConnectionMap.this.lock.unlock();
                }
                Util.sleep(AbstractConnectionMap.this.reaperInterval);
            }
        }
    }
}

