/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.View;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Unsupported;
import org.jgroups.blocks.Cache;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Experimental
@Unsupported
public class ReplCache<K, V>
implements MembershipListener,
Cache.ChangeListener {
    private Cache<K, Value<V>> l2_cache = new Cache();
    private Cache<K, V> l1_cache = null;
    private static final Log log = LogFactory.getLog(ReplCache.class);
    private JChannel ch = null;
    private Address local_addr = null;
    private View view;
    private RpcDispatcher disp = null;
    @ManagedAttribute(writable=true)
    private String props = "udp.xml";
    @ManagedAttribute(writable=true)
    private String cluster_name = "ReplCache-Cluster";
    @ManagedAttribute(writable=true)
    private long call_timeout = 1000L;
    @ManagedAttribute(writable=true)
    private long caching_time = 30000L;
    @ManagedAttribute
    private short default_replication_count = 1;
    private HashFunction<K> hash_function = null;
    private HashFunctionFactory<K> hash_function_factory = new HashFunctionFactory<K>(){

        @Override
        public HashFunction<K> create() {
            return new ConsistentHashFunction();
        }
    };
    private Set<MembershipListener> membership_listeners = new HashSet<MembershipListener>();
    private Set<ChangeListener> change_listeners = new HashSet<ChangeListener>();
    @ManagedAttribute(writable=true)
    private boolean migrate_data = true;
    private static final short PUT = 1;
    private static final short PUT_FORCE = 2;
    private static final short GET = 3;
    private static final short REMOVE = 4;
    private static final short REMOVE_MANY = 5;
    protected static Map<Short, Method> methods = new ConcurrentHashMap<Short, Method>(8);
    private TimeScheduler timer;

    public ReplCache(String props, String cluster_name) {
        this.props = props;
        this.cluster_name = cluster_name;
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String props) {
        this.props = props;
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    @ManagedAttribute
    public String getLocalAddressAsString() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    @ManagedAttribute
    public String getView() {
        return this.view != null ? this.view.toString() : "null";
    }

    @ManagedAttribute
    public int getClusterSize() {
        return this.view != null ? this.view.size() : 0;
    }

    @ManagedAttribute
    public boolean isL1CacheEnabled() {
        return this.l1_cache != null;
    }

    public String getClusterName() {
        return this.cluster_name;
    }

    public void setClusterName(String cluster_name) {
        this.cluster_name = cluster_name;
    }

    public long getCallTimeout() {
        return this.call_timeout;
    }

    public void setCallTimeout(long call_timeout) {
        this.call_timeout = call_timeout;
    }

    public long getCachingTime() {
        return this.caching_time;
    }

    public void setCachingTime(long caching_time) {
        this.caching_time = caching_time;
    }

    public boolean isMigrateData() {
        return this.migrate_data;
    }

    public void setMigrateData(boolean migrate_data) {
        this.migrate_data = migrate_data;
    }

    public short getDefaultReplicationCount() {
        return this.default_replication_count;
    }

    public void setDefaultReplicationCount(short default_replication_count) {
        this.default_replication_count = default_replication_count;
    }

    public HashFunction getHashFunction() {
        return this.hash_function;
    }

    public void setHashFunction(HashFunction<K> hash_function) {
        this.hash_function = hash_function;
    }

    public HashFunctionFactory getHashFunctionFactory() {
        return this.hash_function_factory;
    }

    public void setHashFunctionFactory(HashFunctionFactory<K> hash_function_factory) {
        this.hash_function_factory = hash_function_factory;
    }

    public void addMembershipListener(MembershipListener l) {
        this.membership_listeners.add(l);
    }

    public void removeMembershipListener(MembershipListener l) {
        this.membership_listeners.remove(l);
    }

    public void addChangeListener(ChangeListener l) {
        this.change_listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.change_listeners.remove(l);
    }

    public Cache<K, V> getL1Cache() {
        return this.l1_cache;
    }

    public void setL1Cache(Cache<K, V> cache) {
        if (this.l1_cache != null) {
            this.l1_cache.stop();
        }
        this.l1_cache = cache;
    }

    public Cache<K, Value<V>> getL2Cache() {
        return this.l2_cache;
    }

    public void setL2Cache(Cache<K, Value<V>> cache) {
        if (cache != null) {
            this.l2_cache.stop();
            this.l2_cache = cache;
        }
    }

    @ManagedOperation
    public void start() throws Exception {
        if (this.hash_function_factory != null) {
            this.hash_function = this.hash_function_factory.create();
        }
        if (this.hash_function == null) {
            this.hash_function = new ConsistentHashFunction();
        }
        this.ch = new JChannel(this.props);
        this.disp = new RpcDispatcher((Channel)this.ch, null, (MembershipListener)this, (Object)this);
        CustomMarshaller marshaller = new CustomMarshaller();
        this.disp.setRequestMarshaller(marshaller);
        this.disp.setResponseMarshaller(marshaller);
        this.disp.setMethodLookup(new MethodLookup(){

            public Method findMethod(short id) {
                return methods.get(id);
            }
        });
        this.ch.connect(this.cluster_name);
        this.local_addr = this.ch.getAddress();
        this.view = this.ch.getView();
        this.timer = this.ch.getProtocolStack().getTransport().getTimer();
        this.l2_cache.addChangeListener(this);
    }

    @ManagedOperation
    public void stop() {
        if (this.l1_cache != null) {
            this.l1_cache.stop();
        }
        if (this.migrate_data) {
            ArrayList<Address> members_without_me = new ArrayList<Address>(this.view.getMembers());
            members_without_me.remove(this.local_addr);
            HashFunction<K> tmp_hash_function = this.hash_function_factory.create();
            tmp_hash_function.installNodes(members_without_me);
            for (Map.Entry<K, Cache.Value<Value<V>>> entry : this.l2_cache.entrySet()) {
                List<Address> nodes;
                short repl_count;
                Value<V> tmp;
                K key = entry.getKey();
                Cache.Value<Value<V>> val = entry.getValue();
                if (val == null || (tmp = val.getValue()) == null || (repl_count = tmp.getReplicationCount()) != 1 || (nodes = tmp_hash_function.hash(key, repl_count)) == null || nodes.isEmpty() || nodes.contains(this.local_addr)) continue;
                Address dest = nodes.get(0);
                this.move(dest, key, tmp.getVal(), repl_count, val.getTimeout(), true);
                this._remove(key);
            }
        }
        this.l2_cache.removeChangeListener(this);
        this.l2_cache.stop();
        this.disp.stop();
        this.ch.close();
    }

    @ManagedOperation
    public void put(K key, V val, short repl_count, long timeout) {
        if (repl_count == 0) {
            if (log.isWarnEnabled()) {
                log.warn("repl_count of 0 is invalid, data will not be stored in the cluster");
            }
            return;
        }
        this.mcastPut(key, val, repl_count, timeout, false);
        if (this.l1_cache != null && timeout >= 0L) {
            this.l1_cache.put(key, val, timeout);
        }
    }

    @ManagedOperation
    public void put(K key, V val) {
        this.put(key, val, this.default_replication_count, this.caching_time);
    }

    @ManagedOperation
    public V get(K key) {
        Value tmp;
        Object val;
        if (this.l1_cache != null && (val = this.l1_cache.get(key)) != null) {
            if (log.isTraceEnabled()) {
                log.trace("returned value " + val + " for " + key + " from L1 cache");
            }
            return (V)val;
        }
        val = this.l2_cache.getEntry(key);
        if (val != null && (tmp = (Value)((Cache.Value)val).getValue()) != null) {
            Object real_value = tmp.getVal();
            if (real_value != null && this.l1_cache != null && ((Cache.Value)val).getTimeout() >= 0L) {
                this.l1_cache.put(key, real_value, ((Cache.Value)val).getTimeout());
            }
            return tmp.getVal();
        }
        try {
            RspList rsps = this.disp.callRemoteMethods(null, new MethodCall(3, new Object[]{key}), 2, this.call_timeout);
            for (Rsp rsp : rsps.values()) {
                Object obj = rsp.getValue();
                if (obj == null || obj instanceof Throwable || (val = (Cache.Value)rsp.getValue()) == null || (tmp = (Value)((Cache.Value)val).getValue()) == null) continue;
                Object real_value = tmp.getVal();
                if (real_value != null && this.l1_cache != null && ((Cache.Value)val).getTimeout() >= 0L) {
                    this.l1_cache.put(key, real_value, ((Cache.Value)val).getTimeout());
                }
                return real_value;
            }
            return null;
        }
        catch (Throwable t) {
            if (log.isWarnEnabled()) {
                log.warn("get() failed", t);
            }
            return null;
        }
    }

    @ManagedOperation
    public void remove(K key) {
        block3: {
            try {
                this.disp.callRemoteMethods(null, new MethodCall(4, new Object[]{key}), 6, this.call_timeout);
                if (this.l1_cache != null) {
                    this.l1_cache.remove(key);
                }
            }
            catch (Throwable t) {
                if (!log.isWarnEnabled()) break block3;
                log.warn("remove() failed", t);
            }
        }
    }

    @ManagedOperation
    public void clear() {
        HashSet keys = new HashSet(this.l2_cache.getInternalMap().keySet());
        this.mcastClear(keys, false);
    }

    public V _put(K key, V val, short repl_count, long timeout) {
        return this._put(key, val, repl_count, timeout, false);
    }

    public V _put(K key, V val, short repl_count, long timeout, boolean force) {
        if (!force) {
            boolean accept;
            boolean bl = accept = repl_count == -1;
            if (!accept) {
                if (this.view != null && repl_count >= this.view.size()) {
                    accept = true;
                } else {
                    List<Address> selected_hosts;
                    List<Address> list = selected_hosts = this.hash_function != null ? this.hash_function.hash(key, repl_count) : null;
                    if (selected_hosts != null) {
                        if (log.isTraceEnabled()) {
                            log.trace("local=" + this.local_addr + ", hosts=" + selected_hosts);
                        }
                        for (Address addr : selected_hosts) {
                            if (!addr.equals(this.local_addr)) continue;
                            accept = true;
                            break;
                        }
                    }
                    if (!accept) {
                        return null;
                    }
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("_put(" + key + ", " + val + ", " + repl_count + ", " + timeout + ")");
        }
        Value<V> value = new Value<V>(val, repl_count);
        Value<V> retval = this.l2_cache.put(key, value, timeout);
        if (this.l1_cache != null) {
            this.l1_cache.remove(key);
        }
        this.notifyChangeListeners();
        return retval != null ? (V)retval.getVal() : null;
    }

    public Cache.Value<Value<V>> _get(K key) {
        if (log.isTraceEnabled()) {
            log.trace("_get(" + key + ")");
        }
        return this.l2_cache.getEntry(key);
    }

    public V _remove(K key) {
        if (log.isTraceEnabled()) {
            log.trace("_remove(" + key + ")");
        }
        Value<V> retval = this.l2_cache.remove(key);
        if (this.l1_cache != null) {
            this.l1_cache.remove(key);
        }
        this.notifyChangeListeners();
        return retval != null ? (V)retval.getVal() : null;
    }

    public void _removeMany(Set<K> keys) {
        if (log.isTraceEnabled()) {
            log.trace("_removeMany(): " + keys.size() + " entries");
        }
        for (K key : keys) {
            this._remove(key);
        }
    }

    @Override
    public void viewAccepted(final View new_view) {
        final ArrayList<Address> old_nodes = this.view != null ? new ArrayList<Address>(this.view.getMembers()) : null;
        this.view = new_view;
        if (log.isInfoEnabled()) {
            log.info("new view: " + new_view);
        }
        if (this.hash_function != null) {
            this.hash_function.installNodes(new_view.getMembers());
        }
        for (MembershipListener l : this.membership_listeners) {
            l.viewAccepted(new_view);
        }
        if (old_nodes != null) {
            this.timer.schedule(new Runnable(){

                public void run() {
                    ReplCache.this.rebalance(old_nodes, new ArrayList<Address>(new_view.getMembers()));
                }
            }, 100L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void suspect(Address suspected_mbr) {
    }

    @Override
    public void block() {
    }

    @Override
    public void changed() {
        this.notifyChangeListeners();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.l1_cache != null) {
            sb.append("L1 cache: " + this.l1_cache.getSize() + " entries");
        }
        sb.append("\nL2 cache: " + this.l2_cache.getSize() + "entries()");
        return sb.toString();
    }

    @ManagedOperation
    public String dump() {
        StringBuilder sb = new StringBuilder();
        if (this.l1_cache != null) {
            sb.append("L1 cache:\n").append(this.l1_cache.dump());
        }
        sb.append("\nL2 cache:\n").append(this.l2_cache.dump());
        return sb.toString();
    }

    private void notifyChangeListeners() {
        for (ChangeListener l : this.change_listeners) {
            try {
                l.changed();
            }
            catch (Throwable t) {
                if (!log.isErrorEnabled()) continue;
                log.error("failed notifying change listener", t);
            }
        }
    }

    private void rebalance(List<Address> old_nodes, List<Address> new_nodes) {
        HashFunction old_func = this.hash_function_factory.create();
        old_func.installNodes(old_nodes);
        HashFunction new_func = this.hash_function_factory.create();
        new_func.installNodes(new_nodes);
        boolean is_coord = Util.isCoordinator(this.ch);
        ArrayList keys = new ArrayList(this.l2_cache.getInternalMap().keySet());
        for (Object key : keys) {
            Cache.Value<Value<V>> val = this.l2_cache.getEntry(key);
            if (log.isTraceEnabled()) {
                log.trace("==== rebalancing " + key);
            }
            if (val == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn(key + " has no value associated; ignoring");
                continue;
            }
            Value<V> tmp = val.getValue();
            if (tmp == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn(key + " has no value associated; ignoring");
                continue;
            }
            V real_value = tmp.getVal();
            short repl_count = tmp.getReplicationCount();
            List<Address> new_mbrs = Util.newMembers(old_nodes, new_nodes);
            if (repl_count == -1) {
                if (!is_coord) continue;
                for (Address new_mbr : new_mbrs) {
                    this.move(new_mbr, key, real_value, repl_count, val.getTimeout(), false);
                }
                continue;
            }
            if (repl_count == 1) {
                Address mbr;
                List<Address> tmp_nodes = new_func.hash(key, repl_count);
                if (tmp_nodes.isEmpty() || (mbr = tmp_nodes.get(0)).equals(this.local_addr)) continue;
                this.move(mbr, key, real_value, repl_count, val.getTimeout(), false);
                this._remove(key);
                continue;
            }
            if (repl_count > 1) {
                List<Address> tmp_old = old_func.hash(key, repl_count);
                List<Address> tmp_new = new_func.hash(key, repl_count);
                if (log.isTraceEnabled()) {
                    log.trace("old nodes: " + tmp_old + "\nnew nodes: " + tmp_new);
                }
                if (tmp_old != null && tmp_new != null && ((Object)tmp_old).equals(tmp_new)) continue;
                this.mcastPut(key, real_value, repl_count, val.getTimeout(), false);
                if (tmp_new == null || tmp_new.contains(this.local_addr)) continue;
                this._remove(key);
                continue;
            }
            throw new IllegalStateException("replication count is invalid (" + repl_count + ")");
        }
    }

    public void mcastEntries() {
        for (Map.Entry<K, Cache.Value<Value<V>>> entry : this.l2_cache.entrySet()) {
            K key = entry.getKey();
            Cache.Value<Value<V>> val = entry.getValue();
            if (val == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn(key + " has no value associated; ignoring");
                continue;
            }
            Value<V> tmp = val.getValue();
            if (tmp == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn(key + " has no value associated; ignoring");
                continue;
            }
            V real_value = tmp.getVal();
            short repl_count = tmp.getReplicationCount();
            if (repl_count <= 1) continue;
            this._remove(key);
            this.mcastPut(key, real_value, repl_count, val.getTimeout(), false);
        }
    }

    private void mcastPut(K key, V val, short repl_count, long caching_time, boolean synchronous) {
        block2: {
            try {
                int mode = synchronous ? 2 : 6;
                this.disp.callRemoteMethods(null, new MethodCall(1, new Object[]{key, val, repl_count, caching_time}), mode, this.call_timeout);
            }
            catch (Throwable t) {
                if (!log.isWarnEnabled()) break block2;
                log.warn("put() failed", t);
            }
        }
    }

    private void mcastClear(Set<K> keys, boolean synchronous) {
        block2: {
            try {
                int mode = synchronous ? 2 : 6;
                this.disp.callRemoteMethods(null, new MethodCall(5, new Object[]{keys}), mode, this.call_timeout);
            }
            catch (Throwable t) {
                if (!log.isWarnEnabled()) break block2;
                log.warn("clear() failed", t);
            }
        }
    }

    private void move(Address dest, K key, V val, short repl_count, long caching_time, boolean synchronous) {
        block2: {
            try {
                int mode = synchronous ? 2 : 6;
                this.disp.callRemoteMethod(dest, new MethodCall(2, new Object[]{key, val, repl_count, caching_time, true}), mode, this.call_timeout);
            }
            catch (Throwable t) {
                if (!log.isWarnEnabled()) break block2;
                log.warn("move() failed", t);
            }
        }
    }

    static {
        try {
            methods.put((short)1, ReplCache.class.getMethod("_put", Object.class, Object.class, Short.TYPE, Long.TYPE));
            methods.put((short)2, ReplCache.class.getMethod("_put", Object.class, Object.class, Short.TYPE, Long.TYPE, Boolean.TYPE));
            methods.put((short)3, ReplCache.class.getMethod("_get", Object.class));
            methods.put((short)4, ReplCache.class.getMethod("_remove", Object.class));
            methods.put((short)5, ReplCache.class.getMethod("_removeMany", Set.class));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static class CustomMarshaller
    implements RpcDispatcher.Marshaller {
        static final byte NULL = 0;
        static final byte OBJ = 1;
        static final byte METHOD_CALL = 2;
        static final byte VALUE = 3;

        private CustomMarshaller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] objectToByteBuffer(Object obj) throws Exception {
            ByteArrayOutputStream out_stream = new ByteArrayOutputStream(35);
            DataOutputStream out = new DataOutputStream(out_stream);
            try {
                if (obj == null) {
                    out_stream.write(0);
                    out_stream.flush();
                    byte[] byArray = out_stream.toByteArray();
                    return byArray;
                }
                if (obj instanceof MethodCall) {
                    out.writeByte(2);
                    MethodCall call = (MethodCall)obj;
                    out.writeShort(call.getId());
                    Object[] args = call.getArgs();
                    if (args == null || args.length == 0) {
                        out.writeShort(0);
                    } else {
                        out.writeShort(args.length);
                        for (int i = 0; i < args.length; ++i) {
                            Util.objectToStream(args[i], out);
                        }
                    }
                } else if (obj instanceof Cache.Value) {
                    Cache.Value value = (Cache.Value)obj;
                    out.writeByte(3);
                    out.writeLong(value.getTimeout());
                    Util.objectToStream(value.getValue(), out);
                } else {
                    out.writeByte(1);
                    Util.objectToStream(obj, out);
                }
                out.flush();
                byte[] byArray = out_stream.toByteArray();
                return byArray;
            }
            finally {
                Util.close(out);
            }
        }

        public Object objectFromByteBuffer(byte[] buf) throws Exception {
            if (buf == null) {
                return null;
            }
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(buf));
            byte type = in.readByte();
            if (type == 0) {
                return null;
            }
            if (type == 2) {
                Object[] args;
                short id = in.readShort();
                short length = in.readShort();
                Object[] objectArray = args = length > 0 ? new Object[length] : null;
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        args[i] = Util.objectFromStream(in);
                    }
                }
                return new MethodCall(id, args);
            }
            if (type == 3) {
                long expiration_time = in.readLong();
                Object obj = Util.objectFromStream(in);
                return new Cache.Value<Object>(obj, expiration_time);
            }
            return Util.objectFromStream(in);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Value<V>
    implements Serializable {
        private final V val;
        private final short replication_count;
        private static final long serialVersionUID = -2892941069742740027L;

        public Value(V val, short replication_count) {
            this.val = val;
            this.replication_count = replication_count;
        }

        public V getVal() {
            return this.val;
        }

        public short getReplicationCount() {
            return this.replication_count;
        }

        public String toString() {
            return this.val + " (" + this.replication_count + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConsistentHashFunction<K>
    implements HashFunction<K> {
        private SortedMap<Short, Address> nodes = new TreeMap<Short, Address>();
        private static final int HASH_SPACE = 2000;
        private static final int FACTOR = 3737;

        @Override
        public List<Address> hash(K key, short replication_count) {
            Address val;
            int hash = Math.abs(key.hashCode());
            int index = hash % 2000;
            LinkedHashSet<Address> results = new LinkedHashSet<Address>();
            ArrayList<Address> retval = new ArrayList<Address>();
            SortedMap<Short, Address> tailmap = this.nodes.tailMap((short)index);
            int count = 0;
            for (Map.Entry<Short, Address> entry : tailmap.entrySet()) {
                val = entry.getValue();
                results.add(val);
                if (++count < replication_count) continue;
                break;
            }
            if (count < replication_count) {
                for (Map.Entry<Short, Address> entry : this.nodes.entrySet()) {
                    val = entry.getValue();
                    results.add(val);
                    if (++count < replication_count) continue;
                    break;
                }
            }
            retval.addAll(results);
            return retval;
        }

        @Override
        public void installNodes(List<Address> new_nodes) {
            this.nodes.clear();
            block0: for (Address node : new_nodes) {
                int hash;
                for (int i = hash = Math.abs(node.hashCode() * 3737) % 2000; i < hash + 2000; ++i) {
                    short new_index = (short)(i % 2000);
                    if (this.nodes.containsKey(new_index)) continue;
                    this.nodes.put(new_index, node);
                    continue block0;
                }
            }
            if (log.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder("node mappings:\n");
                for (Map.Entry<Short, Address> entry : this.nodes.entrySet()) {
                    sb.append(entry.getKey() + ": " + entry.getValue()).append("\n");
                }
                log.trace(sb);
            }
        }
    }

    public static interface ChangeListener {
        public void changed();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface HashFunctionFactory<K> {
        public HashFunction<K> create();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface HashFunction<K> {
        public List<Address> hash(K var1, short var2);

        public void installNodes(List<Address> var1);
    }
}

