/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.MBeanServer;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.annotations.Unsupported;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Unsupported
public class ReplicatedTree2
implements Runnable,
MessageListener,
MembershipListener {
    public static final String SEPARATOR = "/";
    static final int INDENT = 4;
    Node root = new NodeImpl("/", "/", null, null);
    final Vector listeners = new Vector();
    final Queue request_queue = new Queue();
    Thread request_handler = null;
    JChannel channel = null;
    PullPushAdapter adapter = null;
    String groupname = "ReplicatedTree-Group";
    final Vector members = new Vector();
    long state_fetch_timeout = 10000L;
    boolean jmx = false;
    protected final Log log = LogFactory.getLog(this.getClass());
    boolean remote_calls = true;
    String props = "UDP(mcast_addr=224.0.0.36;mcast_port=55566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.STABLE(desired_avg_gossip=20000):pbcast.NAKACK(gc_lag=50;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=5000):FRAG(frag_size=16000;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;print_local_addr=true):pbcast.STATE_TRANSFER";
    private boolean send_message = false;

    public ReplicatedTree2(String groupname, String props, long state_fetch_timeout) throws Exception {
        if (groupname != null) {
            this.groupname = groupname;
        }
        if (props != null) {
            this.props = props;
        }
        this.state_fetch_timeout = state_fetch_timeout;
        this.channel = new JChannel(this.props);
        this.channel.connect(this.groupname);
        this.start();
    }

    public ReplicatedTree2(String groupname, String props, long state_fetch_timeout, boolean jmx) throws Exception {
        if (groupname != null) {
            this.groupname = groupname;
        }
        if (props != null) {
            this.props = props;
        }
        this.jmx = jmx;
        this.state_fetch_timeout = state_fetch_timeout;
        this.channel = new JChannel(this.props);
        this.channel.connect(this.groupname);
        if (jmx) {
            MBeanServer server = Util.getMBeanServer();
            if (server == null) {
                throw new Exception("No MBeanServers found; need to run with an MBeanServer present, or inside JDK 5");
            }
            JmxConfigurator.registerChannel(this.channel, server, "jgroups", this.channel.getClusterName(), true);
        }
        this.start();
    }

    public ReplicatedTree2() {
    }

    public ReplicatedTree2(JChannel channel) throws Exception {
        this.channel = channel;
        this.start();
    }

    public void setRemoteCalls(boolean flag) {
        this.remote_calls = flag;
    }

    public void setRootNode(Node n) {
        this.root = n;
    }

    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getAddress() : null;
    }

    public Vector getMembers() {
        return this.members;
    }

    public void fetchState(long timeout) throws ChannelClosedException, ChannelNotConnectedException {
        boolean rc = this.channel.getState(null, timeout);
        if (this.log.isInfoEnabled()) {
            if (rc) {
                this.log.info("state was retrieved successfully");
            } else {
                this.log.info("state could not be retrieved (first member)");
            }
        }
    }

    public void addReplicatedTreeListener(ReplicatedTreeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeReplicatedTreeListener(ReplicatedTreeListener listener) {
        this.listeners.removeElement(listener);
    }

    public final void start() throws Exception {
        if (this.request_handler == null) {
            this.request_handler = new Thread((Runnable)this, "ReplicatedTree2.RequestHandler thread");
            this.request_handler.setDaemon(true);
            this.request_handler.start();
        }
        this.adapter = new PullPushAdapter(this.channel, this, this);
        this.adapter.setListener(this);
        boolean rc = this.channel.getState(null, this.state_fetch_timeout);
        if (this.log.isInfoEnabled()) {
            if (rc) {
                this.log.info("state was retrieved successfully");
            } else {
                this.log.info("state could not be retrieved (first member)");
            }
        }
    }

    public void stop() {
        if (this.request_handler != null && this.request_handler.isAlive()) {
            this.request_queue.close(true);
            this.request_handler = null;
        }
        this.request_handler = null;
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.adapter != null) {
            this.adapter.stop();
            this.adapter = null;
        }
        this.channel = null;
    }

    public void put(String fqn, HashMap data) {
        if (!this.remote_calls) {
            this._put(fqn, data);
            return;
        }
        if (this.send_message) {
            if (this.channel == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("channel is null, cannot broadcast PUT request");
                }
                return;
            }
            try {
                this.channel.send(new Message(null, null, new Request(1, fqn, data)));
            }
            catch (Exception ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failure bcasting PUT request: " + ex);
                }
            }
        } else {
            this._put(fqn, data);
        }
    }

    public void put(String fqn, String key, Object value) {
        if (!this.remote_calls) {
            this._put(fqn, key, value);
            return;
        }
        if (this.send_message) {
            if (this.channel == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("channel is null, cannot broadcast PUT request");
                }
                return;
            }
            try {
                this.channel.send(new Message(null, null, new Request(1, fqn, key, value)));
            }
            catch (Exception ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failure bcasting PUT request: " + ex);
                }
            }
        } else {
            this._put(fqn, key, value);
        }
    }

    public void remove(String fqn) {
        if (!this.remote_calls) {
            this._remove(fqn);
            return;
        }
        if (this.send_message) {
            if (this.channel == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("channel is null, cannot broadcast REMOVE request");
                }
                return;
            }
            try {
                this.channel.send(new Message(null, null, new Request(2, fqn)));
            }
            catch (Exception ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failure bcasting REMOVE request: " + ex);
                }
            }
        } else {
            this._remove(fqn);
        }
    }

    public void remove(String fqn, String key) {
        if (!this.remote_calls) {
            this._remove(fqn, key);
            return;
        }
        if (this.send_message) {
            if (this.channel == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("channel is null, cannot broadcast REMOVE request");
                }
                return;
            }
            try {
                this.channel.send(new Message(null, null, new Request(2, fqn, key)));
            }
            catch (Exception ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failure bcasting REMOVE request: " + ex);
                }
            }
        } else {
            this._remove(fqn, key);
        }
    }

    public boolean exists(String fqn) {
        if (fqn == null) {
            return false;
        }
        return this.findNode(fqn) != null;
    }

    public Set getKeys(String fqn) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        Map data = n.getData();
        if (data == null) {
            return null;
        }
        return data.keySet();
    }

    public Object get(String fqn, String key) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        return n.getData(key);
    }

    Map get(String fqn) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        return n.getData();
    }

    public String print(String fqn) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        return n.toString();
    }

    public Set getChildrenNames(String fqn) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        Map m = n.getChildren();
        if (m != null) {
            return m.keySet();
        }
        return null;
    }

    public String getGroupName() {
        return this.groupname;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public int getGroupMembersNumber() {
        return this.members.size();
    }

    public void _put(String fqn, HashMap data) {
        StringHolder child_name = new StringHolder();
        boolean child_exists = false;
        if (fqn == null) {
            return;
        }
        Node n = this.findParentNode(fqn, child_name, true);
        if (child_name.getValue() != null) {
            child_exists = n.childExists(child_name.getValue());
            n.createChild(child_name.getValue(), fqn, n, data);
        } else {
            child_exists = true;
            n.setData(data);
        }
        if (child_exists) {
            this.notifyNodeModified(fqn);
        } else {
            this.notifyNodeAdded(fqn);
        }
    }

    public void _put(String fqn, String key, Object value) {
        boolean child_exists = false;
        if (fqn == null || key == null || value == null) {
            return;
        }
        List<String> elements = Util.split(fqn, 47);
        String child_name = elements.get(elements.size() - 1);
        Node n = this.findParentNode(elements, true);
        if (child_name != null) {
            child_exists = n.childExists(child_name);
            n.createChild(child_name, fqn, n, key, value);
        } else {
            child_exists = true;
            n.setData(key, value);
        }
        if (child_exists) {
            this.notifyNodeModified(fqn);
        } else {
            this.notifyNodeAdded(fqn);
        }
    }

    public void _remove(String fqn) {
        StringHolder child_name = new StringHolder();
        if (fqn == null) {
            return;
        }
        if (fqn.equals(SEPARATOR)) {
            this.root.removeAll();
            this.notifyNodeRemoved(fqn);
            return;
        }
        Node n = this.findParentNode(fqn, child_name, false);
        if (n == null) {
            return;
        }
        n.removeChild(child_name.getValue(), fqn);
        this.notifyNodeRemoved(fqn);
    }

    public void _remove(String fqn, String key) {
        if (fqn == null || key == null) {
            return;
        }
        Node n = this.findNode(fqn);
        if (n != null) {
            n.removeData(key);
        }
    }

    public void _removeData(String fqn) {
        if (fqn == null) {
            return;
        }
        Node n = this.findNode(fqn);
        if (n != null) {
            n.removeData();
        }
    }

    @Override
    public void receive(Message msg) {
        block5: {
            Request req = null;
            if (msg == null || msg.getLength() == 0) {
                return;
            }
            try {
                req = (Request)msg.getObject();
                this.request_queue.add(req);
            }
            catch (QueueClosedException queue_closed_ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("request queue is null");
                }
            }
            catch (Exception ex) {
                if (!this.log.isErrorEnabled()) break block5;
                this.log.error("failed unmarshalling request: " + ex);
            }
        }
    }

    @Override
    public byte[] getState() {
        try {
            return Util.objectToByteBuffer(this.root.clone());
        }
        catch (Throwable ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error("exception returning cache: " + ex);
            }
            return null;
        }
    }

    @Override
    public void setState(byte[] new_state) {
        block4: {
            Node new_root = null;
            if (new_state == null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("new cache is null");
                }
                return;
            }
            try {
                Object obj = Util.objectFromByteBuffer(new_state);
                this.root = new_root = (Node)((Node)obj).clone();
                this.notifyAllNodesCreated(this.root);
            }
            catch (Throwable ex) {
                if (!this.log.isErrorEnabled()) break block4;
                this.log.error("could not set cache: " + ex);
            }
        }
    }

    @Override
    public void viewAccepted(View new_view) {
        Vector<Address> new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.notifyViewChange(new_view);
            this.members.removeAllElements();
            for (int i = 0; i < new_mbrs.size(); ++i) {
                this.members.addElement(new_mbrs.elementAt(i));
            }
        }
        this.send_message = this.members.size() > 1;
    }

    @Override
    public void suspect(Address suspected_mbr) {
    }

    @Override
    public void block() {
    }

    @Override
    public void run() {
        String fqn = null;
        block7: while (this.request_handler != null) {
            try {
                Request req = (Request)this.request_queue.remove(0L);
                fqn = req.fqn;
                switch (req.type) {
                    case 1: {
                        if (req.key != null && req.value != null) {
                            this._put(fqn, req.key, req.value);
                            continue block7;
                        }
                        this._put(fqn, req.data);
                        continue block7;
                    }
                    case 2: {
                        if (req.key != null) {
                            this._remove(fqn, req.key);
                            continue block7;
                        }
                        this._remove(fqn);
                        continue block7;
                    }
                }
                if (!this.log.isErrorEnabled()) continue;
                this.log.error("type " + req.type + " unknown");
            }
            catch (QueueClosedException queue_closed_ex) {
                this.request_handler = null;
                break;
            }
            catch (Throwable other_ex) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn("exception processing request: " + other_ex);
            }
        }
    }

    Node findParentNode(String fqn, StringHolder child_name, boolean create_if_not_exists) {
        Node curr = this.root;
        StringBuilder sb = null;
        if (fqn == null || fqn.equals(SEPARATOR) || "".equals(fqn)) {
            return curr;
        }
        sb = new StringBuilder();
        StringTokenizer tok = new StringTokenizer(fqn, SEPARATOR);
        while (tok.countTokens() > 1) {
            String name = tok.nextToken();
            sb.append(SEPARATOR).append(name);
            Node node = curr.getChild(name);
            if (node == null && create_if_not_exists) {
                node = curr.createChild(name, sb.toString(), null, null);
            }
            if (node == null) {
                return null;
            }
            curr = node;
        }
        if (tok.countTokens() > 0 && child_name != null) {
            child_name.setValue(tok.nextToken());
        }
        return curr;
    }

    Node findParentNode(List<String> fqn, boolean create_if_not_exists) {
        if (fqn == null || fqn.isEmpty()) {
            return this.root;
        }
        Node curr = this.root;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fqn.size() - 1; ++i) {
            String name = fqn.get(i);
            sb.append(SEPARATOR).append(name);
            Node node = curr.getChild(name);
            if (node == null && create_if_not_exists) {
                node = curr.createChild(name, sb.toString(), null, null);
            }
            if (node == null) {
                return null;
            }
            curr = node;
        }
        return curr;
    }

    Node findNode(String fqn) {
        StringHolder sh = new StringHolder();
        Node n = this.findParentNode(fqn, sh, false);
        String child_name = sh.getValue();
        if (fqn == null || fqn.equals(SEPARATOR) || "".equals(fqn)) {
            return this.root;
        }
        if (n == null || child_name == null) {
            return null;
        }
        return n.getChild(child_name);
    }

    void notifyNodeAdded(String fqn) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ReplicatedTreeListener)this.listeners.elementAt(i)).nodeAdded(fqn);
        }
    }

    void notifyNodeRemoved(String fqn) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ReplicatedTreeListener)this.listeners.elementAt(i)).nodeRemoved(fqn);
        }
    }

    void notifyNodeModified(String fqn) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ReplicatedTreeListener)this.listeners.elementAt(i)).nodeModified(fqn);
        }
    }

    void notifyViewChange(View v) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ReplicatedTreeListener)this.listeners.elementAt(i)).viewChange(v);
        }
    }

    void notifyAllNodesCreated(Node curr) {
        if (curr == null) {
            return;
        }
        this.notifyNodeAdded(curr.getFqn());
        Map children = curr.getChildren();
        if (children != null) {
            for (Node n : children.values()) {
                this.notifyAllNodesCreated(n);
            }
        }
    }

    public static Map createMap() {
        return new HashMap();
    }

    public static Map createMap(Map map) {
        return new HashMap(map);
    }

    static class MyListener
    implements ReplicatedTreeListener {
        MyListener() {
        }

        public void nodeAdded(String fqn) {
            System.out.println("** node added: " + fqn);
        }

        public void nodeRemoved(String fqn) {
            System.out.println("** node removed: " + fqn);
        }

        public void nodeModified(String fqn) {
            System.out.println("** node modified: " + fqn);
        }

        public void viewChange(View new_view) {
            System.out.println("** view change: " + new_view);
        }
    }

    private static class Request
    implements Serializable {
        static final int PUT = 1;
        static final int REMOVE = 2;
        int type = 0;
        String fqn = null;
        String key = null;
        Object value = null;
        HashMap data = null;
        private static final long serialVersionUID = 7772753222127676782L;

        private Request(int type, String fqn) {
            this.type = type;
            this.fqn = fqn;
        }

        private Request(int type, String fqn, HashMap data) {
            this(type, fqn);
            this.data = data;
        }

        private Request(int type, String fqn, String key) {
            this(type, fqn);
            this.key = key;
        }

        private Request(int type, String fqn, String key, Object value) {
            this(type, fqn);
            this.key = key;
            this.value = value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(Request.type2String(this.type)).append(" (");
            if (this.fqn != null) {
                sb.append(" fqn=" + this.fqn);
            }
            switch (this.type) {
                case 1: {
                    if (this.data != null) {
                        sb.append(", data=" + this.data);
                    }
                    if (this.key != null) {
                        sb.append(", key=" + this.key);
                    }
                    if (this.value == null) break;
                    sb.append(", value=" + this.value);
                    break;
                }
                case 2: {
                    if (this.key == null) break;
                    sb.append(", key=" + this.key);
                    break;
                }
            }
            sb.append(')');
            return sb.toString();
        }

        static String type2String(int t) {
            switch (t) {
                case 1: {
                    return "PUT";
                }
                case 2: {
                    return "REMOVE";
                }
            }
            return "UNKNOWN";
        }
    }

    private static class StringHolder {
        String s = null;

        private StringHolder() {
        }

        void setValue(String s) {
            this.s = s;
        }

        String getValue() {
            return this.s;
        }
    }

    public static class LeafNodeOneKey
    implements Node {
        private static final long serialVersionUID = -8848955385138463778L;
        private String key;
        private Object val;

        private LeafNodeOneKey(Map data) {
            if (data == null) {
                return;
            }
            if (data.size() > 1) {
                throw new IllegalArgumentException("map can have only 1 key/value pair");
            }
            Iterator it = data.entrySet().iterator();
            Map.Entry entry = it.next();
            this.key = (String)entry.getKey();
            this.val = entry.getValue();
        }

        private LeafNodeOneKey(String key, Object value) {
            this.key = key;
            this.val = value;
        }

        public void setData(Map data) {
            if (data == null) {
                return;
            }
            if (data.size() > 1) {
                throw new IllegalArgumentException("map can have only 1 key/value pair");
            }
            Iterator it = data.entrySet().iterator();
            Map.Entry entry = it.next();
            this.key = (String)entry.getKey();
            this.val = entry.getValue();
        }

        public void setData(String key, Object value) {
            this.key = key;
            this.val = value;
        }

        public Map getData() {
            Map retval = ReplicatedTree2.createMap();
            retval.put(this.key, this.val);
            return retval;
        }

        public String getFqn() {
            return null;
        }

        public Object getData(String key) {
            return this.val;
        }

        public boolean childExists(String child_name) {
            return false;
        }

        public Node createChild(String child_name, String fqn, Node parent, HashMap data) {
            throw new UnsupportedOperationException();
        }

        public Node createChild(String child_name, String fqn, Node parent, String key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Node getChild(String child_name) {
            return null;
        }

        public Map getChildren() {
            return null;
        }

        public void setChildren(Map children) {
            throw new UnsupportedOperationException();
        }

        public void removeData(String key) {
            if (key != null && this.key != null && this.key.equals(key)) {
                key = null;
                this.val = null;
            }
        }

        public void removeData() {
            this.key = null;
            this.val = null;
        }

        public void removeChild(String child_name, String fqn) {
        }

        public void removeAll() {
        }

        public void print(StringBuilder sb, int indent) {
        }

        public void printIndent(StringBuilder sb, int indent) {
            if (sb != null) {
                for (int i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.key).append("=").append(this.val);
            return sb.toString();
        }

        public Object clone() throws CloneNotSupportedException {
            return new LeafNodeOneKey(this.key, this.val);
        }
    }

    public static class NodeImpl
    implements Node {
        String name = null;
        String fqn = null;
        Map children = null;
        Map data = null;
        private static final long serialVersionUID = -3077676554440038890L;

        private NodeImpl(String child_name, String fqn, Node parent, Map data) {
            this.name = child_name;
            this.fqn = fqn;
            if (data != null) {
                this.data = ReplicatedTree2.createMap(data);
            }
        }

        private NodeImpl(String child_name, String fqn, Node parent, String key, Object value) {
            this.name = child_name;
            this.fqn = fqn;
            if (this.data == null) {
                this.data = ReplicatedTree2.createMap();
            }
            this.data.put(key, value);
        }

        public void setData(Map data) {
            if (data == null) {
                return;
            }
            if (this.data == null) {
                this.data = ReplicatedTree2.createMap();
            }
            this.data.putAll(data);
        }

        public void setData(String key, Object value) {
            if (this.data == null) {
                this.data = ReplicatedTree2.createMap();
            }
            this.data.put(key, value);
        }

        public Map getData() {
            return this.data;
        }

        public String getFqn() {
            return this.fqn;
        }

        public Object getData(String key) {
            return this.data != null ? this.data.get(key) : null;
        }

        public boolean childExists(String child_name) {
            return child_name != null && this.children != null && this.children.containsKey(child_name);
        }

        public Node createChild(String child_name, String fqn, Node parent, HashMap data) {
            Node child = null;
            if (child_name == null) {
                return null;
            }
            if (this.children == null) {
                this.children = ReplicatedTree2.createMap();
            }
            if ((child = (Node)this.children.get(child_name)) != null) {
                child.setData(data);
            } else {
                child = new NodeImpl(child_name, fqn, parent, data);
                this.children.put(child_name, child);
            }
            return child;
        }

        public Node createChild(String child_name, String fqn, Node parent, String key, Object value) {
            Node child = null;
            if (child_name == null) {
                return null;
            }
            if (this.children == null) {
                this.children = ReplicatedTree2.createMap();
            }
            if ((child = (Node)this.children.get(child_name)) != null) {
                child.setData(key, value);
            } else {
                child = new LeafNodeOneKey(key, value);
                this.children.put(child_name, child);
            }
            return child;
        }

        public Node getChild(String child_name) {
            return child_name == null ? null : (this.children == null ? null : (Node)this.children.get(child_name));
        }

        public Map getChildren() {
            return this.children;
        }

        public void setChildren(Map children) {
            this.children = children;
        }

        public void removeData(String key) {
            if (this.data != null) {
                this.data.remove(key);
            }
        }

        public void removeData() {
            if (this.data != null) {
                this.data.clear();
            }
        }

        public void removeChild(String child_name, String fqn) {
            if (child_name != null && this.children != null && this.children.containsKey(child_name)) {
                this.children.remove(child_name);
            }
        }

        public void removeAll() {
            if (this.children != null) {
                this.children.clear();
            }
        }

        public void print(StringBuilder sb, int indent) {
            this.printIndent(sb, indent);
            sb.append(ReplicatedTree2.SEPARATOR).append(this.name);
            if (this.children != null && !this.children.isEmpty()) {
                Collection values = this.children.values();
                Iterator it = values.iterator();
                while (it.hasNext()) {
                    sb.append('\n');
                    ((Node)it.next()).print(sb, indent + 4);
                }
            }
        }

        public void printIndent(StringBuilder sb, int indent) {
            if (sb != null) {
                for (int i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.name != null) {
                sb.append("\nname=" + this.name);
            }
            if (this.fqn != null) {
                sb.append("\nfqn=" + this.fqn);
            }
            if (this.data != null) {
                sb.append("\ndata=" + this.data);
            }
            return sb.toString();
        }

        public Object clone() throws CloneNotSupportedException {
            NodeImpl n = new NodeImpl(this.name, this.fqn, null, this.data);
            if (this.children != null) {
                n.setChildren(ReplicatedTree2.createMap(this.children));
            }
            return n;
        }
    }

    public static interface Node
    extends Serializable {
        public void setData(Map var1);

        public void setData(String var1, Object var2);

        public Map getData();

        public String getFqn();

        public Object getData(String var1);

        public boolean childExists(String var1);

        public Node createChild(String var1, String var2, Node var3, HashMap var4);

        public Node createChild(String var1, String var2, Node var3, String var4, Object var5);

        public Node getChild(String var1);

        public Map getChildren();

        public void setChildren(Map var1);

        public void removeData(String var1);

        public void removeData();

        public void removeChild(String var1, String var2);

        public void removeAll();

        public void print(StringBuilder var1, int var2);

        public void printIndent(StringBuilder var1, int var2);

        public Object clone() throws CloneNotSupportedException;
    }

    public static interface ReplicatedTreeListener {
        public void nodeAdded(String var1);

        public void nodeRemoved(String var1);

        public void nodeModified(String var1);

        public void viewChange(View var1);
    }
}

