/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.List;
import java.util.Properties;
import org.jgroups.View;
import org.jgroups.conf.PropertyConverter;
import org.jgroups.util.Util;

public class PropertyConverters {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Default
    implements PropertyConverter {
        @Override
        public Object convert(Class<?> propertyFieldType, Properties props, String propertyValue) throws Exception {
            if (propertyValue == null) {
                throw new NullPointerException("Property value cannot be null");
            }
            if (Boolean.TYPE.equals(propertyFieldType)) {
                return Boolean.parseBoolean(propertyValue);
            }
            if (Integer.TYPE.equals(propertyFieldType)) {
                return Integer.parseInt(propertyValue);
            }
            if (Long.TYPE.equals(propertyFieldType)) {
                return Long.parseLong(propertyValue);
            }
            if (Byte.TYPE.equals(propertyFieldType)) {
                return Byte.parseByte(propertyValue);
            }
            if (Double.TYPE.equals(propertyFieldType)) {
                return Double.parseDouble(propertyValue);
            }
            if (Short.TYPE.equals(propertyFieldType)) {
                return Short.parseShort(propertyValue);
            }
            if (Float.TYPE.equals(propertyFieldType)) {
                return Float.valueOf(Float.parseFloat(propertyValue));
            }
            return propertyValue;
        }

        @Override
        public String toString(Object value) {
            return value != null ? value.toString() : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongArray
    implements PropertyConverter {
        @Override
        public Object convert(Class<?> propertyFieldType, Properties props, String propertyValue) throws Exception {
            long[] tmp = Util.parseCommaDelimitedLongs(propertyValue);
            if (tmp != null && tmp.length > 0) {
                return tmp;
            }
            return null;
        }

        @Override
        public String toString(Object value) {
            if (value == null) {
                return null;
            }
            long[] val = (long[])value;
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (long l : val) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(l);
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BindAddress
    implements PropertyConverter {
        @Override
        public Object convert(Class<?> propertyFieldType, Properties props, String propertyValue) throws Exception {
            return Util.getBindAddress(props);
        }

        @Override
        public String toString(Object value) {
            InetAddress val = (InetAddress)value;
            return val.getHostAddress();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FlushInvoker
    implements PropertyConverter {
        @Override
        public Object convert(Class<?> propertyFieldType, Properties props, String propertyValue) throws Exception {
            if (propertyValue == null) {
                return null;
            }
            Class<?> invoker = Class.forName(propertyValue);
            invoker.getDeclaredConstructor(View.class);
            return invoker;
        }

        @Override
        public String toString(Object value) {
            return value.getClass().getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NetworkInterfaceList
    implements PropertyConverter {
        @Override
        public Object convert(Class<?> propertyFieldType, Properties props, String propertyValue) throws Exception {
            return Util.parseInterfaceList(propertyValue);
        }

        @Override
        public String toString(Object value) {
            List list = (List)value;
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (NetworkInterface intf : list) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(intf.getName());
            }
            return sb.toString();
        }
    }
}

