/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgroups.conf.ProtocolData;
import org.jgroups.conf.ProtocolParameter;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.Configurator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlConfigurator
implements ProtocolStackConfigurator {
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_INHERIT = "inherit";
    public static final String ELMT_PROT_OVERRIDE = "protocol-override";
    public static final String ELMT_PROT = "protocol";
    public static final String ELMT_PROT_NAME = "protocol-name";
    public static final String ELMT_CLASS = "class-name";
    public static final String ELMT_DESCRIPTION = "description";
    public static final String ELMT_PROT_PARAMS = "protocol-params";
    private final ArrayList<ProtocolData> mProtocolStack = new ArrayList();
    private final String mStackName;
    protected static final Log log = LogFactory.getLog(XmlConfigurator.class);

    protected XmlConfigurator(String stackName, ProtocolData[] protocols) {
        this.mStackName = stackName;
        this.mProtocolStack.addAll(Arrays.asList(protocols));
    }

    protected XmlConfigurator(String stackName) {
        this(stackName, new ProtocolData[0]);
    }

    public static XmlConfigurator getInstance(URL url) throws IOException {
        return XmlConfigurator.getInstance(url.openStream());
    }

    public static XmlConfigurator getInstance(InputStream stream) throws IOException {
        return XmlConfigurator.parse(stream);
    }

    public static XmlConfigurator getInstance(Element el) throws IOException {
        return XmlConfigurator.parse(el);
    }

    public String getProtocolStackString(boolean convert) {
        StringBuilder buf = new StringBuilder();
        Iterator<ProtocolData> it = this.mProtocolStack.iterator();
        if (convert) {
            buf.append("<config>\n");
        }
        while (it.hasNext()) {
            ProtocolData d = it.next();
            if (convert) {
                buf.append("    <");
            }
            buf.append(d.getProtocolString(convert));
            if (convert) {
                buf.append("/>");
            }
            if (!it.hasNext()) continue;
            if (convert) {
                buf.append('\n');
                continue;
            }
            buf.append(':');
        }
        if (convert) {
            buf.append("\n</config>");
        }
        return buf.toString();
    }

    @Override
    public String getProtocolStackString() {
        return this.getProtocolStackString(false);
    }

    @Override
    public ProtocolData[] getProtocolStack() {
        return this.mProtocolStack.toArray(new ProtocolData[this.mProtocolStack.size()]);
    }

    public String getName() {
        return this.mStackName;
    }

    public void override(ProtocolData data) throws IOException {
        int index = this.mProtocolStack.indexOf(data);
        if (index < 0) {
            throw new IOException("You can not override a protocol that doesn't exist");
        }
        ProtocolData source = this.mProtocolStack.get(index);
        source.override(data.getParametersAsArray());
    }

    public void add(ProtocolData data) {
        this.mProtocolStack.add(data);
    }

    protected static XmlConfigurator parse(InputStream stream) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(stream);
            Element configElement = document.getDocumentElement();
            return XmlConfigurator.parse(configElement);
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            IOException tmp = new IOException();
            tmp.initCause(x);
            throw tmp;
        }
    }

    protected static XmlConfigurator parse(Element root_element) throws IOException {
        XmlConfigurator configurator = null;
        LinkedList<ProtocolData> prot_data = new LinkedList<ProtocolData>();
        try {
            String root_name = root_element.getNodeName();
            if (!"config".equals(root_name.trim().toLowerCase())) {
                log.fatal("XML protocol stack configuration does not start with a '<config>' element; maybe the XML configuration needs to be converted to the new format ?\nuse 'java org.jgroups.conf.XmlConfigurator <old XML file> -new_format' to do so");
                throw new IOException("invalid XML configuration");
            }
            NodeList prots = root_element.getChildNodes();
            for (int i = 0; i < prots.getLength(); ++i) {
                Node node = prots.item(i);
                if (node.getNodeType() != 1) continue;
                Element tag = (Element)node;
                String protocol = tag.getTagName();
                LinkedList<ProtocolParameter> tmp = new LinkedList<ProtocolParameter>();
                NamedNodeMap attrs = tag.getAttributes();
                int attrLength = attrs.getLength();
                for (int a = 0; a < attrLength; ++a) {
                    Attr attr = (Attr)attrs.item(a);
                    String name = attr.getName();
                    String value = attr.getValue();
                    tmp.add(new ProtocolParameter(name, value));
                }
                ProtocolParameter[] params = new ProtocolParameter[tmp.size()];
                for (int j = 0; j < tmp.size(); ++j) {
                    params[j] = (ProtocolParameter)tmp.get(j);
                }
                ProtocolData data = new ProtocolData(protocol, protocol, params);
                prot_data.add(data);
            }
            ProtocolData[] data = new ProtocolData[prot_data.size()];
            for (int k = 0; k < prot_data.size(); ++k) {
                data[k] = (ProtocolData)prot_data.get(k);
            }
            configurator = new XmlConfigurator("bla", data);
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            IOException tmp = new IOException();
            tmp.initCause(x);
            throw tmp;
        }
        return configurator;
    }

    protected static ProtocolParameter[] parseProtocolParameters(Element protparams) throws IOException {
        try {
            Vector<ProtocolParameter> v = new Vector<ProtocolParameter>();
            protparams.normalize();
            NodeList parameters = protparams.getChildNodes();
            for (int i = 0; i < parameters.getLength(); ++i) {
                if (parameters.item(i).getNodeType() != 1) continue;
                String pname = parameters.item(i).getAttributes().getNamedItem(ATTR_NAME).getNodeValue();
                String pvalue = parameters.item(i).getAttributes().getNamedItem(ATTR_VALUE).getNodeValue();
                ProtocolParameter p = new ProtocolParameter(pname, pvalue);
                v.addElement(p);
            }
            Object[] result = new ProtocolParameter[v.size()];
            v.copyInto(result);
            return result;
        }
        catch (Exception x) {
            IOException tmp = new IOException();
            tmp.initCause(x);
            throw tmp;
        }
    }

    public static void main(String[] args) throws Exception {
        String input_file = null;
        boolean old_format = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-old")) {
                old_format = true;
                continue;
            }
            if (args[i].equals("-file")) {
                input_file = args[++i];
                continue;
            }
            XmlConfigurator.help();
            return;
        }
        if (input_file != null) {
            InputStream input = null;
            try {
                input = new FileInputStream(new File(input_file));
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (input == null) {
                try {
                    input = new URL(input_file).openStream();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (input == null) {
                input = Thread.currentThread().getContextClassLoader().getResourceAsStream(input_file);
            }
            if (old_format) {
                Configurator config = new Configurator();
                String cfg = XmlConfigurator.inputAsString(input);
                Vector<Configurator.ProtocolConfiguration> tmp = config.parseConfigurations(cfg);
                System.out.println(XmlConfigurator.dump(tmp));
            } else {
                XmlConfigurator conf = XmlConfigurator.getInstance(input);
                String tmp = conf.getProtocolStackString();
                System.out.println("\n" + tmp);
            }
        } else {
            log.error("no input file given");
        }
    }

    private static String dump(Vector<Configurator.ProtocolConfiguration> tmp) {
        StringBuilder sb = new StringBuilder();
        String indent = "  ";
        sb.append("<config>\n");
        for (Configurator.ProtocolConfiguration cfg : tmp) {
            sb.append(indent).append("<").append(cfg.getProtocolName());
            Properties props = cfg.getProperties();
            if (props.isEmpty()) {
                sb.append(" />\n");
                continue;
            }
            sb.append("\n").append(indent).append(indent);
            Iterator<Map.Entry<Object, Object>> it2 = props.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry<Object, Object> entry = it2.next();
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                key = XmlConfigurator.trim(key);
                val = XmlConfigurator.trim(val);
                sb.append(key).append("=\"").append(val).append("\"");
                if (!it2.hasNext()) continue;
                sb.append("\n").append(indent).append(indent);
            }
            sb.append(" />\n");
        }
        sb.append("</config>\n");
        return sb.toString();
    }

    private static String trim(String val) {
        String retval = "";
        val = val.trim();
        while (true) {
            int index;
            if ((index = val.indexOf(10)) == -1) break;
            retval = retval + val.substring(0, index);
            val = val.substring(index + 1);
        }
        retval = retval + val;
        return retval;
    }

    private static String inputAsString(InputStream input) throws IOException {
        int len = input.available();
        byte[] buf = new byte[len];
        input.read(buf, 0, len);
        return new String(buf);
    }

    public static String replace(String input, String expr, String replacement) {
        StringBuilder sb = new StringBuilder();
        int new_index = 0;
        int index = 0;
        int len = expr.length();
        int input_len = input.length();
        while (true) {
            if ((new_index = input.indexOf(expr, index)) == -1) break;
            sb.append(input.substring(index, new_index));
            sb.append(replacement);
            index = new_index + len;
        }
        sb.append(input.substring(index, input_len));
        return sb.toString();
    }

    static void help() {
        System.out.println("XmlConfigurator -file <input XML file> [-old]");
        System.out.println("(-old: converts old (plain-text) input format into new XML format)");
    }
}

