/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.FragHeader;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Range;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean(description="Fragments messages larger than fragmentation size into smaller packets")
@DeprecatedProperty(names={"overhead"})
public class FRAG2
extends Protocol {
    private static final String name = "FRAG2";
    @Property(description="The max number of bytes in a message. Larger messages will be fragmented. Default is 1500 bytes")
    @ManagedAttribute(description="Fragmentation size", writable=true)
    int frag_size = 1500;
    private final ConcurrentMap<Address, ConcurrentMap<Long, FragEntry>> fragment_list = new ConcurrentHashMap<Address, ConcurrentMap<Long, FragEntry>>(11);
    private int curr_id = 1;
    private final Vector<Address> members = new Vector(11);
    @ManagedAttribute(description="Number of sent messages")
    AtomicLong num_sent_msgs = new AtomicLong(0L);
    @ManagedAttribute(description="Number of received messages")
    AtomicLong num_received_msgs = new AtomicLong(0L);
    @ManagedAttribute(description="Number of sent fragments")
    AtomicLong num_sent_frags = new AtomicLong(0L);
    @ManagedAttribute(description="Number of received fragments")
    AtomicLong num_received_frags = new AtomicLong(0L);

    @Override
    public final String getName() {
        return name;
    }

    public int getFragSize() {
        return this.frag_size;
    }

    public void setFragSize(int s) {
        this.frag_size = s;
    }

    public int getOverhead() {
        return 0;
    }

    public void setOverhead(int o) {
    }

    public long getNumberOfSentMessages() {
        return this.num_sent_msgs.get();
    }

    public long getNumberOfSentFragments() {
        return this.num_sent_frags.get();
    }

    public long getNumberOfReceivedMessages() {
        return this.num_received_msgs.get();
    }

    public long getNumberOfReceivedFragments() {
        return this.num_received_frags.get();
    }

    synchronized int getNextId() {
        return this.curr_id++;
    }

    @Override
    public void init() throws Exception {
        int max_bundle_size;
        super.init();
        int old_frag_size = this.frag_size;
        if (this.frag_size <= 0) {
            throw new Exception("frag_size=" + old_frag_size + ", new frag_size=" + this.frag_size + ": new frag_size is invalid");
        }
        TP transport = this.getTransport();
        if (transport != null && transport.isEnableBundling() && this.frag_size >= (max_bundle_size = transport.getMaxBundleSize())) {
            throw new IllegalArgumentException("frag_size (" + this.frag_size + ") has to be < TP.max_bundle_size (" + max_bundle_size + ")");
        }
        HashMap<String, Integer> info = new HashMap<String, Integer>(1);
        info.put("frag_size", this.frag_size);
        this.up_prot.up(new Event(56, info));
        this.down_prot.down(new Event(56, info));
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_sent_msgs.set(0L);
        this.num_sent_frags.set(0L);
        this.num_received_frags.set(0L);
        this.num_received_msgs.set(0L);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                long size = msg.getLength();
                this.num_sent_msgs.incrementAndGet();
                if (size <= (long)this.frag_size) break;
                if (this.log.isTraceEnabled()) {
                    this.log.trace(new StringBuilder("message's buffer size is ").append(size).append(", will fragment ").append("(frag_size=").append(this.frag_size).append(')'));
                }
                this.fragment(msg);
                return null;
            }
            case 6: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 56: {
                Object ret = this.down_prot.down(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("received CONFIG event: " + evt.getArg());
                }
                this.handleConfigEvent((Map)evt.getArg());
                return ret;
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                FragHeader hdr = (FragHeader)msg.getHeader(name);
                if (hdr != null) {
                    this.unfragment(msg, hdr);
                    return null;
                }
                this.num_received_msgs.incrementAndGet();
                break;
            }
            case 6: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 56: {
                Object ret = this.up_prot.up(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("received CONFIG event: " + evt.getArg());
                }
                this.handleConfigEvent((Map)evt.getArg());
                return ret;
            }
        }
        return this.up_prot.up(evt);
    }

    private void handleViewChange(View view) {
        Vector<Address> new_mbrs = view.getMembers();
        Vector<Address> left_mbrs = Util.determineLeftMembers(this.members, new_mbrs);
        this.members.clear();
        this.members.addAll(new_mbrs);
        for (Address mbr : left_mbrs) {
            this.fragment_list.remove(mbr);
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace("[VIEW_CHANGE] removed " + mbr + " from fragmentation table");
        }
    }

    @ManagedOperation(description="removes all fragments sent by mbr")
    public void clearFragmentsFor(Address mbr) {
        if (mbr == null) {
            return;
        }
        this.fragment_list.remove(mbr);
        if (this.log.isTraceEnabled()) {
            this.log.trace("removed " + mbr + " from fragmentation table");
        }
    }

    @ManagedOperation(description="Removes all entries from the fragmentation table. Dangerous: this might remove fragments that are still needed to assemble an entire message")
    public void clearAllFragments() {
        this.fragment_list.clear();
    }

    private void fragment(Message msg) {
        block4: {
            try {
                byte[] buffer = msg.getRawBuffer();
                List<Range> fragments = Util.computeFragOffsets(msg.getOffset(), msg.getLength(), this.frag_size);
                int num_frags = fragments.size();
                this.num_sent_frags.addAndGet(num_frags);
                if (this.log.isTraceEnabled()) {
                    Address dest = msg.getDest();
                    StringBuilder sb = new StringBuilder("fragmenting packet to ");
                    sb.append(dest != null ? dest.toString() : "<all members>").append(" (size=").append(buffer.length);
                    sb.append(") into ").append(num_frags).append(" fragment(s) [frag_size=").append(this.frag_size).append(']');
                    this.log.trace(sb.toString());
                }
                long id = this.getNextId();
                for (int i = 0; i < fragments.size(); ++i) {
                    Range r = fragments.get(i);
                    Message frag_msg = msg.copy(false);
                    frag_msg.setBuffer(buffer, (int)r.low, (int)r.high);
                    FragHeader hdr = new FragHeader(id, i, num_frags);
                    frag_msg.putHeader(name, hdr);
                    this.down_prot.down(new Event(1, frag_msg));
                }
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block4;
                this.log.error("fragmentation failure", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unfragment(Message msg, FragHeader hdr) {
        block12: {
            ConcurrentMap tmp;
            Address sender = msg.getSrc();
            Message assembled_msg = null;
            ConcurrentMap<Long, FragEntry> frag_table = (ConcurrentHashMap)this.fragment_list.get(sender);
            if (frag_table == null && (tmp = (ConcurrentMap)this.fragment_list.putIfAbsent(sender, frag_table = new ConcurrentHashMap())) != null) {
                frag_table = tmp;
            }
            this.num_received_frags.incrementAndGet();
            FragEntry entry = (FragEntry)frag_table.get(hdr.id);
            if (entry == null) {
                entry = new FragEntry(hdr.num_frags);
                FragEntry tmp2 = frag_table.putIfAbsent(hdr.id, entry);
                if (tmp2 != null) {
                    entry = tmp2;
                }
            }
            entry.lock();
            try {
                entry.set(hdr.frag_id, msg);
                if (entry.isComplete()) {
                    assembled_msg = entry.assembleMessage();
                    frag_table.remove(hdr.id);
                }
            }
            finally {
                entry.unlock();
            }
            if (assembled_msg != null) {
                try {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("assembled_msg is " + assembled_msg);
                    }
                    assembled_msg.setSrc(sender);
                    this.num_received_msgs.incrementAndGet();
                    this.up_prot.up(new Event(1, assembled_msg));
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block12;
                    this.log.error("unfragmentation failed", e);
                }
            }
        }
    }

    void handleConfigEvent(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("frag_size")) {
            this.frag_size = (Integer)map.get("frag_size");
            if (this.log.isDebugEnabled()) {
                this.log.debug("setting frag_size=" + this.frag_size);
            }
        }
    }

    private static class FragEntry {
        final Message[] fragments;
        int number_of_frags_recvd = 0;
        private final Lock lock = new ReentrantLock();

        private FragEntry(int tot_frags) {
            this.fragments = new Message[tot_frags];
            for (int i = 0; i < tot_frags; ++i) {
                this.fragments[i] = null;
            }
        }

        public void lock() {
            this.lock.lock();
        }

        public void unlock() {
            this.lock.unlock();
        }

        public void set(int frag_id, Message frag) {
            if (this.fragments[frag_id] == null) {
                this.fragments[frag_id] = frag;
                ++this.number_of_frags_recvd;
            }
        }

        public boolean isComplete() {
            if (this.number_of_frags_recvd < this.fragments.length) {
                return false;
            }
            for (int i = 0; i < this.fragments.length; ++i) {
                if (this.fragments[i] != null) continue;
                return false;
            }
            return true;
        }

        private Message assembleMessage() {
            int combined_length = 0;
            int index = 0;
            for (Message fragment : this.fragments) {
                combined_length += fragment.getLength();
            }
            byte[] combined_buffer = new byte[combined_length];
            Message retval = this.fragments[0].copy(false);
            for (int i = 0; i < this.fragments.length; ++i) {
                Message fragment = this.fragments[i];
                this.fragments[i] = null;
                byte[] tmp = fragment.getRawBuffer();
                int length = fragment.getLength();
                int offset = fragment.getOffset();
                System.arraycopy(tmp, offset, combined_buffer, index, length);
                index += length;
            }
            retval.setBuffer(combined_buffer);
            return retval;
        }

        public String toString() {
            StringBuilder ret = new StringBuilder();
            ret.append("[tot_frags=").append(this.fragments.length).append(", number_of_frags_recvd=").append(this.number_of_frags_recvd).append(']');
            return ret.toString();
        }
    }
}

