/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.PingData;
import org.jgroups.stack.Protocol;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean(description="Protocol to discover subgroups existing due to a network partition")
@DeprecatedProperty(names={"use_separate_thread"})
public class MERGE2
extends Protocol {
    @ManagedAttribute(description="Minimum time between runs to discover other clusters", writable=true)
    @Property(description="Lower bound in msec to run merge protocol. Default is 5000 msec")
    private long min_interval = 5000L;
    @ManagedAttribute(description="Maximum time between runs to discover other clusters", writable=true)
    @Property(description="Upper bound in msec to run merge protocol. Default is 20000 msec")
    private long max_interval = 20000L;
    private Address local_addr = null;
    private View view;
    private final FindSubgroupsTask task = new FindSubgroupsTask();
    private volatile boolean is_coord = false;
    private TimeScheduler timer;

    @Override
    public void init() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer cannot be retrieved");
        }
        if (this.min_interval <= 0L || this.max_interval <= 0L) {
            throw new Exception("min_interval and max_interval have to be > 0");
        }
        if (this.max_interval <= this.min_interval) {
            throw new Exception("max_interval has to be greater than min_interval");
        }
    }

    @Override
    public String getName() {
        return "MERGE2";
    }

    public long getMinInterval() {
        return this.min_interval;
    }

    public void setMinInterval(long i) {
        this.min_interval = i;
    }

    public long getMaxInterval() {
        return this.max_interval;
    }

    public void setMaxInterval(long l) {
        this.max_interval = l;
    }

    @Override
    public Vector<Integer> requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>(1);
        retval.addElement(new Integer(12));
        return retval;
    }

    @ManagedOperation
    public void sendMergeSolicitation() {
        this.task.findAndNotify();
    }

    @Override
    public void stop() {
        this.is_coord = false;
        this.task.stop();
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                Object ret = this.down_prot.down(evt);
                this.view = (View)evt.getArg();
                Vector<Address> mbrs = this.view.getMembers();
                if (mbrs == null || mbrs.isEmpty() || this.local_addr == null) {
                    this.task.stop();
                    return ret;
                }
                Address coord = mbrs.elementAt(0);
                if (coord.equals(this.local_addr)) {
                    this.is_coord = true;
                    this.task.start();
                } else {
                    if (this.is_coord) {
                        this.is_coord = false;
                    }
                    this.task.stop();
                }
                return ret;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                return this.down_prot.down(evt);
            }
        }
        return this.down_prot.down(evt);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindSubgroupsTask {
        private Future<?> future;

        private FindSubgroupsTask() {
        }

        public synchronized void start() {
            if (this.future == null || this.future.isDone()) {
                this.future = MERGE2.this.timer.scheduleWithFixedDelay(new Runnable(){

                    public void run() {
                        FindSubgroupsTask.this.findAndNotify();
                    }
                }, 2500L, this.computeInterval(), TimeUnit.MILLISECONDS);
            }
        }

        public synchronized void stop() {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }

        public void findAndNotify() {
            List<PingData> initial_mbrs = this.findInitialMembers();
            List<View> different_views = this.detectDifferentViews(initial_mbrs);
            if (different_views.size() > 1) {
                if (MERGE2.this.log.isDebugEnabled()) {
                    MERGE2.this.log.debug(MERGE2.this.local_addr + " found different views : " + Util.print(different_views) + "; sending up MERGE event");
                }
                Event evt = new Event(14, different_views);
                try {
                    MERGE2.this.up_prot.up(evt);
                }
                catch (Throwable t) {
                    MERGE2.this.log.error("failed sending up MERGE event", t);
                }
            }
        }

        long computeInterval() {
            return MERGE2.this.min_interval + Util.random(MERGE2.this.max_interval - MERGE2.this.min_interval);
        }

        List<PingData> findInitialMembers() {
            PingData tmp = new PingData(MERGE2.this.local_addr, MERGE2.this.view, true);
            List retval = (List)MERGE2.this.down_prot.down(new Event(12));
            if (retval == null) {
                return Collections.emptyList();
            }
            if (MERGE2.this.is_coord && MERGE2.this.local_addr != null) {
                if (retval.contains(tmp)) {
                    retval.remove(tmp);
                }
                retval.add(tmp);
            }
            return retval;
        }

        List<Address> detectMultipleCoordinators(List<PingData> initial_mbrs) {
            Vector<Address> ret = new Vector<Address>();
            for (PingData response : initial_mbrs) {
                Address coord;
                if (!response.isServer() || ret.contains(coord = response.getCoordAddress())) continue;
                ret.add(coord);
            }
            return ret;
        }

        List<View> detectDifferentViews(List<PingData> initial_mbrs) {
            ArrayList<View> ret = new ArrayList<View>();
            for (PingData response : initial_mbrs) {
                ViewId vid;
                View view;
                if (!response.isServer() || (view = response.getView()) == null || this.containsViewId(ret, vid = view.getVid())) continue;
                ret.add(view);
            }
            return ret;
        }

        boolean containsViewId(Collection<View> views, ViewId vid) {
            for (View view : views) {
                ViewId tmp = view.getVid();
                if (!Util.sameViewId(vid, tmp)) continue;
                return true;
            }
            return false;
        }
    }
}

