/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.TimeoutException;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.RouterStub;
import org.jgroups.util.Promise;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class PING
extends Discovery {
    private static final String name = "PING";
    @Property(description="Gossip host")
    private String gossip_host = null;
    @Property(description="Gossip port")
    private int gossip_port = 0;
    @Property(description="Time in msecs after which the entry in GossipRouter will be refreshed. Default is 20000 msec")
    private long gossip_refresh = 20000L;
    @Property(description="Number of ports to be probed for initial membership. Default is 1")
    private int port_range = 1;
    @Property(description="If socket is used for discovery, time in msecs to wait until socket is connected. Default is 1000 msec")
    private int socket_conn_timeout = 1000;
    @Property(description="Max to block on the socket on a read (in ms). 0 means block forever")
    private int socket_read_timeout = 3000;
    @Property(description="Time (in ms) to wait for our own discovery message to be received. 0 means don't wait. If the discovery message is not received within discovery_timeout ms, a warning will be logged")
    private long discovery_timeout = 0L;
    private List<RouterStub> clients = new ArrayList<RouterStub>();
    private List<InetSocketAddress> gossip_hosts = null;
    private List<IpAddress> initial_hosts = null;
    protected final Promise<Boolean> discovery_reception = new Promise();

    public String getName() {
        return name;
    }

    public void init() throws Exception {
        super.init();
    }

    private void initializeRouterStubs() {
        PhysicalAddress physical_addr = (PhysicalAddress)this.down_prot.down(new Event(87, this.local_addr));
        if (this.gossip_hosts != null) {
            for (InetSocketAddress host : this.gossip_hosts) {
                RouterStub rs = new RouterStub(host.getHostName(), host.getPort(), null, physical_addr);
                rs.setSocketConnectionTimeout(this.socket_conn_timeout);
                rs.setSocketReadTimeout(this.socket_read_timeout);
                this.clients.add(rs);
            }
        } else if (this.gossip_host != null && this.gossip_port != 0) {
            RouterStub rs = new RouterStub(this.gossip_host, this.gossip_port, null, physical_addr);
            rs.setSocketConnectionTimeout(this.socket_conn_timeout);
            rs.setSocketReadTimeout(this.socket_read_timeout);
            this.clients.add(rs);
        }
    }

    private boolean isUsingRouterStubs() {
        return this.gossip_hosts != null || this.gossip_host != null && this.gossip_port != 0;
    }

    public int getGossipPort() {
        return this.gossip_port;
    }

    public void setGossipPort(int gossip_port) {
        this.gossip_port = gossip_port;
    }

    public long getGossipRefresh() {
        return this.gossip_refresh;
    }

    public void setGossipRefresh(long gossip_refresh) {
        this.gossip_refresh = gossip_refresh;
    }

    public int getSocketConnTimeout() {
        return this.socket_conn_timeout;
    }

    public void setSocketConnTimeout(int socket_conn_timeout) {
        this.socket_conn_timeout = socket_conn_timeout;
    }

    public int getSocketReadTimeout() {
        return this.socket_read_timeout;
    }

    public void setSocketReadTimeout(int socket_read_timeout) {
        this.socket_read_timeout = socket_read_timeout;
    }

    public int getSockConnTimeout() {
        return this.socket_conn_timeout;
    }

    @Property
    public void setSockConnTimeout(int socket_conn_timeout) {
        this.socket_conn_timeout = socket_conn_timeout;
    }

    public int getSockReadTimeout() {
        return this.socket_read_timeout;
    }

    @Property
    public void setSockReadTimeout(int socket_read_timeout) {
        this.socket_read_timeout = socket_read_timeout;
    }

    @Property
    public void setInitialHosts(String hosts) throws UnknownHostException {
        this.initial_hosts = Util.parseCommaDelimitedHosts(hosts, this.port_range);
    }

    @Property
    public void setGossipHosts(String hosts) throws UnknownHostException {
        this.gossip_hosts = Util.parseCommaDelimetedHosts2(hosts, this.port_range);
    }

    public void stop() {
        super.stop();
        for (RouterStub stub : this.clients) {
            stub.disconnect();
        }
        this.discovery_reception.reset();
    }

    public void destroy() {
        super.destroy();
        this.clients.clear();
    }

    public void handleConnect() {
        for (RouterStub client : this.clients) {
            try {
                client.connect(this.group_addr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void handleDisconnect() {
        for (RouterStub client : this.clients) {
            try {
                client.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void sendGetMembersRequest(String cluster_name, Promise promise) throws Exception {
        boolean routerStubsInitiliazed;
        ArrayList<Address> gossip_rsps = new ArrayList<Address>();
        boolean bl = routerStubsInitiliazed = !this.clients.isEmpty();
        if (this.isUsingRouterStubs() && !routerStubsInitiliazed) {
            this.initializeRouterStubs();
        }
        if (!this.clients.isEmpty()) {
            for (RouterStub client : this.clients) {
                try {
                    gossip_rsps.addAll(client.getMembers(this.group_addr, 2500L));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (gossip_rsps.isEmpty()) {
                return;
            }
            Event view_event = new Event(15, this.makeView(new Vector<Address>(gossip_rsps)));
            this.down_prot.down(view_event);
            if (!gossip_rsps.isEmpty()) {
                for (Address dest : gossip_rsps) {
                    Message msg = new Message(dest, null, null);
                    msg.setFlag((byte)1);
                    msg.putHeader(this.getName(), new PingHeader(1, cluster_name));
                    this.down_prot.down(new Event(1, msg));
                }
            }
            Util.sleep(500L);
        } else if (this.initial_hosts != null && !this.initial_hosts.isEmpty()) {
            for (IpAddress addr : this.initial_hosts) {
                if (((Object)addr).equals(this.local_addr)) continue;
                Message msg = new Message((Address)addr, null, null);
                msg.setFlag((byte)1);
                msg.putHeader(name, new PingHeader(1, cluster_name));
                if (this.log.isTraceEnabled()) {
                    this.log.trace("[FIND_INITIAL_MBRS] sending PING request to " + msg.getDest());
                }
                this.down_prot.down(new Event(1, msg));
            }
        } else {
            PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, this.local_addr));
            List<PhysicalAddress> physical_addrs = Arrays.asList(physical_addr);
            PingData data = new PingData(this.local_addr, null, false, UUID.get(this.local_addr), physical_addrs);
            PingHeader hdr = new PingHeader(1, data, cluster_name);
            Message msg = new Message(null);
            msg.setFlag((byte)1);
            msg.putHeader(this.getName(), hdr);
            this.sendMcastDiscoveryRequest(msg);
        }
    }

    public Object up(Event evt) {
        Message msg;
        PingHeader hdr;
        if (evt.getType() == 1 && (hdr = (PingHeader)(msg = (Message)evt.getArg()).getHeader(this.getName())) != null && hdr.type == 1 && msg.getSrc().equals(this.local_addr)) {
            this.discovery_reception.setResult(true);
        }
        return super.up(evt);
    }

    void sendMcastDiscoveryRequest(Message discovery_request) {
        this.discovery_reception.reset();
        this.down_prot.down(new Event(1, discovery_request));
        this.waitForDiscoveryRequestReception();
    }

    protected void waitForDiscoveryRequestReception() {
        block3: {
            if (this.discovery_timeout > 0L) {
                try {
                    this.discovery_reception.getResultWithTimeout(this.discovery_timeout);
                }
                catch (TimeoutException e) {
                    if (!this.log.isWarnEnabled()) break block3;
                    this.log.warn("didn't receive my own discovery request - multicast socket might not be configured correctly");
                }
            }
        }
    }
}

