/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.TP;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.RouterStub;
import org.jgroups.util.Util;

public class TUNNEL
extends TP {
    @Deprecated
    @Property(name="router_host", deprecatedMessage="router_host is deprecated. Specify target GRs using gossip_router_hosts", description="Router host address")
    private String router_host = null;
    @Deprecated
    @Property(name="router_port", deprecatedMessage="router_port is deprecated. Specify target GRs using gossip_router_hosts", description="Router port")
    private int router_port = 0;
    @Property(description="Interval in msec to attempt connecting back to router in case of torn connection. Default is 5000 msec")
    private long reconnect_interval = 5000L;
    private final List<InetSocketAddress> gossip_router_hosts = new ArrayList<InetSocketAddress>();
    private final List<RouterStub> stubs = new ArrayList<RouterStub>();
    private TUNNELPolicy tunnel_policy = new DefaultTUNNELPolicy();
    private DatagramSocket sock;
    private final Map<InetSocketAddress, Future<?>> reconnectFutures = new HashMap();
    private final Lock reconnectorLock = new ReentrantLock();

    @Property
    public void setGossipRouterHosts(String hosts) throws UnknownHostException {
        this.gossip_router_hosts.clear();
        if (hosts.startsWith("[") && hosts.endsWith("]")) {
            hosts = hosts.substring(1, hosts.length() - 1);
        }
        this.gossip_router_hosts.addAll(Util.parseCommaDelimetedHosts2(hosts, 1));
    }

    public String toString() {
        return "TUNNEL";
    }

    @Deprecated
    public String getRouterHost() {
        return this.router_host;
    }

    @Deprecated
    public void setRouterHost(String router_host) {
        this.router_host = router_host;
    }

    @Deprecated
    public int getRouterPort() {
        return this.router_port;
    }

    @Deprecated
    public void setRouterPort(int router_port) {
        this.router_port = router_port;
    }

    public long getReconnectInterval() {
        return this.reconnect_interval;
    }

    public void setReconnectInterval(long reconnect_interval) {
        this.reconnect_interval = reconnect_interval;
    }

    public String getName() {
        return "TUNNEL";
    }

    public synchronized void setTUNNELPolicy(TUNNELPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Tunnel policy has to be non null");
        }
        this.tunnel_policy = policy;
    }

    public void init() throws Exception {
        super.init();
        if (this.timer == null) {
            throw new Exception("TUNNEL.init(): timer cannot be retrieved from protocol stack");
        }
        if ((this.router_host == null || this.router_port == 0) && this.gossip_router_hosts.isEmpty()) {
            throw new Exception("Either router_host and router_port have to be set or a list of gossip routers");
        }
        if (this.router_host != null && this.router_port != 0 && !this.gossip_router_hosts.isEmpty()) {
            throw new Exception("Cannot specify both router host and port along with gossip_router_hosts");
        }
        if (this.router_host != null && this.router_port != 0 && this.gossip_router_hosts.isEmpty()) {
            this.gossip_router_hosts.add(new InetSocketAddress(this.router_host, this.router_port));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Target GRs are:" + this.gossip_router_hosts.toString());
        }
    }

    public void start() throws Exception {
        this.loopback = true;
        this.sock = new DatagramSocket(0, this.bind_addr);
        super.start();
        for (InetSocketAddress gr : this.gossip_router_hosts) {
            RouterStub stub = new RouterStub(gr.getHostName(), gr.getPort(), this.bind_addr, this.getPhysicalAddress());
            stub.setConnectionListener(new StubConnectionListener(stub));
            this.stubs.add(stub);
        }
    }

    public void stop() {
        this.teardownTunnel();
        super.stop();
    }

    void teardownTunnel() {
        for (RouterStub stub : this.stubs) {
            this.stopReconnecting(stub);
            stub.disconnect();
        }
    }

    public Object handleDownEvent(Event evt) {
        Object retEvent = super.handleDownEvent(evt);
        switch (evt.getType()) {
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.tunnel_policy.connect(this.stubs);
                break;
            }
            case 4: {
                this.teardownTunnel();
            }
        }
        return retEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReconnecting(final RouterStub stub) {
        this.reconnectorLock.lock();
        try {
            Future<?> reconnectorFuture = this.reconnectFutures.get(stub.getGossipRouterAddress());
            if (reconnectorFuture == null || reconnectorFuture.isDone()) {
                Runnable reconnector = new Runnable(){

                    public void run() {
                        block6: {
                            try {
                                if (!stub.isIntentionallyDisconnected()) {
                                    if (TUNNEL.this.log.isDebugEnabled()) {
                                        TUNNEL.this.log.debug("Reconnecting to router at " + stub.getGossipRouterAddress());
                                    }
                                    stub.connect(TUNNEL.this.channel_name);
                                }
                            }
                            catch (Exception ex) {
                                if (!TUNNEL.this.log.isWarnEnabled()) break block6;
                                try {
                                    TUNNEL.this.log.warn("failed reconnecting " + stub.getLocalAddress() + " to GR at " + stub.getGossipRouterAddress(), ex);
                                }
                                catch (SocketException socketException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                };
                reconnectorFuture = this.timer.scheduleWithFixedDelay(reconnector, 0L, this.reconnect_interval, TimeUnit.MILLISECONDS);
                this.reconnectFutures.put(stub.getGossipRouterAddress(), reconnectorFuture);
            }
        }
        finally {
            this.reconnectorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReconnecting(RouterStub stub) {
        this.reconnectorLock.lock();
        InetSocketAddress address = stub.getGossipRouterAddress();
        try {
            Future<?> reconnectorFuture = this.reconnectFutures.get(address);
            if (reconnectorFuture != null) {
                reconnectorFuture.cancel(true);
                this.reconnectFutures.remove(address);
            }
        }
        finally {
            this.reconnectorLock.unlock();
        }
    }

    public void sendMulticast(byte[] data, int offset, int length) throws Exception {
        this.tunnel_policy.sendToAllMembers(new ArrayList<RouterStub>(this.stubs), data, offset, length);
    }

    public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
        this.tunnel_policy.sendToSingleMember(new ArrayList<RouterStub>(this.stubs), dest, data, offset, length);
    }

    public String getInfo() {
        if (this.stubs.isEmpty()) {
            return this.stubs.toString();
        }
        return "RouterStubs not yet initialized";
    }

    protected PhysicalAddress getPhysicalAddress() {
        return this.sock != null ? new IpAddress(this.bind_addr, this.sock.getLocalPort()) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultTUNNELPolicy
    implements TUNNELPolicy {
        private DefaultTUNNELPolicy() {
        }

        @Override
        public void sendToAllMembers(List<RouterStub> stubs, byte[] data, int offset, int length) throws Exception {
            boolean sent = false;
            Collections.shuffle(stubs);
            for (RouterStub stub : stubs) {
                try {
                    stub.sendToAllMembers(data, offset, length);
                    if (TUNNEL.this.log.isDebugEnabled()) {
                        TUNNEL.this.log.debug(stub.getLocalAddress() + " sent a message to all members, GR used " + stub.getGossipRouterAddress());
                    }
                    sent = true;
                    break;
                }
                catch (Exception e) {
                    try {
                        if (!TUNNEL.this.log.isWarnEnabled()) continue;
                        TUNNEL.this.log.warn(stub.getLocalAddress() + " failed sending a message to all members, GR used " + stub.getGossipRouterAddress());
                    }
                    catch (SocketException e1) {}
                }
            }
            if (!sent) {
                throw new Exception("None of the available stubs " + stubs + " accepted a multicast message");
            }
        }

        @Override
        public void sendToSingleMember(List<RouterStub> stubs, Address dest, byte[] data, int offset, int length) throws Exception {
            boolean sent = false;
            Collections.shuffle(stubs);
            for (RouterStub stub : stubs) {
                try {
                    stub.sendToSingleMember(dest, data, offset, length);
                    if (TUNNEL.this.log.isDebugEnabled()) {
                        TUNNEL.this.log.debug(stub.getLocalAddress() + " sent a message to " + dest + ", GR used " + stub.getGossipRouterAddress());
                    }
                    sent = true;
                    break;
                }
                catch (Exception e) {
                    try {
                        if (!TUNNEL.this.log.isWarnEnabled()) continue;
                        TUNNEL.this.log.warn(stub.getLocalAddress() + " failed sending a message to " + dest + ", GR used " + stub.getGossipRouterAddress());
                    }
                    catch (SocketException e1) {}
                }
            }
            if (!sent) {
                throw new Exception("None of the available stubs " + stubs + " accepted a message for dest " + dest);
            }
        }

        @Override
        public void connect(List<RouterStub> stubs) {
            for (RouterStub stub : stubs) {
                try {
                    stub.connect(TUNNEL.this.channel_name);
                }
                catch (Exception e) {
                    if (TUNNEL.this.log.isWarnEnabled()) {
                        TUNNEL.this.log.warn("Failed connecting to GossipRouter at " + stub.getGossipRouterAddress());
                    }
                    TUNNEL.this.startReconnecting(stub);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TUNNELPolicy {
        public void connect(List<RouterStub> var1);

        public void sendToAllMembers(List<RouterStub> var1, byte[] var2, int var3, int var4) throws Exception;

        public void sendToSingleMember(List<RouterStub> var1, Address var2, byte[] var3, int var4, int var5) throws Exception;
    }

    private class StubReceiver
    implements Runnable {
        private final RouterStub stub;

        public StubReceiver(RouterStub stub) {
            this.stub = stub;
        }

        public void run() {
            while (this.stub.isConnected()) {
                byte[] data = null;
                DataInputStream input = null;
                try {
                    input = this.stub.getInputStream();
                    byte dataType = input.readByte();
                    switch (dataType) {
                        case 10: {
                            Address dest = Util.readAddress(input);
                            int len = input.readInt();
                            if (len <= 0) break;
                            data = new byte[len];
                            input.readFully(data, 0, len);
                            TUNNEL.this.receive(null, data, 0, len);
                            break;
                        }
                        case 11: {
                            final Address suspect = Util.readAddress(input);
                            Thread thread = TUNNEL.this.getThreadFactory().newThread(new Runnable(){

                                public void run() {
                                    StubReceiver.this.fireSuspectEvent(suspect);
                                }
                            }, "StubReceiver-suspect");
                            thread.start();
                        }
                    }
                }
                catch (SocketTimeoutException ste) {
                }
                catch (SocketException se) {
                }
                catch (IOException ioe) {
                }
                catch (Exception e) {
                    if (!TUNNEL.this.log.isWarnEnabled()) break;
                    TUNNEL.this.log.warn("failure in TUNNEL receiver thread", e);
                    break;
                }
            }
        }

        private void fireSuspectEvent(Address suspect) {
            Map contents = TUNNEL.this.logical_addr_cache.contents();
            if (TUNNEL.this.log.isDebugEnabled()) {
                TUNNEL.this.log.debug("At address " + TUNNEL.this.getPhysicalAddress() + " finding logical address for suspect " + suspect + ", addresses are: \n" + TUNNEL.this.logical_addr_cache);
            }
            for (Map.Entry entry : contents.entrySet()) {
                if (!suspect.equals(entry.getValue())) continue;
                if (TUNNEL.this.log.isDebugEnabled()) {
                    TUNNEL.this.log.debug("Raising suspect for " + entry.getKey());
                }
                TUNNEL.this.up(new Event(9, entry.getKey()));
            }
        }
    }

    private class StubConnectionListener
    implements RouterStub.ConnectionListener {
        private volatile int currentState = 1;
        private final RouterStub stub;

        public StubConnectionListener(RouterStub stub) {
            this.stub = stub;
        }

        public void connectionStatusChange(int newState) {
            if (newState == 1) {
                TUNNEL.this.startReconnecting(this.stub);
            } else if (this.currentState != 0 && newState == 0) {
                TUNNEL.this.stopReconnecting(this.stub);
                Thread t = TUNNEL.this.global_thread_factory.newThread(new StubReceiver(this.stub), "TUNNEL receiver");
                t.setDaemon(true);
                t.start();
            }
            this.currentState = newState;
        }
    }
}

