/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Membership;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.protocols.pbcast.MergeData;
import org.jgroups.util.Digest;
import org.jgroups.util.MergeId;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.ResponseCollector;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordGmsImpl
extends GmsImpl {
    private final MergeTask merge_task = new MergeTask();
    private final ResponseCollector<MergeData> merge_rsps = new ResponseCollector();
    private final ResponseCollector<Digest> digest_collector = new ResponseCollector();
    private final Lock merge_lock = new ReentrantLock();
    private MergeId merge_id = null;
    private Future<?> merge_canceller_future = null;
    private final Lock merge_canceller_lock = new ReentrantLock();
    private final Long MAX_SUSPEND_TIMEOUT = new Long(30000L);

    public CoordGmsImpl(GMS g) {
        super(g);
    }

    private void cancelMerge(MergeId id) {
        if (this.setMergeId(id, null)) {
            this.merge_task.stop();
            this.merge_rsps.reset();
            this.gms.getViewHandler().resume(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setMergeId(MergeId expected, MergeId new_value) {
        this.merge_lock.lock();
        try {
            boolean match = Util.match(this.merge_id, expected);
            if (match) {
                this.merge_id = new_value;
                this.stopMergeCanceller();
                if (this.merge_id != null) {
                    this.startMergeCanceller();
                }
            }
            boolean bl = match;
            return bl;
        }
        finally {
            this.merge_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MergeId getMergeId() {
        this.merge_lock.lock();
        try {
            MergeId mergeId = this.merge_id;
            return mergeId;
        }
        finally {
            this.merge_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMergeInProgress() {
        this.merge_lock.lock();
        try {
            boolean bl = this.merge_id != null;
            return bl;
        }
        finally {
            this.merge_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchMergeId(MergeId id) {
        this.merge_lock.lock();
        try {
            boolean bl = Util.match(this.merge_id, id);
            return bl;
        }
        finally {
            this.merge_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMergeCanceller() {
        this.merge_canceller_lock.lock();
        try {
            if (this.merge_canceller_future == null || this.merge_canceller_future.isDone()) {
                MergeCanceller task = new MergeCanceller(this.merge_id);
                this.merge_canceller_future = this.gms.timer.schedule(task, (long)((double)this.gms.merge_timeout * 1.5), TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.merge_canceller_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMergeCanceller() {
        this.merge_canceller_lock.lock();
        try {
            if (this.merge_canceller_future != null) {
                this.merge_canceller_future.cancel(true);
                this.merge_canceller_future = null;
            }
        }
        finally {
            this.merge_canceller_lock.unlock();
        }
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.cancelMerge(null);
    }

    @Override
    public void join(Address mbr, boolean useFlushIfPresent) {
        this.wrongMethod("join");
    }

    @Override
    public void joinWithStateTransfer(Address mbr, boolean useFlushIfPresent) {
        this.wrongMethod("join");
    }

    @Override
    public void leave(Address mbr) {
        if (mbr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("member's address is null !");
            }
            return;
        }
        if (mbr.equals(this.gms.local_addr)) {
            this.leaving = true;
        }
        this.gms.getViewHandler().add(new GmsImpl.Request(2, mbr, false));
        this.gms.getViewHandler().stop(true);
        this.gms.getViewHandler().waitUntilCompleted(this.gms.leave_timeout);
    }

    @Override
    public void suspect(Address mbr) {
        if (mbr.equals(this.gms.local_addr)) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("I am the coord and I'm suspected -- will probably leave shortly");
            }
            return;
        }
        LinkedHashSet<GmsImpl.Request> suspected = new LinkedHashSet<GmsImpl.Request>(1);
        suspected.add(new GmsImpl.Request(3, mbr, true));
        this.handleMembershipChange(suspected);
    }

    @Override
    public void merge(List<View> views) {
        if (this.isMergeInProgress()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.gms.local_addr + ": merge is already running (merge_id=" + this.merge_id + ")");
            }
            return;
        }
        Collection<Address> coords = CoordGmsImpl.determineCoords(views);
        Membership tmp = new Membership(coords);
        tmp.sort();
        Address merge_leader = tmp.elementAt(0);
        if (this.log.isDebugEnabled()) {
            this.log.debug("determining merge leader from coordinators " + tmp);
        }
        if (merge_leader.equals(this.gms.local_addr)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("I (" + this.gms.local_addr + ") will be the leader. Starting the merge task for " + coords);
            }
            this.merge_task.start(views);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("I (" + this.gms.local_addr + ") am not the merge leader, " + "waiting for merge leader (" + merge_leader + ") to initiate merge");
        }
    }

    @Override
    public void handleMergeRequest(Address sender, MergeId merge_id, Collection<? extends Address> mbrs) {
        View view;
        boolean bl;
        boolean success;
        boolean bl2 = success = this.matchMergeId(merge_id) || this.setMergeId(null, merge_id);
        if (!success) {
            if (this.log.isErrorEnabled()) {
                this.log.error(this.gms.local_addr + ": merge is already in progress");
            }
            this.sendMergeRejectedResponse(sender, merge_id);
            return;
        }
        this.gms.getViewHandler().suspend(merge_id);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.gms.local_addr + ": got merge request from " + sender + ", merge_id=" + merge_id + ", mbrs=" + mbrs);
        }
        LinkedList<Address> members = new LinkedList<Address>(this.gms.members.getMembers());
        if (mbrs != null) {
            for (Address address : mbrs) {
                if (members.contains(address)) continue;
                members.add(address);
            }
        }
        if (!(bl = this.gms.startFlush(view = new View(this.gms.view_id.copy(), new Vector<Address>(members))))) {
            this.sendMergeRejectedResponse(sender, merge_id);
            if (this.log.isWarnEnabled()) {
                this.log.warn(this.gms.local_addr + ": flush failed; sending merge rejected message to " + sender + ", merge_id=" + merge_id);
            }
            this.cancelMerge(merge_id);
            return;
        }
        Digest digest = this.fetchDigestsFromAllMembersInSubPartition(members);
        this.sendMergeResponse(sender, view, digest, merge_id);
    }

    @Override
    public void handleMergeResponse(MergeData data, MergeId merge_id) {
        if (!this.matchMergeId(merge_id)) {
            if (this.log.isErrorEnabled()) {
                this.log.error(this.gms.local_addr + ": this.merge_id (" + this.merge_id + ") is different from merge_id (" + merge_id + ')');
            }
            return;
        }
        this.merge_rsps.add(data.getSender(), data);
    }

    @Override
    public void handleDigestResponse(Address sender, Digest digest) {
        this.digest_collector.add(sender, digest);
    }

    @Override
    public void handleMergeView(MergeData data, MergeId merge_id) {
        if (!this.matchMergeId(merge_id)) {
            if (this.log.isErrorEnabled()) {
                this.log.error("merge_ids don't match (or are null); merge view discarded");
            }
            return;
        }
        Vector<Address> newViewMembers = new Vector<Address>(data.view.getMembers());
        newViewMembers.removeAll(this.gms.members.getMembers());
        this.gms.castViewChangeWithDest(data.view, data.digest, null, newViewMembers);
        if (this.gms.flushProtocolInStack) {
            Message ack = new Message(data.getSender(), null, null);
            ack.setFlag((byte)1);
            GMS.GmsHeader ack_hdr = new GMS.GmsHeader(12);
            ack.putHeader(this.gms.getName(), ack_hdr);
            this.gms.getDownProtocol().down(new Event(1, ack));
        }
        this.cancelMerge(merge_id);
    }

    @Override
    public void handleMergeCancelled(MergeId merge_id) {
        this.gms.stopFlush();
        if (this.matchMergeId(merge_id)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.gms.local_addr + ": merge " + merge_id + " is cancelled");
            }
            this.cancelMerge(merge_id);
        }
    }

    private Digest fetchDigestsFromAllMembersInSubPartition(List<Address> current_mbrs) {
        if (current_mbrs == null) {
            return null;
        }
        GMS.GmsHeader hdr = new GMS.GmsHeader(13);
        Message get_digest_req = new Message();
        get_digest_req.setFlag((byte)1);
        get_digest_req.putHeader(this.gms.getName(), hdr);
        long max_wait_time = this.gms.merge_timeout > 0L ? (long)((double)this.gms.merge_timeout * 0.8) : 2000L;
        this.digest_collector.reset(current_mbrs);
        this.gms.getDownProtocol().down(new Event(1, get_digest_req));
        this.digest_collector.waitForAllResponses(max_wait_time);
        HashMap<Address, Digest> responses = new HashMap<Address, Digest>(this.digest_collector.getResults());
        MutableDigest retval = new MutableDigest(responses.size());
        for (Digest digest : responses.values()) {
            if (digest == null) continue;
            retval.add(digest);
        }
        return retval;
    }

    void fixDigests() {
        Digest digest = this.fetchDigestsFromAllMembersInSubPartition(this.gms.view.getMembers());
        Message msg = new Message();
        GMS.GmsHeader hdr = new GMS.GmsHeader(15);
        hdr.my_digest = digest;
        msg.putHeader(this.gms.getName(), hdr);
        this.gms.getDownProtocol().down(new Event(1, msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMembershipChange(Collection<GmsImpl.Request> requests) {
        boolean joinAndStateTransferInitiated = false;
        boolean useFlushIfPresent = this.gms.use_flush_if_present;
        LinkedHashSet<Address> new_mbrs = new LinkedHashSet<Address>(requests.size());
        LinkedHashSet<Address> suspected_mbrs = new LinkedHashSet<Address>(requests.size());
        LinkedHashSet<Address> leaving_mbrs = new LinkedHashSet<Address>(requests.size());
        for (GmsImpl.Request req : requests) {
            switch (req.type) {
                case 1: {
                    new_mbrs.add(req.mbr);
                    useFlushIfPresent = req.useFlushIfPresent;
                    break;
                }
                case 6: {
                    new_mbrs.add(req.mbr);
                    joinAndStateTransferInitiated = true;
                    useFlushIfPresent = req.useFlushIfPresent;
                    break;
                }
                case 2: {
                    if (req.suspected) {
                        suspected_mbrs.add(req.mbr);
                        break;
                    }
                    leaving_mbrs.add(req.mbr);
                    break;
                }
                case 3: {
                    suspected_mbrs.add(req.mbr);
                }
            }
        }
        new_mbrs.remove(this.gms.local_addr);
        if (this.gms.view_id == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("gms.view_id is null, I'm not the coordinator anymore (leaving=" + this.leaving + "); the new coordinator will handle the leave request");
            }
            return;
        }
        Vector<Address> current_members = this.gms.members.getMembers();
        leaving_mbrs.retainAll(current_members);
        if (suspected_mbrs.remove(this.gms.local_addr) && this.log.isWarnEnabled()) {
            this.log.warn("I am the coord and I'm being suspected -- will probably leave shortly");
        }
        suspected_mbrs.retainAll(current_members);
        Iterator it = new_mbrs.iterator();
        while (it.hasNext()) {
            Address mbr = (Address)it.next();
            if (!this.gms.members.contains(mbr)) continue;
            if (this.log.isWarnEnabled()) {
                this.log.warn(mbr + " already present; returning existing view " + this.gms.view);
            }
            JoinRsp join_rsp = new JoinRsp(new View(this.gms.view_id, this.gms.members.getMembers()), this.gms.getDigest());
            this.gms.sendJoinResponse(join_rsp, mbr);
            it.remove();
        }
        if (new_mbrs.isEmpty() && leaving_mbrs.isEmpty() && suspected_mbrs.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("found no members to add or remove, will not create new view");
            }
            return;
        }
        View new_view = this.gms.getNextView(new_mbrs, leaving_mbrs, suspected_mbrs);
        if (new_view.size() == 0 && this.gms.local_addr != null && this.gms.local_addr.equals(new_view.getCreator())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("view " + new_view + " is empty: will not multicast it (last view)");
            }
            if (this.leaving) {
                this.gms.initState();
            }
            return;
        }
        this.gms.up(new Event(86, new_view));
        this.gms.down(new Event(86, new_view));
        if (this.log.isDebugEnabled()) {
            this.log.debug("new=" + new_mbrs + ", suspected=" + suspected_mbrs + ", leaving=" + leaving_mbrs + ", new view: " + new_view);
        }
        JoinRsp join_rsp = null;
        boolean hasJoiningMembers = !new_mbrs.isEmpty();
        try {
            boolean successfulFlush;
            boolean bl = successfulFlush = !useFlushIfPresent || this.gms.startFlush(new_view);
            if (!successfulFlush && hasJoiningMembers) {
                this.sendLeaveResponses(leaving_mbrs);
                return;
            }
            if (hasJoiningMembers) {
                this.gms.getDownProtocol().down(new Event(65, this.MAX_SUSPEND_TIMEOUT));
                Digest tmp = this.gms.getDigest();
                MutableDigest join_digest = null;
                if (tmp == null) {
                    this.log.error("received null digest from GET_DIGEST: will cause JOIN to fail");
                } else {
                    join_digest = new MutableDigest(tmp.size() + new_mbrs.size());
                    join_digest.add(tmp);
                    for (Address member : new_mbrs) {
                        join_digest.add(member, 0L, 0L);
                    }
                }
                join_rsp = new JoinRsp(new_view, join_digest != null ? join_digest.copy() : null);
            }
            this.sendLeaveResponses(leaving_mbrs);
            this.gms.castViewChangeWithDest(new_view, join_rsp != null ? join_rsp.getDigest() : null, join_rsp, new_mbrs);
        }
        finally {
            if (hasJoiningMembers) {
                this.gms.getDownProtocol().down(new Event(66));
            }
            if (!joinAndStateTransferInitiated && useFlushIfPresent) {
                this.gms.stopFlush();
            }
            if (this.leaving) {
                this.gms.initState();
            }
        }
    }

    @Override
    public void handleViewChange(View new_view, Digest digest) {
        Vector<Address> mbrs = new_view.getMembers();
        if (this.log.isDebugEnabled()) {
            if (digest != null) {
                this.log.debug("view=" + new_view + ", digest=" + digest);
            } else {
                this.log.debug("view=" + new_view);
            }
        }
        if (this.leaving && !mbrs.contains(this.gms.local_addr)) {
            return;
        }
        this.gms.installView(new_view, digest);
    }

    @Override
    public void stop() {
        super.stop();
        this.merge_task.stop();
    }

    private void sendLeaveResponses(Collection<Address> leaving_members) {
        for (Address address : leaving_members) {
            Message msg = new Message(address, null, null);
            msg.setFlag((byte)1);
            GMS.GmsHeader hdr = new GMS.GmsHeader(4);
            msg.putHeader(this.gms.getName(), hdr);
            this.gms.getDownProtocol().down(new Event(1, msg));
        }
    }

    private boolean getMergeDataFromSubgroupCoordinators(Map<Address, Collection<Address>> coords, MergeId new_merge_id, long timeout) {
        boolean gotAllResponses = false;
        long start = System.currentTimeMillis();
        this.merge_rsps.reset(coords.keySet());
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.gms.local_addr + ": sending MERGE_REQ to " + coords.keySet());
        }
        for (Map.Entry<Address, Collection<Address>> entry : coords.entrySet()) {
            Address coord = entry.getKey();
            Collection<Address> mbrs = entry.getValue();
            Message msg = new Message(coord, null, null);
            msg.setFlag((byte)1);
            GMS.GmsHeader hdr = new GMS.GmsHeader(6, mbrs);
            hdr.mbr = this.gms.local_addr;
            hdr.merge_id = new_merge_id;
            msg.putHeader(this.gms.getName(), hdr);
            this.gms.getDownProtocol().down(new Event(1, msg));
        }
        this.merge_rsps.waitForAllResponses(timeout);
        gotAllResponses = this.merge_rsps.hasAllResponses();
        long stop = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.gms.local_addr + ": collected " + this.merge_rsps.size() + " merge response(s) in " + (stop - start) + " ms");
        }
        return gotAllResponses;
    }

    private MergeData consolidateMergeData(Vector<MergeData> merge_rsps) {
        Address new_coord;
        long logical_time = 0L;
        Membership new_mbrs = new Membership();
        Vector<View> subgroups = new Vector<View>(11);
        for (MergeData tmp_data : merge_rsps) {
            View tmp_view = tmp_data.getView();
            if (tmp_view == null) continue;
            ViewId tmp_vid = tmp_view.getVid();
            if (tmp_vid != null) {
                logical_time = Math.max(logical_time, tmp_vid.getId());
            }
            new_mbrs.add(tmp_view.getMembers());
            subgroups.addElement((View)tmp_view.clone());
        }
        new_mbrs.sort();
        Address address = new_coord = new_mbrs.size() > 0 ? new_mbrs.elementAt(0) : null;
        if (new_coord == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("new_coord == null");
            }
            return null;
        }
        ViewId new_vid = new ViewId(new_coord, logical_time + 1L);
        MergeView new_view = new MergeView(new_vid, new_mbrs.getMembers(), subgroups);
        Digest new_digest = this.consolidateDigests(merge_rsps, new_mbrs.size());
        if (new_digest == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Merge leader " + this.gms.local_addr + ": could not consolidate digest for merge");
            }
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Merge leader " + this.gms.local_addr + ": consolidated view=" + new_view + "\nconsolidated digest=" + new_digest);
        }
        return new MergeData(this.gms.local_addr, new_view, new_digest);
    }

    private Digest consolidateDigests(Vector<MergeData> merge_rsps, int num_mbrs) {
        MutableDigest retval = new MutableDigest(num_mbrs);
        for (MergeData data : merge_rsps) {
            Digest tmp_digest = data.getDigest();
            if (tmp_digest == null) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error("tmp_digest == null; skipping");
                continue;
            }
            retval.merge(tmp_digest);
        }
        return retval.copy();
    }

    protected static Collection<Address> determineCoords(List<View> views) {
        HashSet<Address> retval = new HashSet<Address>();
        if (views != null) {
            for (View view : views) {
                Address coord = view.getCreator();
                if (coord == null) continue;
                retval.add(coord);
            }
        }
        return retval;
    }

    private void sendMergeView(Collection<Address> coords, MergeData combined_merge_data, MergeId merge_id) {
        if (coords == null || combined_merge_data == null) {
            return;
        }
        View view = combined_merge_data.view;
        Digest digest = combined_merge_data.digest;
        if (view == null || digest == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("view or digest is null, cannot send consolidated merge view/digest");
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.gms.local_addr + ": sending merge view " + view.getVid() + " to coordinators " + coords);
        }
        this.gms.merge_ack_collector.reset(coords);
        int size = this.gms.merge_ack_collector.size();
        long timeout = this.gms.view_ack_collection_timeout;
        long start = System.currentTimeMillis();
        for (Address coord : coords) {
            Message msg = new Message(coord, null, null);
            GMS.GmsHeader hdr = new GMS.GmsHeader(8);
            hdr.view = view;
            hdr.my_digest = digest;
            hdr.merge_id = merge_id;
            msg.putHeader(this.gms.getName(), hdr);
            this.gms.getDownProtocol().down(new Event(1, msg));
        }
        if (this.gms.flushProtocolInStack) {
            try {
                this.gms.merge_ack_collector.waitForAllAcks(timeout);
                long stop = System.currentTimeMillis();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("received all ACKs (" + size + ") for merge view " + view + " in " + (stop - start) + "ms");
                }
            }
            catch (TimeoutException e) {
                this.log.warn(this.gms.local_addr + ": failed to collect all ACKs for merge (" + size + ") for view " + view + " after " + timeout + "ms, missing ACKs from " + this.gms.merge_ack_collector.printMissing() + " (received=" + this.gms.merge_ack_collector.printReceived() + "), local_addr=" + this.gms.local_addr);
            }
        }
    }

    private void sendMergeResponse(Address sender, View view, Digest digest, MergeId merge_id) {
        Message msg = new Message(sender, null, null);
        msg.setFlag((byte)1);
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.merge_id = merge_id;
        hdr.view = view;
        hdr.my_digest = digest;
        msg.putHeader(this.gms.getName(), hdr);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.gms.local_addr + ": sending merge response=" + hdr);
        }
        this.gms.getDownProtocol().down(new Event(1, msg));
    }

    private void sendMergeCancelledMessage(Collection<Address> coords, MergeId merge_id) {
        if (coords == null || merge_id == null) {
            return;
        }
        for (Address coord : coords) {
            Message msg = new Message(coord, null, null);
            GMS.GmsHeader hdr = new GMS.GmsHeader(9);
            hdr.merge_id = merge_id;
            msg.putHeader(this.gms.getName(), hdr);
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.gms.local_addr + ": sending cancel merge to " + coord);
            }
            this.gms.getDownProtocol().down(new Event(1, msg));
        }
    }

    private void removeRejectedMergeRequests(Collection<Address> coords) {
        for (Map.Entry<Address, MergeData> entry : this.merge_rsps.getResults().entrySet()) {
            Address member = entry.getKey();
            MergeData data = entry.getValue();
            if (!data.merge_rejected) continue;
            if (data.getSender() != null) {
                coords.remove(data.getSender());
            }
            this.merge_rsps.remove(member);
        }
    }

    private class MergeCanceller
    implements Runnable {
        private final MergeId my_merge_id;

        MergeCanceller(MergeId my_merge_id) {
            this.my_merge_id = my_merge_id;
        }

        public void run() {
            CoordGmsImpl.this.cancelMerge(this.my_merge_id);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MergeTask
    implements Runnable {
        private Thread thread = null;
        private final Map<Address, Collection<Address>> coords = new ConcurrentHashMap<Address, Collection<Address>>();

        private MergeTask() {
        }

        public synchronized void start(Collection<View> views) {
            if (this.thread == null || this.thread.isAlive()) {
                this.coords.clear();
                this.determineCoordsAndMembers(views);
                this.thread = CoordGmsImpl.this.gms.getThreadFactory().newThread(this, "MergeTask");
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }

        private void determineCoordsAndMembers(Collection<View> views) {
            for (View view : views) {
                Address coord = view.getCreator();
                if (coord == null) continue;
                Collection<Address> members = this.coords.get(coord);
                if (members == null) {
                    members = new HashSet<Address>();
                    this.coords.put(coord, members);
                }
                members.addAll(view.getMembers());
            }
        }

        public synchronized void stop() {
            Thread tmp = this.thread;
            if (this.thread != null && this.thread.isAlive()) {
                tmp.interrupt();
            }
            this.thread = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MergeId new_merge_id = MergeId.create(CoordGmsImpl.this.gms.local_addr);
            ArrayList<Address> coordsCopy = null;
            try {
                boolean success = CoordGmsImpl.this.setMergeId(null, new_merge_id);
                if (!success) {
                    CoordGmsImpl.this.log.warn("failed to set my own merge_id (" + CoordGmsImpl.this.merge_id + ") to " + new_merge_id);
                    return;
                }
                coordsCopy = new ArrayList<Address>(this.coords.keySet());
                success = CoordGmsImpl.this.getMergeDataFromSubgroupCoordinators(this.coords, new_merge_id, CoordGmsImpl.this.gms.merge_timeout);
                if (!success) {
                    throw new Exception("merge leader did not get data from all partition coordinators " + this.coords.keySet());
                }
                CoordGmsImpl.this.removeRejectedMergeRequests(this.coords.keySet());
                if (CoordGmsImpl.this.merge_rsps.size() == 0) {
                    throw new Exception("did not get any merge responses from partition coordinators");
                }
                if (!this.coords.keySet().contains(CoordGmsImpl.this.gms.local_addr)) {
                    throw new Exception("merge leader rejected merge request");
                }
                Vector merge_data = new Vector(CoordGmsImpl.this.merge_rsps.getResults().values());
                MergeData combined_merge_data = CoordGmsImpl.this.consolidateMergeData(merge_data);
                if (combined_merge_data == null) {
                    throw new Exception("could not consolidate merge");
                }
                CoordGmsImpl.this.sendMergeView(this.coords.keySet(), combined_merge_data, new_merge_id);
            }
            catch (Throwable ex) {
                if (CoordGmsImpl.this.log.isWarnEnabled()) {
                    CoordGmsImpl.this.log.warn(CoordGmsImpl.this.gms.local_addr + ": " + ex.getLocalizedMessage() + ", merge is cancelled");
                }
                CoordGmsImpl.this.sendMergeCancelledMessage(coordsCopy, new_merge_id);
            }
            finally {
                CoordGmsImpl.this.gms.getViewHandler().resume(new_merge_id);
                CoordGmsImpl.this.stopMergeCanceller();
                CoordGmsImpl.this.gms.stopFlush();
                if (CoordGmsImpl.this.log.isDebugEnabled()) {
                    CoordGmsImpl.this.log.debug(CoordGmsImpl.this.gms.local_addr + ": merge leader completed merge task");
                }
                this.thread = null;
            }
        }
    }
}

