/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Digest;
import org.jgroups.util.Promise;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean(description="Flushes the cluster")
@DeprecatedProperty(names={"auto_flush_conf"})
public class FLUSH
extends Protocol {
    public static final String NAME = "FLUSH";
    @Property(description="Max time to keep channel blocked in flush. Default is 8000 msec")
    private long timeout = 8000L;
    @Property(description="Timeout (per atttempt) to quiet the cluster during the first flush phase. Default is 2500 msec")
    private long start_flush_timeout = 2000L;
    @Property(description="Retry timeout after an unsuccessful attempt to quiet the cluster (first flush phase). Default is 3000 msec")
    private long retry_timeout = 2000L;
    @Property(description="Reconcilliation phase toggle. Default is true")
    private boolean enable_reconciliation = true;
    private long startFlushTime;
    private long totalTimeInFlush;
    private int numberOfFlushes;
    private double averageFlushDuration;
    private View currentView;
    private Address localAddress;
    private Address flushCoordinator;
    private final List<Address> flushMembers;
    private final AtomicInteger viewCounter = new AtomicInteger(0);
    private final Map<Address, Digest> flushCompletedMap;
    private final List<Address> flushNotCompletedMap;
    private final Set<Address> suspected;
    private final List<Address> reconcileOks;
    private final Object sharedLock = new Object();
    private final Object blockMutex = new Object();
    private volatile boolean isBlockingFlushDown = true;
    private boolean flushCompleted = false;
    private final Promise<Boolean> flush_promise = new Promise();
    private final AtomicBoolean flushInProgress = new AtomicBoolean(false);
    private final AtomicBoolean sentBlock = new AtomicBoolean(false);
    private final AtomicBoolean sentUnblock = new AtomicBoolean(false);

    public FLUSH() {
        this.currentView = new View(new ViewId(), new Vector<Address>());
        this.flushCompletedMap = new HashMap<Address, Digest>();
        this.flushNotCompletedMap = new ArrayList<Address>();
        this.reconcileOks = new ArrayList<Address>();
        this.flushMembers = new ArrayList<Address>();
        this.suspected = new TreeSet<Address>();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public long getStartFlushTimeout() {
        return this.start_flush_timeout;
    }

    public void setStartFlushTimeout(long start_flush_timeout) {
        this.start_flush_timeout = start_flush_timeout;
    }

    public long getRetryTimeout() {
        return this.retry_timeout;
    }

    public void setRetryTimeout(long retry_timeout) {
        this.retry_timeout = retry_timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("flush_supported", Boolean.TRUE);
        this.up_prot.up(new Event(56, map));
        this.down_prot.down(new Event(56, map));
        this.viewCounter.set(0);
        Object object = this.blockMutex;
        synchronized (object) {
            this.isBlockingFlushDown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.sharedLock;
        synchronized (object) {
            this.currentView = new View(new ViewId(), new Vector<Address>());
            this.flushCompletedMap.clear();
            this.flushNotCompletedMap.clear();
            this.flushMembers.clear();
            this.suspected.clear();
            this.flushCoordinator = null;
        }
    }

    @ManagedAttribute
    public double getAverageFlushDuration() {
        return this.averageFlushDuration;
    }

    @ManagedAttribute
    public long getTotalTimeInFlush() {
        return this.totalTimeInFlush;
    }

    @ManagedAttribute
    public int getNumberOfFlushes() {
        return this.numberOfFlushes;
    }

    @ManagedOperation(description="Request cluster flush")
    public boolean startFlush() {
        return this.startFlush(new Event(68));
    }

    private boolean startFlush(Event evt) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received " + evt + " at " + this.localAddress + ". Running FLUSH...");
        }
        List flushParticipants = (List)evt.getArg();
        return this.startFlush(flushParticipants);
    }

    private boolean startFlush(List<Address> flushParticipants) {
        boolean successfulFlush;
        block3: {
            successfulFlush = false;
            if (!this.flushInProgress.get()) {
                this.flush_promise.reset();
                this.onSuspend(flushParticipants);
                try {
                    Boolean r = this.flush_promise.getResultWithTimeout(this.start_flush_timeout);
                    successfulFlush = r;
                }
                catch (TimeoutException e) {
                    if (!this.log.isDebugEnabled()) break block3;
                    this.log.debug("At " + this.localAddress + " timed out waiting for flush responses after " + this.start_flush_timeout + " msec");
                }
            }
        }
        return successfulFlush;
    }

    @ManagedOperation(description="Request end of flush in a cluster")
    public void stopFlush() {
        this.down(new Event(70));
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                if (dest == null || dest.isMulticastAddress()) {
                    FlushHeader fh = (FlushHeader)msg.getHeader(this.getName());
                    if (fh != null && fh.type == 6) {
                        return this.down_prot.down(evt);
                    }
                    this.blockMessageDuringFlush();
                    break;
                }
                return this.down_prot.down(evt);
            }
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                Object result;
                if (this.sentBlock.compareAndSet(false, true)) {
                    this.sendBlockUpToChannel();
                }
                if ((result = this.down_prot.down(evt)) instanceof Throwable) {
                    this.sentBlock.set(false);
                }
                return result;
            }
            case 68: {
                return this.startFlush(evt);
            }
            case 70: {
                this.onResume(evt);
                return null;
            }
            case 8: {
                this.localAddress = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockMessageDuringFlush() {
        boolean shouldSuspendByItself = false;
        long start = 0L;
        long stop = 0L;
        Object object = this.blockMutex;
        synchronized (object) {
            while (this.isBlockingFlushDown) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("FLUSH block at " + this.localAddress + " for " + (this.timeout <= 0L ? "ever" : this.timeout + "ms"));
                }
                try {
                    start = System.currentTimeMillis();
                    if (this.timeout <= 0L) {
                        this.blockMutex.wait();
                    } else {
                        this.blockMutex.wait(this.timeout);
                    }
                    stop = System.currentTimeMillis();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (!this.isBlockingFlushDown) continue;
                this.isBlockingFlushDown = false;
                shouldSuspendByItself = true;
                this.blockMutex.notifyAll();
            }
        }
        if (shouldSuspendByItself) {
            this.log.warn("unblocking FLUSH.down() at " + this.localAddress + " after timeout of " + (stop - start) + "ms");
            this.flush_promise.setResult(Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                final FlushHeader fh = (FlushHeader)msg.getHeader(this.getName());
                if (fh != null) {
                    switch (fh.type) {
                        case 6: {
                            return this.up_prot.up(evt);
                        }
                        case 0: {
                            boolean amIParticipant;
                            Collection<? extends Address> fp = fh.flushParticipants;
                            boolean bl = amIParticipant = fp != null && fp.contains(this.localAddress) || msg.getSrc().equals(this.localAddress);
                            if (amIParticipant) {
                                this.handleStartFlush(msg, fh);
                                break;
                            }
                            if (!this.log.isDebugEnabled()) break;
                            this.log.debug("Received START_FLUSH at " + this.localAddress + " but I am not flush participant, not responding");
                            break;
                        }
                        case 7: {
                            this.handleFlushReconcile(msg, fh);
                            break;
                        }
                        case 8: {
                            this.onFlushReconcileOK(msg);
                            break;
                        }
                        case 2: {
                            this.onStopFlush();
                            break;
                        }
                        case 5: {
                            Collection<? extends Address> flushParticipants = fh.flushParticipants;
                            if (flushParticipants == null || !flushParticipants.contains(this.localAddress)) break;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("At " + this.localAddress + " received ABORT_FLUSH from flush coordinator " + msg.getSrc() + ",  am i flush participant=" + flushParticipants.contains(this.localAddress));
                            }
                            this.flushInProgress.set(false);
                            this.flushNotCompletedMap.clear();
                            this.flushCompletedMap.clear();
                            break;
                        }
                        case 9: {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("At " + this.localAddress + " received FLUSH_NOT_COMPLETED from " + msg.getSrc());
                            }
                            boolean flushCollision = false;
                            Object object = this.sharedLock;
                            synchronized (object) {
                                this.flushNotCompletedMap.add(msg.getSrc());
                                boolean bl = flushCollision = !this.flushCompletedMap.isEmpty();
                                if (flushCollision) {
                                    this.flushNotCompletedMap.clear();
                                    this.flushCompletedMap.clear();
                                }
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("At " + this.localAddress + " received FLUSH_NOT_COMPLETED from " + msg.getSrc() + " collision=" + flushCollision);
                            }
                            if (flushCollision) {
                                Runnable r = new Runnable(){

                                    public void run() {
                                        Util.sleep(1000L);
                                        FLUSH.this.rejectFlush(fh.flushParticipants, fh.viewID);
                                    }
                                };
                                new Thread(r).start();
                            }
                            this.flush_promise.setResult(Boolean.FALSE);
                            break;
                        }
                        case 3: {
                            if (!this.isCurrentFlushMessage(fh)) break;
                            this.onFlushCompleted(msg.getSrc(), fh);
                        }
                    }
                    return null;
                }
                Address dest = msg.getDest();
                if (dest == null || dest.isMulticastAddress()) break;
                return this.up_prot.up(evt);
            }
            case 6: {
                boolean isThisOurFirstView;
                this.up_prot.up(evt);
                View newView = (View)evt.getArg();
                boolean coordinatorLeft = this.onViewChange(newView);
                boolean singletonMember = newView.size() == 1 && newView.containsMember(this.localAddress);
                boolean bl = isThisOurFirstView = this.viewCounter.addAndGet(1) == 1;
                if (isThisOurFirstView && singletonMember || coordinatorLeft) {
                    this.onStopFlush();
                }
                return null;
            }
            case 15: {
                View tmpView = (View)evt.getArg();
                if (tmpView.containsMember(this.localAddress)) break;
                this.onViewChange(tmpView);
                break;
            }
            case 9: {
                this.onSuspect((Address)evt.getArg());
                break;
            }
            case 68: {
                return this.startFlush(evt);
            }
            case 70: {
                this.onResume(evt);
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFlushReconcileOK(Message msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.localAddress + " received reconcile ok from " + msg.getSrc());
        }
        Object object = this.sharedLock;
        synchronized (object) {
            this.reconcileOks.add(msg.getSrc());
            if (this.reconcileOks.size() >= this.flushMembers.size()) {
                this.flush_promise.setResult(Boolean.TRUE);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("All FLUSH_RECONCILE_OK received at " + this.localAddress);
                }
            }
        }
    }

    private void handleFlushReconcile(Message msg, FlushHeader fh) {
        Address requester = msg.getSrc();
        Digest reconcileDigest = fh.digest;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received FLUSH_RECONCILE at " + this.localAddress + " passing digest to NAKACK " + reconcileDigest);
        }
        this.down_prot.down(new Event(78, reconcileDigest));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Returned from FLUSH_RECONCILE at " + this.localAddress + " Sending RECONCILE_OK to " + requester + ", thread " + Thread.currentThread());
        }
        Message reconcileOk = new Message(requester);
        reconcileOk.setFlag((byte)1);
        reconcileOk.putHeader(this.getName(), new FlushHeader(8));
        this.down_prot.down(new Event(1, reconcileOk));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStartFlush(Message msg, FlushHeader fh) {
        Address flushRequester = msg.getSrc();
        boolean proceed = this.flushInProgress.compareAndSet(false, true);
        if (proceed) {
            Object object = this.sharedLock;
            synchronized (object) {
                this.flushCoordinator = flushRequester;
            }
            this.onStartFlush(flushRequester, fh);
        } else {
            FlushHeader fhr = new FlushHeader(9, fh.viewID, fh.flushParticipants);
            Message response = new Message(flushRequester);
            response.putHeader(this.getName(), fhr);
            this.down_prot.down(new Event(1, response));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received START_FLUSH at " + this.localAddress + " responded with FLUSH_NOT_COMPLETED to " + flushRequester);
            }
        }
    }

    private void rejectFlush(Collection<? extends Address> participants, long viewId) {
        for (Address address : participants) {
            Message reject = new Message(address, this.localAddress, null);
            reject.putHeader(this.getName(), new FlushHeader(5, viewId, participants));
            this.down_prot.down(new Event(1, reject));
        }
    }

    @Override
    public Vector<Integer> providedDownServices() {
        Vector<Integer> retval = new Vector<Integer>(2);
        retval.addElement(new Integer(68));
        retval.addElement(new Integer(70));
        return retval;
    }

    private void sendBlockUpToChannel() {
        this.up_prot.up(new Event(10));
        this.sentUnblock.set(false);
    }

    private void sendUnBlockUpToChannel() {
        this.sentBlock.set(false);
        this.up_prot.up(new Event(75));
    }

    private boolean isCurrentFlushMessage(FlushHeader fh) {
        return fh.viewID == this.currentViewId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long currentViewId() {
        long viewId = -1L;
        Object object = this.sharedLock;
        synchronized (object) {
            ViewId view = this.currentView.getVid();
            if (view != null) {
                viewId = view.getId();
            }
        }
        return viewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onViewChange(View view) {
        boolean coordinatorLeft = false;
        Object object = this.sharedLock;
        synchronized (object) {
            this.suspected.retainAll(view.getMembers());
            View oldView = this.currentView;
            this.currentView = view;
            coordinatorLeft = !oldView.getMembers().isEmpty() && !view.getMembers().isEmpty() && !view.containsMember(oldView.getCreator());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Installing view at  " + this.localAddress + " view is " + view);
        }
        return coordinatorLeft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStopFlush() {
        if (this.stats) {
            long stopFlushTime = System.currentTimeMillis();
            this.totalTimeInFlush += stopFlushTime - this.startFlushTime;
            if (this.numberOfFlushes > 0) {
                this.averageFlushDuration = (double)this.totalTimeInFlush / (double)this.numberOfFlushes;
            }
        }
        Object object = this.sharedLock;
        synchronized (object) {
            this.flushCompletedMap.clear();
            this.flushNotCompletedMap.clear();
            this.flushMembers.clear();
            this.suspected.clear();
            this.flushCoordinator = null;
            this.flushCompleted = false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("At " + this.localAddress + " received STOP_FLUSH, unblocking FLUSH.down() and sending UNBLOCK up");
        }
        object = this.blockMutex;
        synchronized (object) {
            this.isBlockingFlushDown = false;
            this.blockMutex.notifyAll();
        }
        if (this.sentUnblock.compareAndSet(false, true)) {
            this.sendUnBlockUpToChannel();
        }
        this.flushInProgress.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSuspend(List<Address> members) {
        Message msg = null;
        List<Address> participantsInFlush = null;
        Object object = this.sharedLock;
        synchronized (object) {
            if (members != null) {
                participantsInFlush = members;
                participantsInFlush.retainAll(this.currentView.getMembers());
            } else {
                participantsInFlush = new ArrayList<Address>(this.currentView.getMembers());
            }
            msg = new Message(null, this.localAddress, null);
            msg.putHeader(this.getName(), new FlushHeader(0, this.currentViewId(), participantsInFlush));
        }
        if (participantsInFlush.isEmpty()) {
            this.flush_promise.setResult(Boolean.TRUE);
        } else {
            this.down_prot.down(new Event(1, msg));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Flush coordinator " + this.localAddress + " is starting FLUSH with participants " + participantsInFlush);
            }
        }
    }

    private void onResume(Event evt) {
        List members = (List)evt.getArg();
        long viewID = this.currentViewId();
        if (members == null || members.isEmpty()) {
            Message msg = new Message(null, this.localAddress, null);
            msg.putHeader(this.getName(), new FlushHeader(2, viewID));
            this.down_prot.down(new Event(1, msg));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received RESUME at " + this.localAddress + ", sent STOP_FLUSH to all");
            }
        } else {
            for (Address address : members) {
                Message msg = new Message(address, this.localAddress, null);
                msg.putHeader(this.getName(), new FlushHeader(2, viewID));
                this.down_prot.down(new Event(1, msg));
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Received RESUME at " + this.localAddress + ", sent STOP_FLUSH to " + address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStartFlush(Address flushStarter, FlushHeader fh) {
        if (this.stats) {
            this.startFlushTime = System.currentTimeMillis();
            ++this.numberOfFlushes;
        }
        boolean proceed = false;
        Object object = this.sharedLock;
        synchronized (object) {
            this.flushCoordinator = flushStarter;
            this.flushMembers.clear();
            if (fh.flushParticipants != null) {
                this.flushMembers.addAll(fh.flushParticipants);
            }
            proceed = this.flushMembers.contains(this.localAddress);
            this.flushMembers.removeAll(this.suspected);
        }
        if (proceed) {
            if (this.sentBlock.compareAndSet(false, true)) {
                this.sendBlockUpToChannel();
                object = this.blockMutex;
                synchronized (object) {
                    this.isBlockingFlushDown = true;
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Received START_FLUSH at " + this.localAddress + " but not sending BLOCK up");
            }
            Digest digest = (Digest)this.down_prot.down(new Event(39));
            FlushHeader fhr = new FlushHeader(3, fh.viewID, fh.flushParticipants);
            fhr.addDigest(digest);
            Message msg = new Message(flushStarter);
            msg.putHeader(this.getName(), fhr);
            this.down_prot.down(new Event(1, msg));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received START_FLUSH at " + this.localAddress + " responded with FLUSH_COMPLETED to " + flushStarter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFlushCompleted(Address address, final FlushHeader header) {
        Message msg = null;
        boolean needsReconciliationPhase = false;
        boolean collision = false;
        Digest digest = header.digest;
        Object object = this.sharedLock;
        synchronized (object) {
            this.flushCompletedMap.put(address, digest);
            this.flushCompleted = this.flushCompletedMap.size() >= this.flushMembers.size() && !this.flushMembers.isEmpty() && this.flushCompletedMap.keySet().containsAll(this.flushMembers);
            boolean bl = collision = !this.flushNotCompletedMap.isEmpty();
            if (this.log.isDebugEnabled()) {
                this.log.debug("At " + this.localAddress + " FLUSH_COMPLETED from " + address + ",completed " + this.flushCompleted + ",flushMembers " + this.flushMembers + ",flushCompleted " + this.flushCompletedMap.keySet());
            }
            boolean bl2 = needsReconciliationPhase = this.enable_reconciliation && this.flushCompleted && this.hasVirtualSynchronyGaps();
            if (needsReconciliationPhase) {
                Digest d = this.findHighestSequences();
                msg = new Message();
                msg.setFlag((byte)1);
                FlushHeader fh = new FlushHeader(7, this.currentViewId(), this.flushMembers);
                this.reconcileOks.clear();
                fh.addDigest(d);
                msg.putHeader(this.getName(), fh);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("At " + this.localAddress + " reconciling flush mebers due to virtual synchrony gap, digest is " + d + " flush members are " + this.flushMembers);
                }
                this.flushCompletedMap.clear();
            } else if (this.flushCompleted) {
                this.flushCompletedMap.clear();
            } else if (collision) {
                this.flushNotCompletedMap.clear();
                this.flushCompletedMap.clear();
            }
        }
        if (needsReconciliationPhase) {
            this.down_prot.down(new Event(1, msg));
        } else if (this.flushCompleted) {
            this.flush_promise.setResult(Boolean.TRUE);
            if (this.log.isDebugEnabled()) {
                this.log.debug("All FLUSH_COMPLETED received at " + this.localAddress);
            }
        } else if (collision) {
            Runnable r = new Runnable(){

                public void run() {
                    Util.sleep(1000L);
                    FLUSH.this.rejectFlush(header.flushParticipants, header.viewID);
                }
            };
            new Thread(r).start();
        }
    }

    private boolean hasVirtualSynchronyGaps() {
        ArrayList<Digest> digests = new ArrayList<Digest>();
        digests.addAll(this.flushCompletedMap.values());
        Digest firstDigest = (Digest)digests.get(0);
        List remainingDigests = digests.subList(1, digests.size());
        for (Digest digest : remainingDigests) {
            Digest diff = firstDigest.difference(digest);
            if (diff == Digest.EMPTY_DIGEST) continue;
            return true;
        }
        return false;
    }

    private Digest findHighestSequences() {
        Digest result = null;
        ArrayList<Digest> digests = new ArrayList<Digest>(this.flushCompletedMap.values());
        result = (Digest)digests.get(0);
        List remainingDigests = digests.subList(1, digests.size());
        for (Digest digestG : remainingDigests) {
            result = result.highestSequence(digestG);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSuspect(Address address) {
        boolean amINeighbourOfCrashedFlushCoordinator = false;
        ArrayList<Address> flushMembersCopy = null;
        Object object = this.sharedLock;
        synchronized (object) {
            boolean flushCoordinatorSuspected = address.equals(this.flushCoordinator);
            if (flushCoordinatorSuspected && this.flushMembers != null) {
                int indexOfCoordinator = this.flushMembers.indexOf(this.flushCoordinator);
                int myIndex = this.flushMembers.indexOf(this.localAddress);
                int diff = myIndex - indexOfCoordinator;
                boolean bl = amINeighbourOfCrashedFlushCoordinator = diff == 1 || myIndex == 0 && indexOfCoordinator == this.flushMembers.size();
                if (amINeighbourOfCrashedFlushCoordinator) {
                    flushMembersCopy = new ArrayList<Address>(this.flushMembers);
                }
            }
        }
        if (amINeighbourOfCrashedFlushCoordinator) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Flush coordinator " + this.flushCoordinator + " suspected, " + this.localAddress + " is neighbour, completing flush ");
            }
            this.onResume(new Event(70, flushMembersCopy));
        }
        boolean flushOkCompleted = false;
        Message m = null;
        long viewID = 0L;
        Object diff = this.sharedLock;
        synchronized (diff) {
            this.suspected.add(address);
            this.flushMembers.removeAll(this.suspected);
            viewID = this.currentViewId();
            boolean bl = flushOkCompleted = !this.flushCompletedMap.isEmpty() && this.flushCompletedMap.keySet().containsAll(this.flushMembers);
            if (flushOkCompleted) {
                m = new Message(this.flushCoordinator, this.localAddress, null);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Suspect is " + address + ",completed " + flushOkCompleted + ",  flushOkSet " + this.flushCompletedMap + " flushMembers " + this.flushMembers);
            }
        }
        if (flushOkCompleted) {
            Digest digest = (Digest)this.down_prot.down(new Event(39));
            FlushHeader fh = new FlushHeader(3, viewID);
            fh.addDigest(digest);
            m.putHeader(this.getName(), fh);
            this.down_prot.down(new Event(1, m));
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.localAddress + " sent FLUSH_COMPLETED message to " + this.flushCoordinator);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FlushHeader
    extends Header
    implements Streamable {
        public static final byte START_FLUSH = 0;
        public static final byte STOP_FLUSH = 2;
        public static final byte FLUSH_COMPLETED = 3;
        public static final byte ABORT_FLUSH = 5;
        public static final byte FLUSH_BYPASS = 6;
        public static final byte FLUSH_RECONCILE = 7;
        public static final byte FLUSH_RECONCILE_OK = 8;
        public static final byte FLUSH_NOT_COMPLETED = 9;
        byte type;
        long viewID;
        Collection<? extends Address> flushParticipants;
        Digest digest = null;
        private static final long serialVersionUID = -6248843990215637687L;

        public FlushHeader() {
            this(0, 0L);
        }

        public FlushHeader(byte type) {
            this(type, 0L);
        }

        public FlushHeader(byte type, long viewID) {
            this(type, viewID, null);
        }

        public FlushHeader(byte type, long viewID, Collection<? extends Address> flushView) {
            this.type = type;
            this.viewID = viewID;
            if (flushView != null) {
                this.flushParticipants = new ArrayList<Address>(flushView);
            }
        }

        @Override
        public int size() {
            int retval = 1;
            retval += 8;
            retval = (int)((long)retval + Util.size(this.flushParticipants));
            ++retval;
            if (this.digest != null) {
                retval = (int)((long)retval + this.digest.serializedSize());
            }
            return retval;
        }

        public void addDigest(Digest digest) {
            this.digest = digest;
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 0: {
                    return "FLUSH[type=START_FLUSH,viewId=" + this.viewID + ",members=" + this.flushParticipants + "]";
                }
                case 2: {
                    return "FLUSH[type=STOP_FLUSH,viewId=" + this.viewID + "]";
                }
                case 5: {
                    return "FLUSH[type=ABORT_FLUSH,viewId=" + this.viewID + "]";
                }
                case 3: {
                    return "FLUSH[type=FLUSH_COMPLETED,viewId=" + this.viewID + "]";
                }
                case 6: {
                    return "FLUSH[type=FLUSH_BYPASS,viewId=" + this.viewID + "]";
                }
                case 7: {
                    return "FLUSH[type=FLUSH_RECONCILE,viewId=" + this.viewID + ",digest=" + this.digest + "]";
                }
                case 8: {
                    return "FLUSH[type=FLUSH_RECONCILE_OK,viewId=" + this.viewID + "]";
                }
            }
            return "[FLUSH: unknown type (" + this.type + ")]";
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.viewID);
            out.writeObject(this.flushParticipants);
            out.writeObject(this.digest);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.viewID = in.readLong();
            this.flushParticipants = (Collection)in.readObject();
            this.digest = (Digest)in.readObject();
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.viewID);
            Util.writeAddresses(this.flushParticipants, out);
            Util.writeStreamable(this.digest, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.viewID = in.readLong();
            this.flushParticipants = Util.readAddresses(in, ArrayList.class);
            this.digest = (Digest)Util.readStreamable(Digest.class, in);
        }
    }
}

