/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.Interval;
import org.jgroups.stack.Retransmitter;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.TimeScheduler;

public class AckSenderWindow
implements Retransmitter.RetransmitCommand {
    RetransmitCommand retransmit_command = null;
    final ConcurrentMap<Long, Message> msgs = new ConcurrentHashMap<Long, Message>();
    Interval interval = new StaticInterval(400L, 800L, 1200L, 1600L);
    final Retransmitter retransmitter;
    static final Log log = LogFactory.getLog(AckSenderWindow.class);
    long lowest = 0L;

    public AckSenderWindow(RetransmitCommand com) {
        this.retransmit_command = com;
        this.retransmitter = new Retransmitter(null, this, null);
        this.retransmitter.setRetransmitTimeouts(this.interval);
    }

    public AckSenderWindow(RetransmitCommand com, Interval interval, TimeScheduler sched) {
        this.retransmit_command = com;
        this.interval = interval;
        this.retransmitter = new Retransmitter(null, this, sched);
        this.retransmitter.setRetransmitTimeouts(interval);
    }

    public AckSenderWindow(RetransmitCommand com, Interval interval, TimeScheduler sched, Address sender) {
        this.retransmit_command = com;
        this.interval = interval;
        this.retransmitter = new Retransmitter(sender, this, sched);
        this.retransmitter.setRetransmitTimeouts(interval);
    }

    public void reset() {
        this.msgs.clear();
        this.retransmitter.reset();
    }

    public void add(long seqno, Message msg) {
        this.msgs.putIfAbsent(seqno, msg);
        this.retransmitter.add(seqno, seqno);
    }

    public synchronized void ack(long seqno) {
        Long tmp;
        if (this.lowest == 0L && (tmp = this.getLowestSeqno()) != null) {
            this.lowest = tmp;
        }
        for (long i = this.lowest; i <= seqno; ++i) {
            this.msgs.remove(i);
            this.retransmitter.remove(i);
        }
        this.lowest = seqno + 1L;
    }

    public Message getLowestMessage() {
        Set keys = this.msgs.keySet();
        if (keys.isEmpty()) {
            return null;
        }
        Long seqno = (Long)Collections.min(keys);
        return seqno != null ? (Message)this.msgs.get(seqno) : null;
    }

    public int size() {
        return this.msgs.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.msgs.size()).append(" msgs (").append(this.retransmitter.size()).append(" to retransmit): ");
        TreeSet keys = new TreeSet(this.msgs.keySet());
        if (!keys.isEmpty()) {
            sb.append(keys.first()).append(" - ").append(keys.last());
        } else {
            sb.append("[]");
        }
        return sb.toString();
    }

    public String printDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.msgs.size()).append(" msgs (").append(this.retransmitter.size()).append(" to retransmit): ").append(new TreeSet(this.msgs.keySet()));
        return sb.toString();
    }

    public void retransmit(long first_seqno, long last_seqno, Address sender) {
        if (this.retransmit_command != null) {
            if (log.isTraceEnabled()) {
                log.trace(new StringBuilder("retransmitting messages ").append(first_seqno).append(" - ").append(last_seqno).append(" from ").append(sender));
            }
            for (long i = first_seqno; i <= last_seqno; ++i) {
                Message msg = (Message)this.msgs.get(i);
                if (msg == null) continue;
                this.retransmit_command.retransmit(i, msg);
            }
        }
    }

    public Long getLowestSeqno() {
        Set keys = this.msgs.keySet();
        return keys != null ? (Long)Collections.min(keys) : null;
    }

    static class Dummy
    implements RetransmitCommand {
        static final long last_xmit_req = 0L;
        long curr_time;

        Dummy() {
        }

        public void retransmit(long seqno, Message msg) {
            if (log.isDebugEnabled()) {
                log.debug("seqno=" + seqno);
            }
            this.curr_time = System.currentTimeMillis();
        }
    }

    static class Entry {
        final long seqno;
        final Message msg;

        Entry(long seqno, Message msg) {
            this.seqno = seqno;
            this.msg = msg;
        }
    }

    public static interface RetransmitCommand {
        public void retransmit(long var1, Message var3);
    }
}

