/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import org.jgroups.Address;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.Interval;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class Retransmitter {
    private static final long SEC = 1000L;
    private Interval RETRANSMIT_TIMEOUTS = new StaticInterval(2000L, 3000L, 5000L, 8000L);
    private Address sender = null;
    private final ConcurrentMap<Long, Task> msgs = new ConcurrentHashMap<Long, Task>(11);
    private RetransmitCommand cmd = null;
    private TimeScheduler timer = null;
    protected static final Log log = LogFactory.getLog(Retransmitter.class);

    public Retransmitter(Address sender, RetransmitCommand cmd, TimeScheduler sched) {
        this.init(sender, cmd, sched);
    }

    public void setRetransmitTimeouts(Interval interval) {
        if (interval != null) {
            this.RETRANSMIT_TIMEOUTS = interval;
        }
    }

    public void add(long first_seqno, long last_seqno) {
        if (first_seqno > last_seqno) {
            long tmp = first_seqno;
            first_seqno = last_seqno;
            last_seqno = tmp;
        }
        for (long seqno = first_seqno; seqno <= last_seqno; ++seqno) {
            Task new_task = new Task(seqno, this.RETRANSMIT_TIMEOUTS.copy(), this.cmd, this.sender);
            Task old_task = this.msgs.putIfAbsent(seqno, new_task);
            if (old_task != null) continue;
            new_task.doSchedule(this.timer);
        }
    }

    public int remove(long seqno) {
        Task task = (Task)this.msgs.remove(seqno);
        if (task != null) {
            task.cancel();
            return task.getNumRetransmits();
        }
        return -1;
    }

    public void reset() {
        for (Task task : this.msgs.values()) {
            task.cancel();
        }
        this.msgs.clear();
    }

    public void stop() {
        this.reset();
    }

    public String toString() {
        int size = this.size();
        StringBuilder sb = new StringBuilder();
        sb.append(size).append(" messages to retransmit: ").append(this.msgs.keySet());
        return sb.toString();
    }

    public int size() {
        return this.msgs.size();
    }

    private void init(Address sender, RetransmitCommand cmd, TimeScheduler sched) {
        this.sender = sender;
        this.cmd = cmd;
        this.timer = sched;
    }

    static void sleep(long timeout) {
        Util.sleep(timeout);
    }

    static class MyXmitter
    implements RetransmitCommand {
        MyXmitter() {
        }

        public void retransmit(long first_seqno, long last_seqno, Address sender) {
            System.out.println("-- " + new Date() + ": retransmit(" + first_seqno + ", " + last_seqno + ", " + sender + ')');
        }
    }

    private static class Task
    implements TimeScheduler.Task {
        private final Interval intervals;
        private long seqno = -1L;
        private Future future;
        private Address sender = null;
        protected int num_retransmits = 0;
        private RetransmitCommand command;

        protected Task(long seqno, Interval intervals, RetransmitCommand cmd, Address sender) {
            this.seqno = seqno;
            this.intervals = intervals;
            this.command = cmd;
            this.sender = sender;
        }

        public int getNumRetransmits() {
            return this.num_retransmits;
        }

        public long nextInterval() {
            return this.intervals.next();
        }

        public void doSchedule(TimeScheduler timer) {
            this.future = timer.scheduleWithDynamicInterval(this);
        }

        public void cancel() {
            if (this.future != null) {
                this.future.cancel(false);
            }
        }

        public void run() {
            this.command.retransmit(this.seqno, this.seqno, this.sender);
            ++this.num_retransmits;
        }

        public String toString() {
            return String.valueOf(this.seqno);
        }
    }

    public static interface RetransmitCommand {
        public void retransmit(long var1, long var3, Address var5);
    }
}

