/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TUNNEL;
import org.jgroups.stack.GossipData;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterStub {
    public static final int STATUS_CONNECTED = 0;
    public static final int STATUS_DISCONNECTED = 1;
    private final String router_host;
    private final int router_port;
    private Socket sock = null;
    private DataOutputStream output = null;
    private DataInputStream input = null;
    private final Address local_addr;
    private volatile int connectionState = 1;
    private static final Log log = LogFactory.getLog(TUNNEL.class);
    private ConnectionListener conn_listener;
    private String groupname = null;
    private final InetAddress bind_addr;
    private int sock_conn_timeout = 3000;
    private int sock_read_timeout = 3000;
    private volatile boolean intentionallyDisconnected = false;

    public RouterStub(String routerHost, int routerPort, InetAddress bindAddress, Address localAddress) {
        if (localAddress == null) {
            throw new IllegalArgumentException("localAddress cannot be null");
        }
        this.router_host = routerHost != null ? routerHost : "localhost";
        this.router_port = routerPort;
        this.bind_addr = bindAddress;
        this.local_addr = localAddress;
    }

    public int getSocketConnectionTimeout() {
        return this.sock_conn_timeout;
    }

    public void setSocketConnectionTimeout(int sock_conn_timeout) {
        this.sock_conn_timeout = sock_conn_timeout;
    }

    public int getSocketReadTimeout() {
        return this.sock_read_timeout;
    }

    public void setSocketReadTimeout(int sock_read_timeout) {
        this.sock_read_timeout = sock_read_timeout;
    }

    public boolean isConnected() {
        return this.connectionState == 0;
    }

    public void setConnectionListener(ConnectionListener conn_listener) {
        this.conn_listener = conn_listener;
    }

    public Address getLocalAddress() throws SocketException {
        return this.local_addr;
    }

    public synchronized void connect(String groupname) throws Exception {
        block7: {
            if (groupname == null || groupname.length() == 0) {
                throw new Exception("groupname is null");
            }
            if (!this.isConnected()) {
                this.groupname = groupname;
                try {
                    this.sock = new Socket();
                    this.sock.bind(new InetSocketAddress(this.bind_addr, 0));
                    this.sock.setSoTimeout(this.sock_read_timeout);
                    this.sock.setSoLinger(true, 2);
                    this.sock.connect(new InetSocketAddress(this.router_host, this.router_port), this.sock_conn_timeout);
                    this.output = new DataOutputStream(this.sock.getOutputStream());
                    GossipData req = new GossipData(1, groupname, this.local_addr, null);
                    req.writeTo(this.output);
                    this.output.flush();
                    this.input = new DataInputStream(this.sock.getInputStream());
                    boolean connectedOk = this.input.readBoolean();
                    this.intentionallyDisconnected = false;
                    if (connectedOk) {
                        this.connectionStateChanged(0);
                        if (log.isDebugEnabled()) {
                            log.debug("Connected " + this + ", groupname=" + groupname);
                        }
                        break block7;
                    }
                    throw new Exception("Failed to get connection ack from gossip router");
                }
                catch (Exception e) {
                    if (log.isWarnEnabled()) {
                        log.warn(this + " failed connecting to " + this.router_host + ":" + this.router_port);
                    }
                    Util.close(this.sock);
                    Util.close(this.input);
                    Util.close(this.output);
                    this.connectionStateChanged(1);
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() {
        try {
            this.output.writeByte(2);
            this.output.flush();
        }
        catch (Exception exception) {
        }
        finally {
            Util.close(this.output);
            Util.close(this.input);
            Util.close(this.sock);
            this.sock = null;
            this.intentionallyDisconnected = true;
            this.connectionStateChanged(1);
        }
    }

    public boolean isIntentionallyDisconnected() {
        return this.intentionallyDisconnected;
    }

    public synchronized List<Address> getMembers(String group, long timeout) throws Exception {
        List<Address> mbrs = new LinkedList<Address>();
        try {
            this.output.writeByte(4);
            this.output.writeUTF(this.groupname);
            this.output.flush();
            mbrs = (List)Util.readAddresses(this.input, LinkedList.class);
        }
        catch (SocketException se) {
            if (log.isWarnEnabled()) {
                log.warn("Router stub " + this + " did not send message", se);
            }
            this.connectionStateChanged(1);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Router stub " + this + " failed sending message to router");
            }
            this.connectionStateChanged(1);
            throw new Exception("Connection broken", e);
        }
        return mbrs;
    }

    public InetSocketAddress getGossipRouterAddress() {
        return new InetSocketAddress(this.router_host, this.router_port);
    }

    public String toString() {
        return "RouterStub[local_address=" + this.local_addr + ",router_host=" + this.router_host + ",router_port=" + this.router_port + ",connected=" + this.isConnected() + "]";
    }

    public void sendToAllMembers(byte[] data, int offset, int length) throws Exception {
        this.sendToSingleMember(null, data, offset, length);
    }

    public synchronized void sendToSingleMember(Address dest, byte[] data, int offset, int length) throws Exception {
        try {
            this.output.writeByte(10);
            this.output.writeUTF(this.groupname);
            Util.writeAddress(dest, this.output);
            this.output.writeInt(data.length);
            this.output.write(data, 0, data.length);
            this.output.flush();
        }
        catch (SocketException se) {
            if (log.isWarnEnabled()) {
                log.warn("Router stub " + this + " did not send message to " + (dest == null ? "mcast" : dest + " since underlying socket is closed"), se);
            }
            this.connectionStateChanged(1);
            throw new Exception("dest=" + dest + " (" + length + " bytes)", se);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Router stub " + this + " failed sending message to router");
            }
            this.connectionStateChanged(1);
            throw new Exception("dest=" + dest + " (" + length + " bytes)", e);
        }
    }

    public DataInputStream getInputStream() {
        return this.input;
    }

    private void connectionStateChanged(int newState) {
        boolean notify = this.connectionState != newState;
        this.connectionState = newState;
        if (notify && this.conn_listener != null) {
            try {
                this.conn_listener.connectionStatusChange(newState);
            }
            catch (Throwable t) {
                log.error("failed notifying ConnectionListener " + this.conn_listener, t);
            }
        }
    }

    public static interface ConnectionListener {
        public void connectionStatusChange(int var1);
    }
}

