/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.statement;

import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.statement.SelectStatement;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class SelectKeyStatement
extends SelectStatement {
    private String keyProperty;
    private boolean runAfterSQL;
    private String generatedKeyColumn;

    public String getKeyProperty() {
        return this.keyProperty;
    }

    public void setKeyProperty(String keyProperty) {
        this.keyProperty = keyProperty;
    }

    public boolean isRunAfterSQL() {
        return this.runAfterSQL;
    }

    public void setRunAfterSQL(boolean runAfterSQL) {
        this.runAfterSQL = runAfterSQL;
    }

    public boolean isUseGeneratedKey() {
        return this.generatedKeyColumn != null;
    }

    public String getGeneratedKeyColumn() {
        return this.generatedKeyColumn;
    }

    public void setGeneratedKeyColumn(String generatedKeyColumn) {
        this.generatedKeyColumn = generatedKeyColumn;
    }

    public List executeQueryForList(StatementScope statementScope, Transaction trans, Object parameterObject, int skipResults, int maxResults) throws SQLException {
        throw new SQLException("Select Key statements cannot be executed for a list.");
    }

    public void executeQueryWithRowHandler(StatementScope statementScope, Transaction trans, Object parameterObject, RowHandler rowHandler) throws SQLException {
        throw new SQLException("Select Key statements cannot be executed with a row handler.");
    }

    protected void executeQueryWithCallback(StatementScope statementScope, Connection conn, Object parameterObject, Object resultObject, RowHandler rowHandler, int skipResults, int maxResults) throws SQLException {
        if (this.generatedKeyColumn == null) {
            super.executeQueryWithCallback(statementScope, conn, parameterObject, resultObject, rowHandler, skipResults, maxResults);
        } else {
            Object generatedKey = GeneratedKeyThreadLocal.getKey();
            if (generatedKey == null) {
                throw new SQLException("No generated key value available for column: " + this.generatedKeyColumn);
            }
            ResultMap resultMap = this.getSql().getResultMap(statementScope, parameterObject);
            Class resultType = resultMap.getResultClass();
            if (!resultType.isAssignableFrom(generatedKey.getClass())) {
                TypeHandler resultTypeHandler = new TypeHandlerFactory().getTypeHandler(resultType);
                generatedKey = resultTypeHandler.valueOf(generatedKey.toString());
            }
            rowHandler.handleRow(generatedKey);
        }
    }

    public static class GeneratedKeyThreadLocal {
        private static final ThreadLocal tl = new ThreadLocal();

        public static final Object getKey() {
            return tl.get();
        }

        public static final void setKey(Object key) {
            tl.set(key);
        }

        public static final void clear() {
            tl.remove();
        }
    }
}

