/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.client.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpMethod;

public final class AutoReleasingInputStream
extends FilterInputStream {
    private final HttpMethod method;

    public AutoReleasingInputStream(HttpMethod method, InputStream in) {
        super(in);
        this.method = method;
    }

    public int read() throws IOException {
        if (this.in == null) {
            return -1;
        }
        try {
            int r = super.read();
            if (r == -1) {
                this.method.releaseConnection();
            }
            return r;
        }
        catch (IOException e) {
            if (this.method != null) {
                this.method.releaseConnection();
            }
            throw e;
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.in == null) {
            return -1;
        }
        try {
            int r = super.read(b, off, len);
            if (r == -1) {
                this.method.releaseConnection();
            }
            return r;
        }
        catch (IOException e) {
            if (this.method != null) {
                this.method.releaseConnection();
            }
            throw e;
        }
    }
}

