/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.taglib.core;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentBodyTag;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.MyfacesStateManager;
import org.apache.myfaces.application.jsp.JspViewHandlerImpl;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlLinkRendererBase;
import org.apache.myfaces.shared_impl.util.LocaleUtils;

public class ViewTag
extends UIComponentBodyTag {
    private static final Log log = LogFactory.getLog(ViewTag.class);
    private String _locale;

    public String getComponentType() {
        return "javax.faces.ViewRoot";
    }

    public String getRendererType() {
        return null;
    }

    public void setLocale(String string) {
        this._locale = string;
    }

    public int doStartTag() throws JspException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"entering ViewTag.doStartTag");
        }
        super.doStartTag();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        try {
            responseWriter.startDocument();
        }
        catch (IOException iOException) {
            log.error((Object)"Error writing startDocument", (Throwable)iOException);
            throw new JspException((Throwable)iOException);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"leaving ViewTag.doStartTag");
        }
        return 2;
    }

    protected boolean isSuppressed() {
        return true;
    }

    public int doEndTag() throws JspException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"entering ViewTag.doEndTag");
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        try {
            responseWriter.endDocument();
        }
        catch (IOException iOException) {
            log.error((Object)"Error writing endDocument", (Throwable)iOException);
            throw new JspException((Throwable)iOException);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"leaving ViewTag.doEndTag");
        }
        return super.doEndTag();
    }

    public int doAfterBody() throws JspException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"entering ViewTag.doAfterBody");
        }
        try {
            BodyContent bodyContent = this.getBodyContent();
            if (bodyContent != null) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                StateManager stateManager = facesContext.getApplication().getStateManager();
                StateManager.SerializedView serializedView = stateManager.saveSerializedView(facesContext);
                ResponseWriter responseWriter = facesContext.getResponseWriter();
                responseWriter.flush();
                ResponseWriter responseWriter2 = responseWriter.cloneWithWriter((Writer)this.getPreviousOut());
                facesContext.setResponseWriter(responseWriter2);
                String string = bodyContent.getString();
                int n = string.lastIndexOf("<!--@@JSF_FORM_STATE_MARKER@@-->");
                int n2 = -1;
                if (stateManager.isSavingStateInClient(facesContext)) {
                    n2 = string.lastIndexOf("JSF_URL_STATE_MARKER=DUMMY");
                }
                int n3 = 0;
                while (n != -1 || n2 != -1) {
                    if (n2 == -1 || n != -1 && n < n2) {
                        responseWriter2.write(string, n3, n - n3);
                        stateManager.writeState(facesContext, serializedView);
                        n3 = n + JspViewHandlerImpl.FORM_STATE_MARKER_LEN;
                        n = string.indexOf("<!--@@JSF_FORM_STATE_MARKER@@-->", n3);
                        continue;
                    }
                    responseWriter2.write(string, n3, n2 - n3);
                    if (stateManager instanceof MyfacesStateManager) {
                        ((MyfacesStateManager)stateManager).writeStateAsUrlParams(facesContext, serializedView);
                    } else {
                        log.error((Object)"Current StateManager is no MyfacesStateManager and does not support saving state in url parameters.");
                    }
                    n3 = n2 + HtmlLinkRendererBase.URL_STATE_MARKER_LEN;
                    n2 = string.indexOf("JSF_URL_STATE_MARKER=DUMMY", n3);
                }
                responseWriter2.write(string, n3, string.length() - n3);
            }
        }
        catch (IOException iOException) {
            log.error((Object)"Error writing body content", (Throwable)iOException);
            throw new JspException((Throwable)iOException);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"leaving ViewTag.doAfterBody");
        }
        return super.doAfterBody();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setProperties(UIComponent uIComponent) {
        block6: {
            Locale locale;
            block5: {
                block7: {
                    super.setProperties(uIComponent);
                    if (this._locale == null) break block6;
                    if (!UIComponentTag.isValueReference((String)this._locale)) break block7;
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    ValueBinding valueBinding = facesContext.getApplication().createValueBinding(this._locale);
                    Object object = valueBinding.getValue(facesContext);
                    if (object instanceof Locale) {
                        locale = (Locale)object;
                        break block5;
                    } else if (object instanceof String) {
                        locale = LocaleUtils.toLocale((String)object);
                        break block5;
                    } else {
                        if (object != null) {
                            throw new IllegalArgumentException("Locale or String class expected. Expression: " + this._locale + ". Return class: " + object.getClass().getName());
                        }
                        throw new IllegalArgumentException("Locale or String class expected. Expression: " + this._locale + ". Return value null");
                    }
                }
                locale = LocaleUtils.toLocale(this._locale);
            }
            ((UIViewRoot)uIComponent).setLocale(locale);
            Config.set((ServletRequest)((ServletRequest)this.getFacesContext().getExternalContext().getRequest()), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)locale);
        }
    }
}

