/*
 * Decompiled with CFR 0.152.
 */
package marquee.xmlrpc;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import marquee.xmlrpc.XmlRpcCustomSerializer;
import marquee.xmlrpc.XmlRpcException;
import marquee.xmlrpc.XmlRpcValue;
import marquee.xmlrpc.serializers.CollectionSerializer;
import marquee.xmlrpc.serializers.MapSerializer;
import marquee.xmlrpc.serializers.ObjectArraySerializer;
import marquee.xmlrpc.util.Base64;

public class XmlRpcSerializer {
    private static List customSerializers = new ArrayList();

    public static void serialize(Object value, StringBuffer output) throws XmlRpcException {
        output.append("<value>");
        if (value instanceof String || value instanceof Character) {
            output.append("<string>");
            String string = value.toString();
            int length = string.length();
            block4: for (int i = 0; i < length; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '<': {
                        output.append("&lt;");
                        continue block4;
                    }
                    case '&': {
                        output.append("&amp;");
                        continue block4;
                    }
                    default: {
                        output.append(c);
                    }
                }
            }
            output.append("</string>");
        } else if (value instanceof Integer || value instanceof Byte || value instanceof Short || value instanceof Long) {
            output.append("<i4>");
            output.append(value.toString());
            output.append("</i4>");
        } else if (value instanceof Double || value instanceof Float) {
            output.append("<double>");
            output.append(value.toString());
            output.append("</double>");
        } else if (value instanceof Boolean) {
            output.append("<boolean>");
            output.append((Boolean)value == true ? "1" : "0");
            output.append("</boolean>");
        } else if (value instanceof Date) {
            output.append("<dateTime.iso8601>");
            output.append(XmlRpcValue.dateFormatter.format((Date)value));
            output.append("</dateTime.iso8601>");
        } else if (value instanceof byte[]) {
            output.append("<base64>");
            output.append(Base64.encode((byte[])value));
            output.append("</base64>");
        } else {
            for (int i = 0; i < customSerializers.size(); ++i) {
                XmlRpcCustomSerializer serializer = (XmlRpcCustomSerializer)customSerializers.get(i);
                if (!serializer.getSupportedClass().isInstance(value)) continue;
                serializer.serialize(value, output);
                output.append("</value>");
                return;
            }
            throw new XmlRpcException("Could not serialize response. Unsupported type: ".concat(String.valueOf(String.valueOf(value.getClass()))));
        }
        output.append("</value>");
    }

    public static void registerCustomSerializer(XmlRpcCustomSerializer customSerializer) {
        Class supportedClass = customSerializer.getSupportedClass();
        for (int i = 0; i < customSerializers.size(); ++i) {
            XmlRpcCustomSerializer customSerializerEntry = (XmlRpcCustomSerializer)customSerializers.get(i);
            if (!customSerializerEntry.getSupportedClass().isAssignableFrom(supportedClass)) continue;
            customSerializers.add(i, customSerializer);
            return;
        }
        customSerializers.add(customSerializer);
    }

    public static void unregisterCustomSerializer(XmlRpcCustomSerializer customSerializer) {
        customSerializers.remove(customSerializer);
    }

    static {
        customSerializers.add(new MapSerializer());
        customSerializers.add(new CollectionSerializer());
        customSerializers.add(new ObjectArraySerializer());
    }
}

