/*
 * Decompiled with CFR 0.152.
 */
package marquee.xmlrpc;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import marquee.xmlrpc.XmlRpcDispatcher;
import marquee.xmlrpc.XmlRpcInvocationHandler;
import marquee.xmlrpc.XmlRpcInvocationProcessor;
import marquee.xmlrpc.XmlRpcServerConnection;
import marquee.xmlrpc.handlers.ReflectiveInvocationHandler;
import marquee.xmlrpc.util.Log;
import marquee.xmlrpc.util.Trace;

public class XmlRpcServer {
    Map handlers = new HashMap();
    List processors = new ArrayList();

    public void runAsService(int port) throws IOException {
        ServerSocket serverSocket = new ServerSocket(port);
        if (Trace.Messages) {
            Log.append(Trace.Message, "Marquee XML-RPC Server has started on port ".concat(String.valueOf(String.valueOf(port))));
        }
        while (true) {
            Socket socket;
            String caller;
            XmlRpcDispatcher dispatcher;
            XmlRpcServerConnection connection;
            if ((connection = XmlRpcServerConnection.getConnection(dispatcher = XmlRpcDispatcher.getDispatcher(this, caller = (socket = serverSocket.accept()).getInetAddress().getHostAddress()))) != null) {
                connection.handleConnection(socket);
                continue;
            }
            if (Trace.Warnings) {
                Log.append(Trace.Warning, "Too many concurrent requests.");
            }
            BufferedOutputStream bos = new BufferedOutputStream(socket.getOutputStream());
            bos.write(XmlRpcServerConnection.ERROR);
            bos.flush();
            socket.close();
            dispatcher.release();
        }
    }

    public byte[] execute(InputStream xmlInput) throws Throwable {
        XmlRpcDispatcher dispatcher = XmlRpcDispatcher.getDispatcher(this, "(unknown)");
        byte[] result = dispatcher.dispatch(xmlInput);
        dispatcher.release();
        return result;
    }

    public void registerInvocationHandler(String name, XmlRpcInvocationHandler handler) {
        this.handlers.put(name, handler);
    }

    public void unregisterInvocationHandler(String name) {
        this.handlers.remove(name);
    }

    public void registerInvocationProcessor(XmlRpcInvocationProcessor processor) {
        this.processors.add(processor);
    }

    public void unregisterInvocationProcessor(XmlRpcInvocationProcessor processor) {
        this.processors.remove(processor);
    }

    public void registerProxyService(Object service) {
        ReflectiveInvocationHandler ih = new ReflectiveInvocationHandler(service);
        Class[] interfaces = service.getClass().getInterfaces();
        this.registerProxyService(ih, interfaces);
    }

    public void registerProxyService(Object service, String name) {
        ReflectiveInvocationHandler ih = new ReflectiveInvocationHandler(service);
        this.registerInvocationHandler(name, ih);
    }

    protected void registerProxyService(XmlRpcInvocationHandler ih, Class[] interfaces) {
        for (int i = 0; i < interfaces.length; ++i) {
            String declaringInterface = interfaces[i].getName();
            declaringInterface = declaringInterface.substring(declaringInterface.lastIndexOf(46) + 1);
            this.registerInvocationHandler(declaringInterface, ih);
        }
    }
}

