/*
 * Decompiled with CFR 0.152.
 */
package marquee.xmlrpc.processors;

import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import marquee.xmlrpc.XmlRpcInvocationProcessor;
import marquee.xmlrpc.util.Log;
import marquee.xmlrpc.util.Trace;

public class FilterInvocationProcessor
implements XmlRpcInvocationProcessor {
    private Hashtable filters = new Hashtable();

    public void addFilters(String handler, List filterList) throws IllegalArgumentException {
        if (handler == null) {
            handler = "$all";
        }
        for (int i = 0; i < filterList.size(); ++i) {
            filterList.set(i, this.convertAddress((String)filterList.get(i)));
        }
        this.filters.put(handler, filterList);
    }

    public boolean preProcess(int callId, String callerIp, String handler, String method, List arguments) {
        int[] address;
        List filterList1 = (List)this.filters.get("$all");
        List filterList2 = (List)this.filters.get(handler);
        if ((filterList1 != null || filterList2 != null) && (this.isFiltered(address = this.convertAddress(callerIp), filterList1) || this.isFiltered(address, filterList2))) {
            if (Trace.Messages) {
                Log.append(Trace.Message, String.valueOf(String.valueOf(callerIp)).concat(" tried to invoke a restricted method"));
            }
            return false;
        }
        return true;
    }

    public Object postProcess(int callId, String callerIp, String handler, String method, List arguments, Object returnValue) {
        return returnValue;
    }

    public void onException(int callId, String callerIp, String handler, String method, List arguments, Throwable exception) {
    }

    private boolean isFiltered(int[] address, List filterList) {
        if (filterList != null) {
            for (int i = 0; i < filterList.size(); ++i) {
                int j;
                int[] filter = (int[])filterList.get(i);
                for (j = 0; j < 4 && (filter[j] == 256 || address[j] == filter[j]); ++j) {
                }
                if (j != 4) continue;
                return true;
            }
        }
        return false;
    }

    private int[] convertAddress(String address) throws IllegalArgumentException {
        StringTokenizer tokenizer = new StringTokenizer(address, ".");
        if (tokenizer.countTokens() != 4) {
            throw new IllegalArgumentException("Invalid address or mask");
        }
        int[] filter = new int[4];
        for (int i = 0; i < 4; ++i) {
            String maskToken = tokenizer.nextToken();
            filter[i] = maskToken.equals("*") ? 256 : Integer.parseInt(maskToken);
        }
        return filter;
    }
}

