/*
 * Decompiled with CFR 0.152.
 */
package marquee.xmlrpc.testing;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import marquee.xmlrpc.XmlRpcClient;
import marquee.xmlrpc.XmlRpcParser;
import marquee.xmlrpc.XmlRpcSerializer;
import marquee.xmlrpc.XmlRpcServer;
import marquee.xmlrpc.handlers.ReflectiveInvocationHandler;
import marquee.xmlrpc.serializers.HashtableSerializer;
import marquee.xmlrpc.serializers.VectorSerializer;
import marquee.xmlrpc.util.Log;
import marquee.xmlrpc.util.ServerInputStream;
import marquee.xmlrpc.util.Trace;

public class ServletExample
extends HttpServlet {
    private XmlRpcServer server;

    public void init(ServletConfig config) throws ServletException {
        XmlRpcParser.setDriver("uk.co.wilson.xml.MinML");
        XmlRpcSerializer.registerCustomSerializer(new VectorSerializer());
        XmlRpcSerializer.registerCustomSerializer(new HashtableSerializer());
        this.server = new XmlRpcServer();
        this.server.registerInvocationHandler("Example", new ExampleInvocationHandler());
        this.server.registerInvocationHandler("Speller", new XmlRpcClient("www.stuffeddog.com", 80, "/speller/speller-rpc.cgi"));
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            byte[] result = this.server.execute(new ServerInputStream((InputStream)req.getInputStream(), req.getContentLength()));
            res.setContentType("text/xml");
            res.setContentLength(result.length);
            ServletOutputStream output = res.getOutputStream();
            output.write(result);
            output.flush();
        }
        catch (Throwable e) {
            System.out.println(e);
        }
    }

    public static class ExampleInvocationHandler
    extends ReflectiveInvocationHandler {
        public Hashtable echoStruct(Hashtable struct) {
            if (Trace.Debugs) {
                Log.append(Trace.Debug, "Received struct: ".concat(String.valueOf(String.valueOf(struct))));
            }
            return struct;
        }
    }
}

