/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.transport.jms.JMSExchangeSender;

class JMSOutputStream
extends CachedOutputStream {
    static final Logger LOG = LogUtils.getL7dLogger(JMSOutputStream.class);
    private final JMSExchangeSender sender;
    private Exchange exchange;
    private boolean isTextPayload;

    public JMSOutputStream(JMSExchangeSender sender, Exchange exchange, boolean isTextPayload) {
        this.sender = sender;
        this.exchange = exchange;
        this.isTextPayload = isTextPayload;
    }

    protected void doFlush() throws IOException {
    }

    protected void doClose() throws IOException {
        Object payload = this.retrieveRequestFromStream(this.isTextPayload);
        this.sender.sendExchange(this.exchange, payload);
    }

    private Object retrieveRequestFromStream(boolean isTextPayload1) throws IOException {
        Object request = null;
        try {
            if (isTextPayload1) {
                StringBuilder builder = new StringBuilder(2048);
                this.writeCacheTo(builder);
                request = builder.toString();
            } else {
                request = this.getBytes();
            }
        }
        catch (IOException ex) {
            throw new IOException("Error creating request Object from Message content, exception " + ex);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Payload to be sent out is :[" + request + "]");
        }
        return request;
    }
}

