/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import java.io.Serializable;
import org.alfresco.cmis.CMISServices;
import org.alfresco.cmis.mapping.AbstractProperty;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;

public class PathProperty
extends AbstractProperty {
    private CMISServices cmisService;

    public PathProperty(ServiceRegistry serviceRegistry, CMISServices cmisService) {
        super(serviceRegistry, "cmis:path");
        this.cmisService = cmisService;
    }

    public Serializable getValue(NodeRef nodeRef) {
        Path path = this.getServiceRegistry().getNodeService().getPath(nodeRef);
        return this.toDisplayPath(path);
    }

    private String toDisplayPath(Path path) {
        ChildAssociationRef assocRef;
        NodeRef node;
        Path.Element element;
        int i;
        StringBuilder displayPath = new StringBuilder(64);
        NodeRef rootNode = this.cmisService.getDefaultRootNodeRef();
        for (i = 0; !(i >= path.size() || (element = path.get(i)) instanceof Path.ChildAssocElement && (node = (assocRef = ((Path.ChildAssocElement)element).getRef()).getChildRef()).equals((Object)rootNode)); ++i) {
        }
        if (i == path.size()) {
            // empty if block
        }
        if (path.size() - i == 1) {
            displayPath.append("/");
        } else {
            ++i;
            while (i < path.size()) {
                element = path.get(i);
                if (element instanceof Path.ChildAssocElement) {
                    assocRef = ((Path.ChildAssocElement)element).getRef();
                    node = assocRef.getChildRef();
                    displayPath.append("/");
                    displayPath.append(this.getServiceRegistry().getNodeService().getProperty(node, ContentModel.PROP_NAME));
                }
                ++i;
            }
        }
        return displayPath.toString();
    }
}

