/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.search;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.alfresco.cmis.CMISDictionaryService;
import org.alfresco.cmis.CMISResultSet;
import org.alfresco.cmis.CMISResultSetMetaData;
import org.alfresco.cmis.CMISResultSetRow;
import org.alfresco.cmis.search.CmisFunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Column;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.repo.search.results.ResultSetSPIWrapper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISResultSetRowImpl
implements CMISResultSetRow {
    private CMISResultSet resultSet;
    private int index;
    private Map<String, Float> scores;
    private NodeService nodeService;
    private Map<String, NodeRef> nodeRefs;
    private Query query;
    private CMISDictionaryService cmisDictionaryService;

    public CMISResultSetRowImpl(CMISResultSet resultSet, int index, Map<String, Float> scores, NodeService nodeService, Map<String, NodeRef> nodeRefs, Query query, CMISDictionaryService cmisDictionaryService) {
        this.resultSet = resultSet;
        this.index = index;
        this.scores = scores;
        this.nodeService = nodeService;
        this.nodeRefs = nodeRefs;
        this.query = query;
        this.cmisDictionaryService = cmisDictionaryService;
    }

    public int getIndex() {
        return this.index;
    }

    public ResultSet getResultSet() {
        return new ResultSetSPIWrapper<CMISResultSetRow, CMISResultSetMetaData>(this.resultSet);
    }

    public float getScore() {
        float count = 0.0f;
        float overall = 0.0f;
        for (Float score : this.scores.values()) {
            overall = overall * (count / (count + 1.0f)) + score.floatValue() / (count + 1.0f);
        }
        return overall;
    }

    public float getScore(String selectorName) {
        return this.scores.get(selectorName).floatValue();
    }

    public Map<String, Float> getScores() {
        return this.scores;
    }

    public NodeRef getNodeRef(String selectorName) {
        return this.nodeRefs.get(selectorName);
    }

    public Map<String, NodeRef> getNodeRefs() {
        return this.nodeRefs;
    }

    public Serializable getValue(String columnName) {
        CmisFunctionEvaluationContext context = new CmisFunctionEvaluationContext();
        context.setCmisDictionaryService(this.cmisDictionaryService);
        context.setNodeRefs(this.nodeRefs);
        context.setNodeService(this.nodeService);
        context.setScores(this.scores);
        context.setScore(Float.valueOf(this.getScore()));
        for (Column column : this.query.getColumns()) {
            PropertyArgument arg;
            if (column.getAlias().equals(columnName)) {
                return column.getFunction().getValue(column.getFunctionArguments(), (FunctionEvaluationContext)context);
            }
            if (this.nodeRefs.size() == 1) {
                if (!column.getFunction().getName().equals("PropertyAccessor")) continue;
                arg = (PropertyArgument)column.getFunctionArguments().get("Property");
                String propertyName = arg.getPropertyName();
                if (propertyName.equals(columnName)) {
                    return column.getFunction().getValue(column.getFunctionArguments(), (FunctionEvaluationContext)context);
                }
                StringBuilder builder = new StringBuilder();
                builder.append(arg.getSelector()).append(".").append(propertyName);
                propertyName = builder.toString();
                if (!propertyName.equals(columnName)) continue;
                return column.getFunction().getValue(column.getFunctionArguments(), (FunctionEvaluationContext)context);
            }
            if (!column.getFunction().getName().equals("PropertyAccessor")) continue;
            arg = (PropertyArgument)column.getFunctionArguments().get("Property");
            StringBuilder builder = new StringBuilder();
            builder.append(arg.getSelector()).append(".").append(arg.getPropertyName());
            String propertyName = builder.toString();
            if (!propertyName.equals(columnName)) continue;
            return column.getFunction().getValue(column.getFunctionArguments(), (FunctionEvaluationContext)context);
        }
        return null;
    }

    public Map<String, Serializable> getValues() {
        LinkedHashMap<String, Serializable> answer = new LinkedHashMap<String, Serializable>();
        for (String column : this.resultSet.getMetaData().getColumnNames()) {
            answer.put(column, this.getValue(column));
        }
        return answer;
    }

    @Override
    public CMISResultSet getCMISResultSet() {
        return this.resultSet;
    }

    public ChildAssociationRef getChildAssocRef() {
        NodeRef nodeRef = this.getNodeRef();
        return this.nodeService.getPrimaryParent(nodeRef);
    }

    public NodeRef getNodeRef() {
        if (this.nodeRefs.size() == 1) {
            return this.nodeRefs.values().iterator().next();
        }
        if (this.allNodeRefsEqual(this.nodeRefs)) {
            return this.nodeRefs.values().iterator().next();
        }
        throw new UnsupportedOperationException("Ambiguous selector");
    }

    private boolean allNodeRefsEqual(Map<String, NodeRef> selected) {
        NodeRef last = null;
        for (NodeRef current : selected.values()) {
            if (last == null) {
                last = current;
                continue;
            }
            if (last.equals((Object)current)) continue;
            return false;
        }
        return true;
    }

    public QName getQName() {
        return this.getChildAssocRef().getQName();
    }

    public Serializable getValue(QName qname) {
        throw new UnsupportedOperationException();
    }
}

