/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys;

import java.io.IOException;
import java.io.PrintStream;
import java.net.SocketException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.jlan.ftp.FTPConfigSection;
import org.alfresco.jlan.ftp.FTPServer;
import org.alfresco.jlan.server.NetworkServer;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class FTPServerBean
extends AbstractLifecycleBean {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.ftp.server");
    private ServerConfiguration filesysConfig;
    private FTPConfigSection m_ftpConfig;
    private FTPServer ftpServer;

    public FTPServerBean(ServerConfiguration serverConfig) {
        this.filesysConfig = serverConfig;
    }

    public final ServerConfiguration getConfiguration() {
        return this.filesysConfig;
    }

    public boolean isStarted() {
        return this.ftpServer != null && this.filesysConfig.isServerRunning("FTP");
    }

    public final void startServer() throws SocketException, IOException {
        try {
            this.m_ftpConfig = (FTPConfigSection)this.filesysConfig.getConfigSection("FTP");
            if (this.m_ftpConfig != null) {
                this.ftpServer = new FTPServer(this.filesysConfig);
                this.filesysConfig.addServer((NetworkServer)this.ftpServer);
            }
            if (this.ftpServer != null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Starting server " + this.ftpServer.getProtocolName() + " ..."));
                }
                this.ftpServer.startServer();
            }
        }
        catch (Throwable e) {
            this.ftpServer = null;
            throw new AlfrescoRuntimeException("Failed to start FTP Server", e);
        }
    }

    public final void stopServer() {
        if (this.filesysConfig == null) {
            return;
        }
        if (this.ftpServer != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Shutting server " + this.ftpServer.getProtocolName() + " ..."));
            }
            this.ftpServer.shutdownServer(false);
            this.getConfiguration().removeServer(this.ftpServer.getProtocolName());
            this.ftpServer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PrintStream out = System.out;
        out.println("FTP Server Test");
        out.println("---------------");
        try {
            ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("alfresco/application-context.xml");
            FTPServerBean server = (FTPServerBean)((Object)ctx.getBean("ftpServer"));
            if (server == null) {
                throw new AlfrescoRuntimeException("Server bean 'ftpServer' not defined");
            }
            NetworkServer srv = server.getConfiguration().findServer("SMB");
            if (srv != null) {
                srv.shutdownServer(true);
            }
            if ((srv = server.getConfiguration().findServer("NetBIOS")) != null) {
                srv.shutdownServer(true);
            }
            if (server.getConfiguration().hasConfigSection("FTP")) {
                out.println("Enter 'x' to shutdown ...");
                boolean shutdown = false;
                while (!shutdown) {
                    int ch = System.in.read();
                    if (ch == 120 || ch == 88) {
                        shutdown = true;
                    }
                    FTPServerBean fTPServerBean = server;
                    synchronized (fTPServerBean) {
                        ((Object)((Object)server)).wait(20L);
                    }
                }
                server.stopServer();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(1);
    }

    protected void onBootstrap(ApplicationEvent event) {
        try {
            this.startServer();
        }
        catch (SocketException e) {
            throw new AlfrescoRuntimeException("Failed to start FTP server", (Throwable)e);
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to start FTP server", (Throwable)e);
        }
    }

    protected void onShutdown(ApplicationEvent event) {
        this.stopServer();
        this.filesysConfig = null;
    }
}

