/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.alfresco;

import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.alfresco.AlfrescoDiskDriver;
import org.alfresco.filesys.alfresco.DesktopAction;
import org.alfresco.filesys.alfresco.DesktopActionException;
import org.alfresco.filesys.alfresco.DesktopActionTable;
import org.alfresco.filesys.alfresco.IOControlHandler;
import org.alfresco.filesys.alfresco.PseudoFileImpl;
import org.alfresco.filesys.config.GlobalDesktopActionConfigBean;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.SrvDiskInfo;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFileInterface;
import org.alfresco.repo.admin.SysAdminParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AlfrescoContext
extends DiskDeviceContext {
    private SysAdminParams sysAdminParams;
    public static final int DBG_FILE = 1;
    public static final int DBG_FILEIO = 2;
    public static final int DBG_SEARCH = 4;
    public static final int DBG_INFO = 8;
    public static final int DBG_LOCK = 16;
    public static final int DBG_PSEUDO = 32;
    public static final int DBG_RENAME = 64;
    private static final String[] m_filesysDebugStr = new String[]{"FILE", "FILEIO", "SEARCH", "INFO", "LOCK", "PSEUDO", "RENAME"};
    private String m_urlFileName;
    private PseudoFileInterface m_pseudoFileInterface;
    private GlobalDesktopActionConfigBean m_globalDesktopActionConfig = new GlobalDesktopActionConfigBean();
    private DesktopActionTable m_desktopActions;
    private List<DesktopAction> m_desktopActionsToInitialize;
    private IOControlHandler m_ioHandler;
    public int m_debug;

    public AlfrescoContext() {
        this.setDiskInformation(new SrvDiskInfo(2560000, 64, 512, 2304000));
        this.setFilesystemAttributes(7);
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public SysAdminParams getSysAdminParams() {
        return this.sysAdminParams;
    }

    public void setDisableChangeNotification(boolean disableChangeNotification) {
        this.enableChangeHandler(!disableChangeNotification);
    }

    public void initialize(AlfrescoDiskDriver filesysDriver) {
        if (this.m_desktopActionsToInitialize != null) {
            for (DesktopAction desktopAction : this.m_desktopActionsToInitialize) {
                try {
                    desktopAction.initializeAction(filesysDriver, this);
                }
                catch (DesktopActionException ex) {
                    throw new AlfrescoRuntimeException("Failed to initialize desktop action", (Throwable)ex);
                }
                this.addDesktopAction(desktopAction);
            }
        }
    }

    public String getFilesystemType() {
        return "NTFS";
    }

    public final boolean hasPseudoFileInterface() {
        return this.m_pseudoFileInterface != null;
    }

    public final PseudoFileInterface getPseudoFileInterface() {
        return this.m_pseudoFileInterface;
    }

    public final void enabledPseudoFileInterface() {
        if (this.m_pseudoFileInterface == null) {
            this.m_pseudoFileInterface = new PseudoFileImpl();
        }
    }

    public final boolean hasDesktopActions() {
        return this.m_desktopActions != null;
    }

    public final DesktopActionTable getDesktopActions() {
        return this.m_desktopActions;
    }

    public final int numberOfDesktopActions() {
        return this.m_desktopActions != null ? this.m_desktopActions.numberOfActions() : 0;
    }

    public final boolean addDesktopAction(DesktopAction action) {
        if (this.m_desktopActions == null) {
            this.m_desktopActions = new DesktopActionTable();
            this.enabledPseudoFileInterface();
        }
        return this.m_desktopActions.addAction(action);
    }

    public final boolean hasIOHandler() {
        return this.m_ioHandler != null;
    }

    public final IOControlHandler getIOHandler() {
        return this.m_ioHandler;
    }

    public final boolean hasURLFile() {
        return this.m_urlFileName != null;
    }

    public final String getURLPrefix() {
        return this.sysAdminParams.getAlfrescoProtocol() + "://" + this.sysAdminParams.getAlfrescoHost() + ":" + this.sysAdminParams.getAlfrescoPort() + "/" + this.sysAdminParams.getAlfrescoContext() + "/";
    }

    public final String getURLFileName() {
        return this.m_urlFileName;
    }

    public final void setURLFileName(String urlFileName) {
        this.m_urlFileName = urlFileName;
        if (urlFileName != null) {
            if (!urlFileName.endsWith(".url")) {
                throw new AlfrescoRuntimeException("URL link file must end with .url, " + urlFileName);
            }
            this.enabledPseudoFileInterface();
        }
    }

    public final void setDesktopActions(DesktopActionTable desktopActions, DiskInterface filesysDriver) {
        Enumeration<String> names = desktopActions.enumerateActionNames();
        while (names.hasMoreElements()) {
            this.addDesktopAction(desktopActions.getAction(names.nextElement()));
        }
        if (this.numberOfDesktopActions() > 0) {
            this.m_ioHandler = this.createIOHandler(filesysDriver);
            if (this.m_ioHandler != null) {
                this.m_ioHandler.initialize((AlfrescoDiskDriver)filesysDriver, this);
            }
        }
    }

    public final void setDesktopActionList(List<DesktopAction> desktopActions) {
        this.m_desktopActionsToInitialize = desktopActions;
    }

    public void setGlobalDesktopActionConfig(GlobalDesktopActionConfigBean desktopActionConfig) {
        this.m_globalDesktopActionConfig = desktopActionConfig;
    }

    protected GlobalDesktopActionConfigBean getGlobalDesktopActionConfig() {
        return this.m_globalDesktopActionConfig;
    }

    protected abstract IOControlHandler createIOHandler(DiskInterface var1);

    protected void setIOHandler(IOControlHandler ioctlHandler) {
        this.m_ioHandler = ioctlHandler;
    }

    public final void setDebug(String flagsStr) {
        int filesysDbg = 0;
        if (flagsStr != null) {
            StringTokenizer token = new StringTokenizer(flagsStr.toUpperCase(), ",");
            while (token.hasMoreTokens()) {
                String dbg = token.nextToken().trim();
                int idx = 0;
                boolean match = false;
                while (idx < m_filesysDebugStr.length && !match) {
                    if (m_filesysDebugStr[idx].equalsIgnoreCase(dbg)) {
                        match = true;
                        continue;
                    }
                    ++idx;
                }
                if (!match) {
                    throw new AlfrescoRuntimeException("Invalid filesystem debug flag, " + dbg);
                }
                filesysDbg += 1 << idx;
            }
            this.m_debug = filesysDbg;
        }
    }

    public final boolean hasDebug(int flg) {
        return (this.m_debug & flg) != 0;
    }
}

